/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strcopydata.c,v 1.4 2002/08/18 02:44:24 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_COPYDATA -- Return copy of data in str, allocated from rpool.
**
**	Returns a new char *, allocated from specified rpool, into
**	which a '\0' terminated copy of the data in str has been copied.
**
**	Parameters:
**		rpool -- rpool to allocate new buf from.
**		str -- sm_str_P object.
**
**	Returns:
**		'\0' terminated copy of data in str.
**		NULL on error.
*/

uchar *
sm_str_copydata(sm_rpool_P rpool, sm_str_P str)
{
	uchar *data;

	SM_REQUIRE(str != NULL);

	data = (uchar *) sm_rpool_malloc(rpool, str->sm_str_len + 1);
	if (data == NULL)
		return NULL;
	sm_memcpy(data, str->sm_str_base, str->sm_str_len);
	data[str->sm_str_len] = '\0';
	return data;
}

