/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: edbc.h,v 1.3 2005/08/15 06:14:17 ca Exp $
 */

#ifndef EDBC_H
#define EDBC_H 1

#include "sm/generic.h"
#include "sm/error.h"
#include "sm/magic.h"
#include "sm/time.h"
#include "sm/mta.h"
#include "sm/pthread.h"
#include "sm/bsd-tree.h"
#include "sm/queue.h"
#include "sm/edbc.h"

/*
**  Envelope database cache tree node.
**  Contains link to list of nodes.
*/

struct edbc_tnode_S
{
	RB_ENTRY(edbc_tnode_S)	 ectn_entry;
	ecn_hd_T		 ectn_hd;	/* head of list */
};

/*
**  NOTE: do not change this to another queue type
**  Some algorithms (edbc_next()) require that TAILQ_END(ectn_hd) is NULL.
*/

#define ECNL_INIT(ectn_hd)	TAILQ_INIT(ectn_hd)
#define ECNL_FIRST(ectn_hd)	TAILQ_FIRST(ectn_hd)
#define ECNL_END(ectn_hd)	TAILQ_END(ectn_hd)
#define ECNL_EMPTY(ectn_hd)	TAILQ_EMPTY(ectn_hd)
#define ECNL_NEXT(ecn)		TAILQ_NEXT(ecn, ecn_link)
#define ECNL_PRE(ectn_hd, ecn)	TAILQ_INSERT_HEAD(ectn_hd, ecn, ecn_link)
#define ECNL_APP(ectn_hd, ecn)	TAILQ_INSERT_TAIL(ectn_hd, ecn, ecn_link)
#define ECNL_REMOVE(ectn_hd, ecn) TAILQ_REMOVE(ectn_hd, ecn, ecn_link)

RB_PROTOTYPE(edbc_tree_S, edbc_tnode_S, ectn_entry, edbc_cmp)

#endif /* EDBC_H */
