/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-edblog-0.c,v 1.2 2005/04/07 22:03:16 ca Exp $")
#include "sm/io.h"
#include "sm/error.h"
#include "sm/edb.h"
#include "sm/log.h"
#include "log.h"
#include "sm/test.h"

sm_log_ctx_P	 edbl_lctx;
sm_logconfig_P	 edbl_lcfg;

static sm_ret_T
test_init(int edbl_loglevel)
{
	sm_ret_T ret;

	edbl_lctx = NULL;
	edbl_lcfg = NULL;
	ret = sm_log_create(NULL, &edbl_lctx, &edbl_lcfg);
	SM_TEST(sm_is_success(ret));
	if (sm_is_err(ret))
		goto done;
	ret = sm_log_setfp_fd(edbl_lctx, smioerr, SMIOERR_FILENO);
	SM_TEST(sm_is_success(ret));
	if (sm_is_err(ret))
		goto done;
	ret = sm_log_setdebuglevel(edbl_lctx, edbl_loglevel);
	SM_TEST(sm_is_success(ret));
	if (sm_is_err(ret))
		goto done;

  done:
	return ret;
}

static sm_ret_T
edblogtest(void)
{
	sm_ret_T ret;
	edb_ctx_P edb_ctx;
	edb_cnf_T edb_cnf;

	edb_ctx = NULL;
	sm_memzero(&edb_cnf, sizeof(edb_cnf));

	edb_cnf.edbcnf_logdir = "/nosuchfile/or/directory/really";
	ret = edb_open(&edb_cnf, edbl_lctx, &edb_ctx);
	SM_TEST(ret == sm_error_perm(SM_EM_EDB, DB_RUNRECOVERY));

	return ret;
}

int
main(int argc, char *argv[])
{
	int c, ll;
	sm_ret_T ret;

	ll = 9;
	while ((c = getopt(argc, argv, "?")) != -1)
	{
		switch (c)
		{
#if 0
		  default:
			usage(argv[0]);
			return(1);
#endif
		}
	}

	sm_test_begin(argc, argv, "test log2");

	ret = test_init(ll);
	SM_TEST(sm_is_success(ret));
	if (sm_is_err(ret))
		goto done;

	(void) mkdir(EDB_HOME, 0755); /* ignore errors */

	(void) edblogtest();

	sm_log_destroy(edbl_lctx);
  done:
	return sm_test_end();
}
