/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: smreplycodes.h,v 1.6 2005/08/11 18:10:59 ca Exp $
 */

#ifndef SM_SMREPLYCODES_H
#define SM_SMREPLYCODES_H 1

/*
**  SMTP reply codes.
**  These are also used as return values from policy/mail filters.
**
**  Some of the return values are outside the SMTP reply code;
**  is there a better way to return different OK codes?
*/

#define SMTP_R_OK	0	/* accept this command */
#define SMTP_R_RELAY	8	/* allow relaying */
#define SMTP_R_DISCARD	90	/* discard entity (other code?) */
/* #define SMTP_R_TXT	100	 * check the error text */
/* #define SMTP_R_ACC	250 */
#define SMTP_R_CONT	350	/* CONTinue */
/* #define SMTP_R_DUNNO	SMTP_R_CONT unused */
/* #define SMTP_R_SKIP	which code? */
#define SMTP_R_SSD	421	/* Session Shutting Down */
#define SMTP_R_TEMP	450
#define SMTP_R_SYNTAX	551
#define SMTP_R_REJECT	550
#define SMTP_R_PERM	SMTP_R_REJECT

/*
**  A result from SMAR/pmilter can return additional flags,
**  the lower 16 bits are reserved for a "normal" return value.
**  Note: these values MUST be coordinated with sm/smar.h!
*/

#define SMTP_R_QUICK	0x00010000	/* "QUICK" flag */
#define SMTP_R_GREY	0x00080000	/* "GREY" flag */

/* set QUICK flag */
#define SMTP_R_SET_QUICK(ret)	((ret) | SMTP_R_QUICK)
#define SMTP_R_SET_GREY(ret)	((ret) | SMTP_R_GREY)

/* accept entire session/transaction, disable subsequent checks */
#define SMTP_R_ACCEPT	SMTP_R_SET_QUICK(SMTP_R_OK)

#endif /* SM_SMREPLYCODES_H */
