/*
 * Copyright (c) 2002-2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: dbrecords.h,v 1.13 2005/06/09 23:34:38 ca Exp $
 */

#ifndef SM_DBRECORDS_H
#define SM_DBRECORDS_H 1

#include "sm/generic.h"

#define RECT_CONT		0x80000000	/* continues in next record */

/*
**  XXX should these types contain a type specifier?
**  For example:
**	0x04	uint32_t
**	0x02	str
**	0x01	uchar *
**  That might help to write generic(?) en/decode functions.
**  However, how can we (un)pack into(from) an unknown struct?
**  Could we do some hacking with offsetof()? I doubt it.
*/

#define RECT_IBDB_TA		0x0100	/* transaction record (sender) */
#define RECT_IBDB_TAID		0x0101	/* transaction ID */
#define RECT_IBDB_CDBID		0x0102	/* CDB ID */
#define RECT_IBDB_NRCPTS	0x0103	/* nrcpts */
#define RECT_IBDB_MAIL		0x0104	/* sender address */
#define RECT_IBDB_TA_ST		0x0110	/* transaction status */
#define IBDB_TA_NEW		0x0000	/* new transaction */
#define IBDB_TA_DONE		0x0010	/* transaction done */
				/* more detailled status: */
#define IBDB_TA_DELIV		0x0011	/*	delivered */
#define IBDB_TA_TEMP		0x0012	/*	deferred (in defedb) */
#define IBDB_TA_PERM		0x0013	/*	deferred (in defedb) */
#define IBDB_TA_CANCEL		0x0020	/*	cancelled */

#define idbd_ta_done(status)	(((status) & 0x00f0) == IBDB_TA_DONE)
#define idbd_ta_cancelled(status)	(((status) & 0x00f0) == IBDB_TA_CANCEL)

#define RECT_IBDB_RCPT		0x0200	/* recipient record */
#define RECT_IBDB_RCPT_ST	0x0210	/* recipient status */
#define RECT_IBDB_RCPT_IDX	0x0212	/* recipient index */
#define RECT_IBDB_RCPT_PA	0x0213	/* recipient printable address */

#define IBDB_RCPT_NEW		0x0000	/* new transaction */
#define IBDB_RCPT_DONE		0x0010	/* transaction done */
				/* more detailled status: */
#define IBDB_RCPT_DELIV		0x0011	/*	delivered */
#define IBDB_RCPT_TEMP		0x0012	/*	deferred (in defedb) */
#define IBDB_RCPT_PERM		0x0013	/*	deferred (in defedb) */

#define idbd_rcpt_done(status)	(((status) & 0x00f0) == IBDB_RCPT_DONE)

#define RECT_IBDB_VERS_R	0x0400	/* version record */
#define RECT_IBDB_VERS_N	0x0403	/* version number */

#endif /* SM_DBRECORDS_H */
