/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: confsetpath.h,v 1.3 2005/04/28 23:42:32 ca Exp $
 */

#ifndef SM_CONFSETPATH_H
#define SM_CONFSETPATH_H 1
#include "sm/generic.h"
#include "sm/string.h"
#include "sm/cstr.h"

sm_ret_T sm_gen_conf_path(const char *cnfdir, const char *cnfname, const char *dflt, const char **pabspath, char **pcnfabspath);

/*
**  Macro to generate map path to either the default or to the name
**  provided by the configuration.
**  If no filename is provided in the configuration (cnfname)
**  then use the default (dflt) but prepend the directory in which the
**  configuration file was found (cnfdir).
**  The resulting pathname is assigned to mappath.
*/

#define SM_GEN_MAP_PATH(mappath, cnfmappath, cnfdir, cnfname, dflt, errlbl)\
	do								\
	{								\
		sm_ret_T ret;						\
									\
		ret = sm_gen_conf_path((cnfdir), (cnfname), (dflt),	\
					&(mappath), &(cnfmappath));	\
		if (sm_is_err(ret))					\
			goto errlbl;					\
	} while (0)


#endif /* SM_CONFSETPATH_H */
