/*
 * Copyright (c) 2002, 2003 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: cmsg.h,v 1.6 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_CMSG_H
#define SM_CMSG_H 1

/*
**  We need the newer CMSG_LEN() and CMSG_SPACE() macros, but few
**   implementations support them today.  These two macros really need
**   an ALIGN() macro, but each implementation does this differently.
*/

#ifndef CMSG_LEN
# define CMSG_LEN(size)		(sizeof(struct cmsghdr) + (size))
#endif /* ! CMSG_LEN */
#ifndef CMSG_SPACE
# define CMSG_SPACE(size)	(sizeof(struct cmsghdr) + (size))
#endif /* ! CMSG_SPACE */

#if SM_USE_STATETHREADS
# include "statethreads/st.h"
# define fd_T	st_netfd_t
# define sm_sendmsg(s, msg, flags)	st_sendmsg(s, msg, flags, -1)
# define sm_recvmsg(s, msg, flags)	st_recvmsg(s, msg, flags, -1)
# define sm_read_fd	read_fd_st
# define sm_write_fd	write_fd_st
#else /* SM_USE_STATETHREADS */
# define fd_T	int
# define sm_sendmsg(s, msg, flags)	sendmsg(s, msg, flags)
# define sm_recvmsg(s, msg, flags)	recvmsg(s, msg, flags)
# define sm_read_fd	read_fd
# define sm_write_fd	write_fd
#endif /* SM_USE_STATETHREADS */

/* functions to transfer fd's over a (UNIX) socket */
ssize_t	sm_write_fd(fd_T _fd, void *_ptr, size_t _nbytes, int _sendfd);
ssize_t	sm_read_fd(fd_T _fd, void *_ptr, size_t _nbytes, int *_recvfd);

#endif /* SM_CMSG_H */
