/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-rcbclt.c,v 1.16 2005/05/31 21:00:28 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/test.h"
#include "sm/memops.h"
#include "sm/io.h"
#include "sm/ctype.h"
#include "sm/fcntl.h"
#include "sm/rcb.h"
#include "sm/unixsock.h"
#include "sm/check.h"
#include "t-rcb.h"

#include <stdio.h>

extern char *optarg;
extern int optind;
extern int optopt;
extern int opterr;

int Verbose;

void
usage(const char *prg)
{
	fprintf(stderr, "usage: %s [options] socket\n", prg);
	exit(0);
}

/* dirty hack ahead: specify timeout for function call */
#define TMO 
#include "t-rcb-sr.c"

/*
**  CLIENT -- send and receive rcb (alternating)
**
**	Parameters:
**		sockname -- name of socket
**		clientonly -- only send rcbs
**
**	Returns:
**		none
*/

void
client(char *sockname, bool clientonly)
{
	int fd;
	sm_rcb_P rcb;
	sm_ret_T ret;

	if (Verbose > 1)
		fprintf(stderr, "clt: connect\n");
	rcb = NULL;
	(void) unix_client_connect(sockname, &fd);
	if (Verbose > 1)
		fprintf(stderr, "clt: connected=%d, errno=%d\n", fd, errno);
	SM_TEST(fd >= 0);
	if (fd < 0)
		return;

	rcb = sm_rcb_new(NULL, SM_RCBSIZE, 1024 * 64);
	SM_TEST(rcb != NULL);
	if (rcb == NULL)
		goto done;

	do
	{
		if (Verbose > 3)
			fprintf(stderr, "clt: sendrcb\n");
		ret = sendrcb(rcb, fd);
		if (sm_is_err(ret))
		{
			if (Verbose > 3)
				fprintf(stderr, "clt: sendrcb=%#x\n", ret);
			break;
		}
		if (!clientonly)
		{
			if (Verbose > 3)
				fprintf(stderr, "clt: rcb_rcv\n");
			ret = rcvrcb(rcb, fd, true);
			if (sm_is_err(ret) && Verbose > 3)
				fprintf(stderr, "clt: rcvrcb=%#x\n", ret);
		}
	} while (!sm_is_err(ret));

  done:
	if (rcb != NULL)
		sm_rcb_free(rcb);
	close(fd);
}

int
main(int argc, char *argv[])
{
	int c;
	bool clientonly;
	char *sockname, *prg;

	opterr = 0;
	Verbose = 0;
	sockname = NULL;
	clientonly = false;
	prg = argv[0];
	while ((c = getopt(argc, argv, "cV")) != -1)
	{
		switch (c)
		{
		  case 'c':
			clientonly = true;
			break;
		  case 'V':
			++Verbose;
			break;
		  default:
			usage(prg);
		}
	}
	sm_test_begin(argc, argv, "unix socket rcb client");
	argc -= optind;
	argv += optind;
	if (argc <= 0)
		usage(prg);
	sockname = argv[0];
	client(sockname, clientonly);
	return sm_test_end();
}
