/* Copyright (c) 1998 Qualcomm Incorporated. All rights reserved.
 *
 * File        : dastruct.c
 * Project     : Delivery agent implementing "On Server Filtering".
 * Comments    : 
 *
 * Caution     : 
 *
 * Revisions   :
 *  xx/xx/xx   [PY]
 *         - File added.
 *
 *
 */

#include <string.h>
#include <stdlib.h>
#include "dastruct.h"

StrV* newStrV(void)
{
    return (StrV* )calloc(1,sizeof(StrV));
}

StrV* addStrV(StrV* to, char* another)
{
    StrV* t = to;
    if(t){
	while(t->nxt) t = t->nxt;
	t->nxt = newStrV();
	t->nxt->pszString = strdup(another);
    }
    return to;
}

void deleteStrV(StrV *s)
{
    if(s) {
	if(s->nxt) deleteStrV(s->nxt);
	else {
	    free(s->pszString);
	    free(s);
	}
    }
}
