/*******************************************************
 * Sieve (mail filter) execution.
 *
 * Filename:      sieve-execute.h
 * Author:        Randall Gellens
 * Last Modified: 2 November 1998
 * Version:       
 *
 * Copyright:     1998, QUALCOMM Incorporated,
 *                all rights reserved
 *******************************************************/


#ifndef __sieve_execute_def__
   #define __sieve_execute_def__


#include "sieve-struct.h"
#include "daa_headers.h"

#ifdef __cplusplus
   extern "C" {
#endif



/* 
 * Interprets a script against an incoming message, opening and parsing script
 *    file if needed.
 *
 * Parameters:
 *    fname:   pointer to full path and file name of script file.
 *    work:    pointer to an Context structure for the incoming message.
 *    action:  pointer to int which will be set to determine fate of message.
 *    flags:   PARSE_ flags (defined in sieve-struct.h).
 *    debug:   current debug value.
 *
 * Returns:
 *    0 if all went well, error code otherwise.
 *    Action is set to DAA_DISCARD, or left unchanged.
 *
 * Notes:
 *    caller must call free_script.
 *
 */
int   do_script(char *fname, Context *work, int *action, int flags, int debug);


#ifdef __cplusplus
   }
#endif

#endif /* __sieve_execute_def__ */


