/*
 * Copyright (c) 2000 Qualcomm Incorporated.  All rights reserved.
 * The file License.txt specifies the terms for use, modification,
 * and redistribution.
 *
 *
 * File: pop_extend.c 
 *
 * Revisions:
 *    06/05/00 [RCG]
 *            - CAPA IMPLEMENTATION tag omitted if SHY and not 
 *              authenticated.
 *
 *    02/09/00 [RCG]
 *            - Added AUTH-RESP-CODE.
 *
 *    03/18/98 [PY]
 *            -  File added.
 * 
 */


#include "config.h"

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <string.h>

#include "popper.h"

#ifndef HAVE_BCOPY
#  define bcopy(src,dest,len)   (void) (memcpy(dest,src,len))
#  define bzero(dest,len)       (void) (memset(dest, (char)NULL, len))
#  define bcmp(b1,b2,n)         memcmp(b1,b2,n)
#endif /* not HAVE_BCOPY */

#ifndef HAVE_INDEX
#  define index(s,c)             strchr(s,c)
#  define rindex(s,c)            strrchr(s,c)
#endif /* not HAVE_INDEX */

#ifdef SHY
#  define _shy TRUE
#else
#  define _shy FALSE
#endif /* SHY */

extern int login_delay;
extern int expire;

int 
pop_capa(p)
POP * p;

{
    fputs ( "+OK Capability list follows\r\n",   p->output );
    fputs ( "TOP\r\n",                           p->output );
    fputs ( "PIPELINING\r\n",                    p->output );
    
# if defined(SCRAM)
    fputs ( "SASL SCRAM-MD5\r\n",                p->output );
# endif

# if !defined(APOP_ONLY) && !defined(SCRAM_ONLY)
    fputs ( "USER\r\n",                          p->output );
#endif

    if ( login_delay != -1 )
        fprintf ( p->output, "LOGIN-DELAY %d\r\n", login_delay );
    if ( expire == -1 ) 
        fprintf ( p->output, "EXPIRE NEVER\r\n" );
    else
        fprintf( p->output, "EXPIRE %d\r\n", expire );

    fputs ( "UIDL\r\n",                          p->output );
    fputs ( "RESP-CODES\r\n",                    p->output );
    fputs ( "AUTH-RESP-CODE\r\n",                p->output );
    
    fputs ( "X-MANGLE\r\n",                      p->output );
    fputs ( "X-MACRO\r\n",                       p->output );
    
    fprintf ( p->output, "X-LOCALTIME %s\r\n", get_time() );

    if ( _shy == FALSE || p->CurrentState == trans ) {
        fprintf ( p->output, "IMPLEMENTATION Qpopper%.*s%s-version-%s\r\n",
                  (strlen(IMPLEMENTSFX)>0 ? 1 : 0), "-",
                  IMPLEMENTSFX, VERSION );
    }

    fputs ( ".\r\n",                             p->output );
    
    fflush ( p->output );
    return ( POP_SUCCESS );
}

MDEFRecordType mdrArr[MAX_MDEF_INDEX];
int last_index=-1;

int 
pop_mdef ( p )
POP * p;
{
    int len,current_index;
    char *char_ptr, *pt;
    MDEFRecordType local_element;
    pop_lower(p->pop_parm[1]);
    len = strlen(p->pop_parm[1]);
    char_ptr = strdup(p->pop_parm[1]);
    pt = strchr(char_ptr,'(');
    if(!pt) {
        return pop_msg(p,POP_FAILURE, HERE, "Syntax error");
    }
    *pt = '\0';
    local_element.mdef_macro = char_ptr;
    char_ptr = pt + 1;
    pt = strrchr(char_ptr,')');
    if(!pt) {
        return pop_msg(p,POP_FAILURE, HERE, "Syntax error");
    }
    *pt = '\0';
    local_element.mdef_value = char_ptr;
    for(current_index = 0; current_index <= last_index; current_index++)
        if(strcmp(mdrArr[current_index].mdef_macro, 
                  local_element.mdef_macro) == 0) {
            if(strcmp(mdrArr[current_index].mdef_value,
                      local_element.mdef_value) == 0) { 
                free(local_element.mdef_macro); /* From strdup */
                return pop_msg(p, POP_SUCCESS, HERE, "Macro \"%s\" accepted", 
                               local_element.mdef_macro);
            }
            break;
        }
    if(current_index > last_index) 
        last_index = current_index;
    if(current_index >= MAX_MDEF_INDEX) {
        free(local_element.mdef_macro); /* From strdup */
        return pop_msg(p, POP_FAILURE, HERE, 
                       "Server only takes a maximum of %d MDEFs",
                       MAX_MDEF_INDEX);
    }
    mdrArr[current_index].mdef_macro = local_element.mdef_macro;
    /* Redundant */
    mdrArr[current_index].mdef_value = local_element.mdef_value;
    return (pop_msg(p,POP_SUCCESS, HERE,"Macro \"%s\" accepted",
                    local_element.mdef_macro));
}
