/*
 * Copyright (c) 2000 QUALCOMM Incorporated.  All rights reserved.
 * The file license.txt specifies the terms for use, modification, or
 * redistribution.
 *
 */

/*
 * Revisions:
 *
 *   03/14/00  [rcg]
 *       - Handle hidden messages in pop_euidl().
 *       - Minor syntactical tweaks.
 *
 *   03/01/00  [rcg]
 *       - Handle case of hidden first message.
 *
 *   12/03/99  [rcg]:
 *       - 'UIDL x' sent an incorrect UID string if the UID contained 
 *          the '%' character, while 'UIDL' worked correctly.  This is
 *          because 'UIDL x' sends the response using pop_msg, and used
 *          the UID string as the format string.  Now it uses "%s" as
 *          the format string, and the UID string as a parameter.
 *
 */


#include <sys/types.h>
#include <stdio.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <ctype.h>
#include <string.h>

#include "config.h"

#ifndef HAVE_INDEX
#  define index(s,c)             strchr(s,c)
#endif

#if HAVE_STRINGS_H
#  include <strings.h>
#endif

#include "popper.h"

/*
 *  uidl:   POP UIDL function to list messages by message-ids
 */

pop_uidl (p)
POP     *   p;
{
    char                    buffer [ MAXLINELEN ];     /*  Read buffer */
    char                   *nl;
    char                   *bp;
    MsgInfoList            *mp;         /*  Pointer to message info list */
    int                     msg_id = 0;
    int                     x;
    int                     len    = 0;

    if ( p->parm_count == 1 ) {
        len = strlen ( p->pop_parm[1] );

        /*  
         * Convert the parameter into an integer 
         */
        msg_id = atoi ( p->pop_parm[1] );
    }

    /*  
     * Is requested message out of range? 
     */
    if ( len > 0 ) {
        if ( msg_id == 0 )
            return ( pop_msg ( p, POP_FAILURE, HERE,
                               "Parameter must be a number", 
                               p->msg_count ) );

        /*  
         * Get a pointer to the message in the message list 
         */
        mp = msg_ptr ( p, msg_id );
        if ( mp == NULL )
            return ( pop_msg ( p, POP_FAILURE, HERE, 
                               "Message %d out of range.", msg_id ) );

        if ( mp->del_flag )
            return ( pop_msg ( p, POP_FAILURE, HERE,
                               "Message %d has been marked for deletion.",
                               msg_id ) );

        sprintf ( buffer, "%d %s", msg_id, mp->uidl_str );
        nl = index ( buffer, NEWLINE );
        if ( nl != NULL ) 
            *nl = 0;
        return ( pop_msg ( p, POP_SUCCESS, HERE, "%s", buffer ) );
    } /* msg number specified */
    else { /* yes, we can do this */
        pop_msg ( p, POP_SUCCESS, HERE, "uidl command accepted." );

        for ( x = 1; x <= p->msg_count; x++ )
        {
            /*  
             * Get a pointer to the message in the message list 
             */
            mp = msg_ptr ( p, x );
            if ( mp == NULL )
                continue;

            /*  
             * Is the message flagged for deletion? 
             */
            if ( mp->del_flag )
                continue;

            sprintf ( buffer, "%d %s", 
                      mp->visible_num, 
                      mp->uidl_str );
/*          nl = index(mp->uidl_str, NEWLINE); */
            pop_sendline ( p, buffer );
/*
            if (!nl)
                fprintf(p->output, "\n");
*/
        } /* for loop */

    /*  
     * "." signals the end of a multi-line transmission 
     */
    fputs  ( ".\r\n", p->output );
    fflush ( p->output );
    } /* do all messages */

    return ( POP_SUCCESS );
}

/*
 *  euidl:   POP EUIDL function to list messages by message-ids and adds
 *           message size and From: header text as well.  This is to help
 *           the Newton do some pre-filtering before downloading messages.
 */

char *
from_hdr ( p, mp )
     POP         *p;
     MsgInfoList *mp;
{
  char  buf [ MAXLINELEN ];
  char *cp;

    fseek ( p->drop, mp->offset, 0 );
    while ( fgets ( buf, sizeof(buf), p->drop ) != NULL ) {
      if ( buf[0] == '\n' ) 
        break;    /* From header not found */
      if ( !strncasecmp ( "From:", buf, 5 ) ) {
        cp = index ( buf, ':' );
        while ( *++cp && ( *cp == ' ' || *cp == '\t' ) );
        return ( cp );
      }
    }
    return ( "" );
}

pop_euidl (p)
POP     *   p;
{
    char                    buffer [ MAXLINELEN ];     /*  Read buffer */
    char                   *nl;
    char                   *bp;
    MsgInfoList            *mp;            /*  Pointer to message info list */
    int                     msg_id = 0;
    int                     x;
    int                     len    = 0;

    if ( p->parm_count == 1 ) {
        len = strlen ( p->pop_parm[1] );

        /*  
         * Convert the parameter into an integer 
         */
        msg_id = atoi ( p->pop_parm[1] );
    }

    /*  
     * Is requested message out of range? 
     */
    if ( len > 0 && msg_id == 0 ) {
        return ( pop_msg ( p, POP_FAILURE, HERE,
                           "Parameter must be a number (range 1 to %d)", 
                           p->visible_msg_count ) );
    }

    if ( len > 0 && ( msg_id < 1 || msg_id > p->visible_msg_count ) ) {
        return ( pop_msg ( p, POP_FAILURE, HERE,
                           "Message out of range.  %d visible messages in mail drop.",
                           p->visible_msg_count ) );
    }

    if ( msg_id > 0 ) {
        /*  
         * Get a pointer to the message in the message list 
         */
        mp = msg_ptr ( p, msg_id );
        if ( mp == NULL ) {
            return ( pop_msg ( p, POP_FAILURE, HERE,
                               "Message %d out of range", msg_id ) );
        } /* bad msg */

        if ( mp->del_flag ) {
            return ( pop_msg ( p, POP_FAILURE, HERE,
                               "Message %d has been marked for deletion.",
                               msg_id ) );
        } /* deleted */
      else {
          /*
           * We have a valid message.
           */
          sprintf ( buffer, "%d %s", msg_id, mp->uidl_str );
          nl = index ( buffer, NEWLINE );
          if ( nl != NULL )
              *nl = 0;
          sprintf ( buffer, "%s %ld %s", 
                    buffer, mp->length, from_hdr ( p, mp ) );
          return  ( pop_msg ( p, POP_SUCCESS, HERE, buffer ) );
        } /* valid single message */
    } /* single message */
    else {
        /* 
         * yes, we can do this 
         */
        pop_msg ( p, POP_SUCCESS, HERE, "uidl command accepted." );

        for ( x = 1; x <= p->msg_count; x++ )
        {
            /*  
             * Get a pointer to the message in the message list 
             */
            mp = msg_ptr ( p, x );
            if ( mp == NULL )
                continue;

            /*  
             * Is the message flagged for deletion? 
             */
            if ( mp->del_flag ) 
                continue;

            sprintf ( buffer, "%d %s", x, mp->uidl_str );
            nl = index ( buffer, NEWLINE );
            if ( nl != NULL ) 
                *nl = 0;       
            sprintf ( buffer, "%s %ld %s", 
                      buffer, mp->length, from_hdr ( p, mp) );
            pop_sendline ( p, buffer );
        } /* for loop */
    } /* all messages */

    /*  
     * "." signals the end of a multi-line transmission 
     */
    fputs  ( ".\r\n", p->output );
    fflush ( p->output );

    return ( POP_SUCCESS );
}

