/*
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */


/*
 * Copyright (c) 2000 Qualcomm Incorporated.  All rights reserved.
 * The file License.txt specifies the terms for use, modification,
 * and redistribution.
 *
 * Revisions:
 *
 *  04/21/00 [RG]
 *         - Now using Qvsnprintf, Qsprintf, et al.
 *         - Removed STDC_HEADERS and K&R junk.
 *
 *  01/27/00 [RG]
 *         - Replaced snprintf() with vsnprintf() for whiter whites and
 *           brighter colors.
 *
 *  01/25/00 [RG]
 *         - Replaced sprintf() with snprintf().
 *         - Log error message if buffer size exceeded.
 *         - Replace __STDC__ with STDC_HEADERS.
 *         - Added filename and line number params; this info is now
 *           added to message.
 *
 *  03/23/98 [PY]
 *         - Added the __STDC__ stuff.
 *
 */

#include <config.h>
#include <stdio.h>
#include <sys/types.h>

#  include <stdlib.h>
#  include <stdarg.h>

#include "popper.h"

/* 
 *  log:    Make a log entry
 */

static char msgbuf [ MAXLINELEN * 2 ];

int
pop_log ( POP         *p,         /* the source of all things */
          log_level    stat,      /* log level */
          const char  *fn,        /* file name whence called */
          size_t       ln,        /* line number whence called */
          const char  *format,    /* format string to log */
          ... )                   /* parameters for format string */
{
    va_list     ap;
    char    *   date_time = NULL;
    time_t      clock;
    size_t      iLeft;
    int         iChunk;


    /* 
     * Get the information into msgbuf 
     */
    va_start ( ap, format );

    iLeft  = sizeof ( msgbuf ) -3; /* Allow for CRLF NULL at end */
    iChunk = Qvsnprintf ( msgbuf, iLeft, format, ap );

    va_end ( ap );
    
    /*
     * Append file name and line number.
     */
    if ( DEBUGGING && fn != NULL ) {
        char whence [ 512 ];
        int  len;
        
        iLeft -= ( iChunk >= 0 ? iChunk : strlen(msgbuf) );
        len    = Qsprintf ( whence, " [%s:%lu]", fn, ln );
        strncat ( msgbuf, whence, iLeft );
        iLeft -= len;
    }

    /* 
     * Depending on the status decide where to send the information 
     */
    if ( p->debug && p->trace ) {
        clock = time(0);
        date_time = (char *)ctime(&clock);
        date_time [ strlen(date_time) - 1 ] = '\0';
        fprintf ( p->trace, "%s [%d] %s\n", date_time, getpid(), msgbuf );
        fprintf ( p->trace, "%s \n", date_time );
        fflush  ( p->trace );
    }
    else {
        syslog ( (int)stat, "%s", msgbuf );
    }
    
    if ( iChunk == -1 ) {
    /* 
     * We blew out the format buffer.
     */
        if ( p->debug && p->trace ) {
            fprintf ( p->trace, "%s [%d] Buffer size exceeded logging msg: %s\n", 
                      date_time, getpid(), format );
            fprintf ( p->trace, "%s \n", date_time );
            fflush  ( p->trace );
        }
        else {
            syslog ( LOG_NOTICE, "Buffer size exceeded logging msg: %s", format );
        }
    } /* iChunk == -1 */

    return ( stat );
}
