/* ----------------------------------------------------------------------
     MIME Mangler - single pass reduction of MIME to plain text

     Laurence Lundblade <lgl@qualcomm.com>

     Copyright (c) 2000 QUALCOMM Incorporated.  All rights reserved.

     File: utils.h - a few string utilities
     Version: 0.2.3, Dec 1997
     Last Edited: 14 Feb 00 17:45

  ---- */


#ifndef _UTILSINCLUDED
#define _UTILSINCLUDED
#include <config.h>
/*------------   Types   ------------*/

typedef const char *CSTR;
typedef char *STR;

#define TRUE  1
#define FALSE 0


typedef int BOOL;


#define CHARISSPACE(c)   ((c) == 32 || (c) == '\t' || (c) == '\r' || (c) == '\n')

/* BETWEEN : TRUE is val >= min and < max */
#define BETWEEN(val, min, max)   ( ((unsigned) ((val) - (min))) < (unsigned) ((max) - (min)) )


BOOL CharEQI (char c1, char c2);

BOOL CharIsAlpha (char ch);

BOOL CharIsSgmlTok (char ch);

BOOL CharIsAlnum (char ch);

BOOL CharIsDigit (char ch);

int Constrain (int nVal, int nMin, int nMax);

int StrEQI (CSTR s1, CSTR s2);

BOOL StrBeginsI (char *szPrefix, char *sz);

int ScanInt (CSTR *pszEnt);

void StrNCat0 (char *dest, const char *src, int len);

/*
 * <CAUTION>StrNDup(): Acts the same as strdup(); 
 *  required to free the result </CAUTION>
 */
char *StrNDup (char *src, const int len);

#ifdef UNIX
void MemSet (char *dest, unsigned int len, char value);
#endif /* UNIX */

#endif /* _UTILSINCLUDED */
