#
# Copyright (c) 1994-2008 Carnegie Mellon University.  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
#
# 3. The name "Carnegie Mellon University" must not be used to
#    endorse or promote products derived from this software without
#    prior written permission. For permission or any legal
#    details, please contact
#      Carnegie Mellon University
#      Center for Technology Transfer and Enterprise Creation
#      4615 Forbes Avenue
#      Suite 302
#      Pittsburgh, PA  15213
#      (412) 268-7393, fax: (412) 268-7395
#      innovation@andrew.cmu.edu
#
# 4. Redistributions of any form whatsoever must retain the following
#    acknowledgment:
#    "This product includes software developed by Computing Services
#     at Carnegie Mellon University (http://www.cmu.edu/computing/)."
#
# CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
# THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
# FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
# OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
use ExtUtils::MakeMaker;
use Config;

my $LIB_SASL = " -lsasl2" || "-lsasl2";

$libs = "-lcyrus";

# override default xs.c rule with a VPATH-aware version
sub MY::xs_c
{
    return <<'EOT';

.xs.c: .xs
	$(XSUBPPRUN) $(XSPROTOARG) $(XSUBPPARGS) $(XSUBPP_EXTRA_ARGS) $< > $*.xsc && $(MV) $*.xsc $@

EOT
}

# xs_c above is adequate, override this to get it out of the way
sub MY::xs_o
{
    ;
}

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'	=> 'Cyrus::SIEVE::managesieve',
    'ABSTRACT'  => 'Cyrus Sieve management interface',
    'VERSION_FROM' => "../../../perl/sieve/managesieve/managesieve.pm", # finds $VERSION
    'MYEXTLIB'  => '../lib/.libs/libisieve.a ../../../perl/.libs/libcyrus.a ../../../perl/.libs/libcyrus_min.a',
    'LIBS'	=> ["$LIB_SASL -lssl -lcrypto  -lssl -lcrypto  -luuid -lz"],
    'CCFLAGS'	=> '',
    'DEFINE'	=> '-DPERL_POLLUTE',     # e.g., '-DHAVE_SOMETHING' 
    'INC'	=> "-I../../../lib -I../../../perl/sieve -I../../../perl/sieve/lib  ",
    'OBJECT'    => 'managesieve.o',
    'LD'	=> $Config{ld} . ' ',
    # This is a disgusting hack to effectively disable the stupid
    # behaviour of the generated Makefile which moves itself aside
    # on a 'make clean' instead of on 'make distclean'.
    'MAKEFILE_OLD' => 'Makefile',
);

sub MY::postamble {
    return <<'EOT';

VPATH=../../../perl/sieve/managesieve

check:

dvi:

installcheck:

EOT
}
