/*
CLASS:transport_read_state:ssh_read_state
*/
#ifndef GABA_DEFINE
struct transport_read_state
{
  struct ssh_read_state super;
  struct mac_instance *mac;
  struct crypto_instance *crypto;
  struct compress_instance *inflate;
  uint32_t seqno;
  uint8_t padding;
  uint32_t total_length;
  struct lsh_string *mac_buffer;
};
extern struct lsh_class transport_read_state_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_transport_read_state_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct transport_read_state *i = (struct transport_read_state *) o;
  mark((struct lsh_object *) i->mac);
  mark((struct lsh_object *) i->crypto);
  mark((struct lsh_object *) i->inflate);
}
static void
do_transport_read_state_free(struct lsh_object *o)
{
  struct transport_read_state *i = (struct transport_read_state *) o;
  lsh_string_free(i->mac_buffer);
}
struct lsh_class transport_read_state_class =
{
  STATIC_HEADER,
  &(ssh_read_state_class),
  "transport_read_state",
  sizeof(struct transport_read_state),
  do_transport_read_state_mark,
  do_transport_read_state_free,
};
#endif /* !GABA_DECLARE */

