/*
CLASS:exit_handler:channel_request
*/
#ifndef GABA_DEFINE
struct exit_handler
{
  struct channel_request super;
  int * exit_status;
};
extern struct lsh_class exit_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class exit_handler_class =
{
  STATIC_HEADER,
  &(channel_request_class),
  "exit_handler",
  sizeof(struct exit_handler),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:session_open_command:command
*/
#ifndef GABA_DEFINE
struct session_open_command
{
  struct command super;
  struct ssh_channel *channel;
};
extern struct lsh_class session_open_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_session_open_command_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct session_open_command *i = (struct session_open_command *) o;
  mark((struct lsh_object *) i->channel);
}
struct lsh_class session_open_command_class =
{
  STATIC_HEADER,
  &(command_class),
  "session_open_command",
  sizeof(struct session_open_command),
  do_session_open_command_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:session_channel_request:command
*/
#ifndef GABA_DEFINE
struct session_channel_request
{
  struct command super;
  int type;
  struct lsh_string *arg;
};
extern struct lsh_class session_channel_request_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_session_channel_request_free(struct lsh_object *o)
{
  struct session_channel_request *i = (struct session_channel_request *) o;
  lsh_string_free(i->arg);
}
struct lsh_class session_channel_request_class =
{
  STATIC_HEADER,
  &(command_class),
  "session_channel_request",
  sizeof(struct session_channel_request),
  NULL,
  do_session_channel_request_free,
};
#endif /* !GABA_DECLARE */

/*
CLASS:background_process_command:command
*/
#ifndef GABA_DEFINE
struct background_process_command
{
  struct command super;
  int write_pid;
};
extern struct lsh_class background_process_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class background_process_command_class =
{
  STATIC_HEADER,
  &(command_class),
  "background_process_command",
  sizeof(struct background_process_command),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

