/* pkcs1.h
 *
 * PKCS1 embedding.
 */

/* nettle, low-level cryptographics library
 *
 * Copyright (C) 2003 Niels Mller
 *  
 * The nettle library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * The nettle library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with the nettle library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifndef NETTLE_PKCS1_H_INCLUDED
#define NETTLE_PKCS1_H_INCLUDED

#include <inttypes.h>
#include <gmp.h>

struct md5_ctx;
struct sha1_ctx;

void
pkcs1_signature_prefix(unsigned length,
		       uint8_t *buffer,
		       unsigned id_length,
		       const uint8_t *id);

void
pkcs1_rsa_md5_encode(mpz_t m, unsigned length, struct md5_ctx *hash);

void
pkcs1_rsa_md5_encode_digest(mpz_t m, unsigned length, const uint8_t *digest);

void
pkcs1_rsa_sha1_encode(mpz_t m, unsigned length, struct sha1_ctx *hash);

void
pkcs1_rsa_sha1_encode_digest(mpz_t m, unsigned length, const uint8_t *digest);

#endif /* NETTLE_PKCS1_H_INCLUDED */
