/*	$NetBSD: bt_hci.h,v 1.1 2003/01/11 05:44:08 dsainty Exp $	*/

/*
 * Copyright (c) 2003 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by David Sainty <David.Sainty@dtsp.co.nz>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Constants and structures defined by the Bluetooth specification of
 * the HCI protocol.
 */

#ifndef _NETBT_BT_HCI_H_
#define	_NETBT_BT_HCI_H_

/* Event codes */

/*
 * Note: Names chosen to match FreeBSD, but without the NG prefix.
 * All taken from spec.
 */

#define	BT_HCI_EVENT_INQUIRY_COMPL		0x01
#define	BT_HCI_EVENT_INQUIRY_RESULT		0x02
#define	BT_HCI_EVENT_CON_COMPL			0x03
#define	BT_HCI_EVENT_CON_REQ			0x04
#define	BT_HCI_EVENT_DISCON_COMPL		0x05
#define	BT_HCI_EVENT_AUTH_COMPL			0x06
#define	BT_HCI_EVENT_REMOTE_NAME_REQ_COMPL	0x07
#define	BT_HCI_EVENT_ENCRYPTION_CHANGE		0x08
#define	BT_HCI_EVENT_CHANGE_CON_LINK_KEY_COMPL	0x09
#define	BT_HCI_EVENT_MASTER_LINK_KEY_COMPL	0x0a
#define	BT_HCI_EVENT_READ_REMOTE_FEATURES_COMPL	0x0b
#define	BT_HCI_EVENT_READ_REMOTE_VER_INFO_COMPL	0x0c
#define	BT_HCI_EVENT_QOS_SETUP_COMPL		0x0d
#define	BT_HCI_EVENT_COMMAND_COMPL 		0x0e
#define	BT_HCI_EVENT_COMMAND_STATUS		0x0f
#define	BT_HCI_EVENT_HARDWARE_ERROR 		0x10
#define	BT_HCI_EVENT_FLUSH_OCCUR		0x11
#define	BT_HCI_EVENT_ROLE_CHANGE		0x12
#define	BT_HCI_EVENT_NUM_COMPL_PKTS		0x13
#define	BT_HCI_EVENT_MODE_CHANGE		0x14
#define	BT_HCI_EVENT_RETURN_LINK_KEYS		0x15
#define	BT_HCI_EVENT_PIN_CODE_REQ		0x16
#define	BT_HCI_EVENT_LINK_KEY_REQ		0x17
#define	BT_HCI_EVENT_LINK_KEY_NOTIFICATION	0x18
#define	BT_HCI_EVENT_LOOPBACK_COMMAND		0x19
#define	BT_HCI_EVENT_DATA_BUFFER_OVERFLOW	0x1a
#define	BT_HCI_EVENT_MAX_SLOT_CHANGE		0x1b
#define	BT_HCI_EVENT_READ_CLOCK_OFFSET_COMPL	0x1c
#define	BT_HCI_EVENT_CON_PKT_TYPE_CHANGED	0x1d
#define	BT_HCI_EVENT_QOS_VIOLATION		0x1e
#define	BT_HCI_EVENT_PAGE_SCAN_MODE_CHANGE	0x1f
#define	BT_HCI_EVENT_PAGE_SCAN_REP_MODE_CHANGE	0x20
#define	BT_HCI_EVENT_BT_LOGO			0xfe
#define	BT_HCI_EVENT_VENDOR			0xff


/* Mask constants */
#define	BT_HCI_EVMSK_ALL			0x00000000ffffffff
#define	BT_HCI_EVMSK_NONE			0x0000000000000000

#define	BT_HCI_EVMSK_INQUIRY_COMPL		0x0000000000000001
#define	BT_HCI_EVMSK_INQUIRY_RESULT		0x0000000000000002
#define	BT_HCI_EVMSK_CON_COMPL			0x0000000000000004
#define	BT_HCI_EVMSK_CON_REQ			0x0000000000000008
#define	BT_HCI_EVMSK_DISCON_COMPL		0x0000000000000010
#define	BT_HCI_EVMSK_AUTH_COMPL			0x0000000000000020
#define	BT_HCI_EVMSK_REMOTE_NAME_REQ_COMPL	0x0000000000000040
#define	BT_HCI_EVMSK_ENCRYPTION_CHANGE		0x0000000000000080
#define	BT_HCI_EVMSK_CHANGE_CON_LINK_KEY_COMPL	0x0000000000000100
#define	BT_HCI_EVMSK_MASTER_LINK_KEY_COMPL	0x0000000000000200
#define	BT_HCI_EVMSK_READ_REMOTE_FEATURES_COMPL	0x0000000000000400
#define	BT_HCI_EVMSK_READ_REMOTE_VER_INFO_COMPL	0x0000000000000800
#define	BT_HCI_EVMSK_QOS_SETUP_COMPL		0x0000000000001000
#define	BT_HCI_EVMSK_COMMAND_COMPL 		0x0000000000002000
#define	BT_HCI_EVMSK_COMMAND_STATUS		0x0000000000004000
#define	BT_HCI_EVMSK_HARDWARE_ERROR 		0x0000000000008000
#define	BT_HCI_EVMSK_FLUSH_OCCUR		0x0000000000010000
#define	BT_HCI_EVMSK_ROLE_CHANGE		0x0000000000020000
#define	BT_HCI_EVMSK_NUM_COMPL_PKTS		0x0000000000040000
#define	BT_HCI_EVMSK_MODE_CHANGE		0x0000000000080000
#define	BT_HCI_EVMSK_RETURN_LINK_KEYS		0x0000000000100000
#define	BT_HCI_EVMSK_PIN_CODE_REQ		0x0000000000200000
#define	BT_HCI_EVMSK_LINK_KEY_REQ		0x0000000000400000
#define	BT_HCI_EVMSK_LINK_KEY_NOTIFICATION	0x0000000000800000
#define	BT_HCI_EVMSK_LOOPBACK_COMMAND		0x0000000001000000
#define	BT_HCI_EVMSK_DATA_BUFFER_OVERFLOW	0x0000000002000000
#define	BT_HCI_EVMSK_MAX_SLOT_CHANGE		0x0000000004000000
#define	BT_HCI_EVMSK_READ_CLOCK_OFFSET_COMPL	0x0000000008000000
#define	BT_HCI_EVMSK_CON_PKT_TYPE_CHANGED	0x0000000010000000
#define	BT_HCI_EVMSK_QOS_VIOLATION		0x0000000020000000
#define	BT_HCI_EVMSK_PAGE_SCAN_MODE_CHANGE	0x0000000040000000
#define	BT_HCI_EVMSK_PAGE_SCAN_REP_MODE_CHANGE	0x0000000080000000

#endif /* _NETBT_BT_HCI_H_ */
