/*	$KAME: dccp_tfrc_lookup.h,v 1.8 2005/10/21 05:33:51 nishida Exp $	*/

/*
 * Copyright (c) 2003  Nils-Erik Mattsson 
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTALL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Id: dccp_tfrc_lookup.h,v 1.5 2003/05/28 17:37:43 nilmat-8 Exp
 */

#ifndef _NETINET_DCCP_TFRC_LOOKUP_H_
#define _NETINET_DCCP_TFRC_LOOKUP_H_

const struct fixpoint fsmall_table[] = {
	{ 0LL, 1LL },					/* 0 */
	{ 163305194960931LL, 100000000000000000LL },	/* 0.00163305194960931 */
	{ 230956735363637LL, 100000000000000000LL },	/* 0.00230956735363637 */
	{ 282873259487707LL, 100000000000000000LL },	/* 0.00282873259487707 */
	{ 326645662574537LL, 100000000000000000LL },	/* 0.00326645662574537 */
	{ 365214098377853LL, 100000000000000000LL },	/* 0.00365214098377853 */
	{ 400086400001593LL, 100000000000000000LL },	/* 0.00400086400001593 */
	{ 432158256340322LL, 100000000000000000LL },	/* 0.00432158256340322 */
	{ 462013236858081LL, 100000000000000000LL },	/* 0.00462013236858081 */
	{ 490056675498551LL, 100000000000000000LL },	/* 0.00490056675498551 */
	{ 516583682704458LL, 100000000000000000LL },	/* 0.00516583682704458 */
	{ 541817034936234LL, 100000000000000000LL },	/* 0.00541817034936234 */
	{ 565929801070833LL, 100000000000000000LL },	/* 0.00565929801070833 */
	{ 589059608718062LL, 100000000000000000LL },	/* 0.00589059608718062 */
	{ 611318041778383LL, 100000000000000000LL },	/* 0.00611318041778383 */
	{ 632797058060318LL, 100000000000000000LL },	/* 0.00632797058060318 */
	{ 653573506415987LL, 100000000000000000LL },	/* 0.00653573506415987 */
	{ 673712389086595LL, 100000000000000000LL },	/* 0.00673712389086595 */
	{ 693269270671348LL, 100000000000000000LL },	/* 0.00693269270671348 */
	{ 71229209166037LL, 10000000000000000LL },	/* 0.0071229209166037 */
	{ 730822557103113LL, 100000000000000000LL },	/* 0.00730822557103113 */
	{ 748897216079408LL, 100000000000000000LL },	/* 0.00748897216079408 */
	{ 766548312170872LL, 100000000000000000LL },	/* 0.00766548312170872 */
	{ 783804461648552LL, 100000000000000000LL },	/* 0.00783804461648552 */
	{ 800691200203843LL, 100000000000000000LL },	/* 0.00800691200203843 */
	{ 817231428085712LL, 100000000000000000LL },	/* 0.00817231428085712 */
	{ 833445775806404LL, 100000000000000000LL },	/* 0.00833445775806404 */
	{ 849352907081277LL, 100000000000000000LL },	/* 0.00849352907081277 */
	{ 864969771687212LL, 100000000000000000LL },	/* 0.00864969771687212 */
	{ 880311818001545LL, 100000000000000000LL },	/* 0.00880311818001545 */
	{ 89539317281132LL, 10000000000000000LL },	/* 0.0089539317281132 */
	{ 910226794349901LL, 100000000000000000LL },	/* 0.00910226794349901 */
	{ 924824603277504LL, 100000000000000000LL },	/* 0.00924824603277504 */
	{ 939197595370597LL, 100000000000000000LL },	/* 0.00939197595370597 */
	{ 9533559389484LL, 1000000000000000LL },	/* 0.009533559389484 */
	{ 967309059489451LL, 100000000000000000LL },	/* 0.00967309059489451 */
	{ 981065713438519LL, 100000000000000000LL },	/* 0.00981065713438519 */
	{ 994634052845154LL, 100000000000000000LL },	/* 0.00994634052845154 */
	{ 100802168218855LL, 10000000000000000LL },	/* 0.0100802168218855 */
	{ 102123570851299LL, 10000000000000000LL },	/* 0.0102123570851299 */
	{ 103428278581192LL, 10000000000000000LL },	/* 0.0103428278581192 */
	{ 10471691544469LL, 1000000000000000LL },	/* 0.010471691544469 */
	{ 105990067626397LL, 10000000000000000LL },	/* 0.0105990067626397 */
	{ 107248286596785LL, 10000000000000000LL },	/* 0.0107248286596785 */
	{ 108492091922994LL, 10000000000000000LL },	/* 0.0108492091922994 */
	{ 109721973793658LL, 10000000000000000LL },	/* 0.0109721973793658 */
	{ 110938395292506LL, 10000000000000000LL },	/* 0.0110938395292506 */
	{ 112141794450653LL, 10000000000000000LL },	/* 0.0112141794450653 */
	{ 113332586103332LL, 10000000000000000LL },	/* 0.0113332586103332 */
	{ 114511163573388LL, 10000000000000000LL },	/* 0.0114511163573388 */
	{ 115677900200876LL, 10000000000000000LL },	/* 0.0115677900200876 */
	{ 116833150735621LL, 10000000000000000LL },	/* 0.0116833150735621 */
	{ 11797725260745LL, 1000000000000000LL },	/* 0.011797725260745 */
	{ 119110527086984LL, 10000000000000000LL },	/* 0.0119110527086984 */
	{ 120233280348285LL, 10000000000000000LL },	/* 0.0120233280348285 */
	{ 121345804443331LL, 10000000000000000LL },	/* 0.0121345804443331 */
	{ 122448378197079LL, 10000000000000000LL },	/* 0.0122448378197079 */
	{ 123541268030903LL, 10000000000000000LL },	/* 0.0123541268030903 */
	{ 124624728721277LL, 10000000000000000LL },	/* 0.0124624728721277 */
	{ 125699004099823LL, 10000000000000000LL },	/* 0.0125699004099823 */
	{ 126764327700174LL, 10000000000000000LL },	/* 0.0126764327700174 */
	{ 127820923356504LL, 10000000000000000LL },	/* 0.0127820923356504 */
	{ 128869005758063LL, 10000000000000000LL },	/* 0.0128869005758063 */
	{ 129908780963614LL, 10000000000000000LL },	/* 0.0129908780963614 */
	{ 130940446879258LL, 10000000000000000LL },	/* 0.0130940446879258 */
	{ 131964193702772LL, 10000000000000000LL },	/* 0.0131964193702772 */
	{ 1329802043373LL, 100000000000000LL },	/* 0.01329802043373 */
	{ 133988654776928LL, 10000000000000000LL },	/* 0.0133988654776928 */
	{ 134989714466453LL, 10000000000000000LL },	/* 0.0134989714466453 */
	{ 135983546637418LL, 10000000000000000LL },	/* 0.0135983546637418 */
	{ 136970308622305LL, 10000000000000000LL },	/* 0.0136970308622305 */
	{ 137950152148595LL, 10000000000000000LL },	/* 0.0137950152148595 */
	{ 138923223614248LL, 10000000000000000LL },	/* 0.0138923223614248 */
	{ 139889664346018LL, 10000000000000000LL },	/* 0.0139889664346018 */
	{ 140849610841894LL, 10000000000000000LL },	/* 0.0140849610841894 */
	{ 141803194998843LL, 10000000000000000LL },	/* 0.0141803194998843 */
	{ 142750544326924LL, 10000000000000000LL },	/* 0.0142750544326924 */
	{ 143691782150771LL, 10000000000000000LL },	/* 0.0143691782150771 */
	{ 144627027799322LL, 10000000000000000LL },	/* 0.0144627027799322 */
	{ 145556396784645LL, 10000000000000000LL },	/* 0.0145556396784645 */
	{ 146480000970597LL, 10000000000000000LL },	/* 0.0146480000970597 */
	{ 14739794873203LL, 1000000000000000LL },	/* 0.014739794873203 */
	{ 148310345105165LL, 10000000000000000LL },	/* 0.0148310345105165 */
	{ 149217291929752LL, 10000000000000000LL },	/* 0.0149217291929752 */
	{ 150118887983524LL, 10000000000000000LL },	/* 0.0150118887983524 */
	{ 151015229109484LL, 10000000000000000LL },	/* 0.0151015229109484 */
	{ 151906408336458LL, 10000000000000000LL },	/* 0.0151906408336458 */
	{ 152792515993363LL, 10000000000000000LL },	/* 0.0152792515993363 */
	{ 153673639817576LL, 10000000000000000LL },	/* 0.0153673639817576 */
	{ 154549865057777LL, 10000000000000000LL },	/* 0.0154549865057777 */
	{ 155421274571605LL, 10000000000000000LL },	/* 0.0155421274571605 */
	{ 156287948918437LL, 10000000000000000LL },	/* 0.0156287948918437 */
	{ 157149966447599LL, 10000000000000000LL },	/* 0.0157149966447599 */
	{ 158007403382266LL, 10000000000000000LL },	/* 0.0158007403382266 */
	{ 158860333899315LL, 10000000000000000LL },	/* 0.0158860333899315 */
	{ 159708830205358LL, 10000000000000000LL },	/* 0.0159708830205358 */
	{ 160552962609193LL, 10000000000000000LL },	/* 0.0160552962609193 */
	{ 161392799590851LL, 10000000000000000LL },	/* 0.0161392799590851 */
	{ 162228407867464LL, 10000000000000000LL },	/* 0.0162228407867464 */
	{ 163059852456097LL, 10000000000000000LL },	/* 0.0163059852456097 */
	{ 163887196733746LL, 10000000000000000LL },	/* 0.0163887196733746 */
	{ 164710502494631LL, 10000000000000000LL },	/* 0.0164710502494631 */
	{ 165529830004946LL, 10000000000000000LL },	/* 0.0165529830004946 */
	{ 166345238055199LL, 10000000000000000LL },	/* 0.0166345238055199 */
	{ 167156784010267LL, 10000000000000000LL },	/* 0.0167156784010267 */
	{ 167964523857295LL, 10000000000000000LL },	/* 0.0167964523857295 */
	{ 168768512251538LL, 10000000000000000LL },	/* 0.0168768512251538 */
	{ 169568802560266LL, 10000000000000000LL },	/* 0.0169568802560266 */
	{ 170365446904829LL, 10000000000000000LL },	/* 0.0170365446904829 */
	{ 171158496200964LL, 10000000000000000LL },	/* 0.0171158496200964 */
	{ 171948000197448LL, 10000000000000000LL },	/* 0.0171948000197448 */
	{ 172734007513173LL, 10000000000000000LL },	/* 0.0172734007513173 */
	{ 173516565672713LL, 10000000000000000LL },	/* 0.0173516565672713 */
	{ 174295721140473LL, 10000000000000000LL },	/* 0.0174295721140473 */
	{ 17507151935348LL, 1000000000000000LL },	/* 0.017507151935348 */
	{ 175844004752871LL, 10000000000000000LL },	/* 0.0175844004752871 */
	{ 17661322081417LL, 1000000000000000LL },	/* 0.017661322081417 */
	{ 177379210076372LL, 10000000000000000LL },	/* 0.0177379210076372 */
	{ 178142014169926LL, 10000000000000000LL },	/* 0.0178142014169926 */
	{ 178901673843644LL, 10000000000000000LL },	/* 0.0178901673843644 */
	{ 179658228990597LL, 10000000000000000LL },	/* 0.0179658228990597 */
	{ 180411718673042LL, 10000000000000000LL },	/* 0.0180411718673042 */
	{ 181162181146423LL, 10000000000000000LL },	/* 0.0181162181146423 */
	{ 181909653882486LL, 10000000000000000LL },	/* 0.0181909653882486 */
	{ 182654173591552LL, 10000000000000000LL },	/* 0.0182654173591552 */
	{ 183395776243984LL, 10000000000000000LL },	/* 0.0183395776243984 */
	{ 18413449709088LL, 1000000000000000LL },	/* 0.018413449709088 */
	{ 184870370684027LL, 10000000000000000LL },	/* 0.0184870370684027 */
	{ 185603430895154LL, 10000000000000000LL },	/* 0.0185603430895154 */
	{ 186333710934504LL, 10000000000000000LL },	/* 0.0186333710934504 */
	{ 187061243368762LL, 10000000000000000LL },	/* 0.0187061243368762 */
	{ 187786060138361LL, 10000000000000000LL },	/* 0.0187786060138361 */
	{ 188508192574198LL, 10000000000000000LL },	/* 0.0188508192574198 */
	{ 189227671413778LL, 10000000000000000LL },	/* 0.0189227671413778 */
	{ 189944526816812LL, 10000000000000000LL },	/* 0.0189944526816812 */
	{ 190658788380296LL, 10000000000000000LL },	/* 0.0190658788380296 */
	{ 19137048515308LL, 1000000000000000LL },	/* 0.019137048515308 */
	{ 192079645649969LL, 10000000000000000LL },	/* 0.0192079645649969 */
	{ 192786297865344LL, 10000000000000000LL },	/* 0.0192786297865344 */
	{ 193490469286358LL, 10000000000000000LL },	/* 0.0193490469286358 */
	{ 194192186905687LL, 10000000000000000LL },	/* 0.0194192186905687 */
	{ 194891477233888LL, 10000000000000000LL },	/* 0.0194891477233888 */
	{ 195588366311352LL, 10000000000000000LL },	/* 0.0195588366311352 */
	{ 196282879719884LL, 10000000000000000LL },	/* 0.0196282879719884 */
	{ 196975042593915LL, 10000000000000000LL },	/* 0.0196975042593915 */
	{ 197664879631372LL, 10000000000000000LL },	/* 0.0197664879631372 */
	{ 1983524151042LL, 100000000000000LL },	/* 0.01983524151042 */
	{ 199037672868568LL, 10000000000000000LL },	/* 0.0199037672868568 */
	{ 199720676374761LL, 10000000000000000LL },	/* 0.0199720676374761 */
	{ 200401448676771LL, 10000000000000000LL },	/* 0.0200401448676771 */
	{ 2010800124416LL, 100000000000000LL },	/* 0.02010800124416 */
	{ 20175638995828LL, 1000000000000000LL },	/* 0.020175638995828 */
	{ 202430603146631LL, 10000000000000000LL },	/* 0.0202430603146631 */
	{ 203102673565755LL, 10000000000000000LL },	/* 0.0203102673565755 */
	{ 203772622422282LL, 10000000000000000LL },	/* 0.0203772622422282 */
	{ 204440470578377LL, 10000000000000000LL },	/* 0.0204440470578377 */
	{ 205106238559511LL, 10000000000000000LL },	/* 0.0205106238559511 */
	{ 205769946562011LL, 10000000000000000LL },	/* 0.0205769946562011 */
	{ 206431614460395LL, 10000000000000000LL },	/* 0.0206431614460395 */
	{ 207091261814494LL, 10000000000000000LL },	/* 0.0207091261814494 */
	{ 207748907876375LL, 10000000000000000LL },	/* 0.0207748907876375 */
	{ 20840457159707LL, 1000000000000000LL },	/* 0.020840457159707 */
	{ 20905827163312LL, 1000000000000000LL },	/* 0.020905827163312 */
	{ 209710026352927LL, 10000000000000000LL },	/* 0.0209710026352927 */
	{ 210359853842945LL, 10000000000000000LL },	/* 0.0210359853842945 */
	{ 211007771913689LL, 10000000000000000LL },	/* 0.0211007771913689 */
	{ 211653798105588LL, 10000000000000000LL },	/* 0.0211653798105588 */
	{ 212297949694677LL, 10000000000000000LL },	/* 0.0212297949694677 */
	{ 212940243698132LL, 10000000000000000LL },	/* 0.0212940243698132 */
	{ 213580696879667LL, 10000000000000000LL },	/* 0.0213580696879667 */
	{ 214219325754774LL, 10000000000000000LL },	/* 0.0214219325754774 */
	{ 214856146595837LL, 10000000000000000LL },	/* 0.0214856146595837 */
	{ 215491175437103LL, 10000000000000000LL },	/* 0.0215491175437103 */
	{ 216124428079525LL, 10000000000000000LL },	/* 0.0216124428079525 */
	{ 216755920095483LL, 10000000000000000LL },	/* 0.0216755920095483 */
	{ 217385666833377LL, 10000000000000000LL },	/* 0.0217385666833377 */
	{ 218013683422109LL, 10000000000000000LL },	/* 0.0218013683422109 */
	{ 218639984775441LL, 10000000000000000LL },	/* 0.0218639984775441 */
	{ 219264585596254LL, 10000000000000000LL },	/* 0.0219264585596254 */
	{ 219887500380688LL, 10000000000000000LL },	/* 0.0219887500380688 */
	{ 220508743422187LL, 10000000000000000LL },	/* 0.0220508743422187 */
	{ 221128328815438LL, 10000000000000000LL },	/* 0.0221128328815438 */
	{ 22174627046021LL, 1000000000000000LL },	/* 0.022174627046021 */
	{ 22236258206511LL, 1000000000000000LL },	/* 0.022236258206511 */
	{ 222977277151227LL, 10000000000000000LL },	/* 0.0222977277151227 */
	{ 223590369055709LL, 10000000000000000LL },	/* 0.0223590369055709 */
	{ 224201870935234LL, 10000000000000000LL },	/* 0.0224201870935234 */
	{ 224811795769409LL, 10000000000000000LL },	/* 0.0224811795769409 */
	{ 225420156364085LL, 10000000000000000LL },	/* 0.0225420156364085 */
	{ 226026965354587LL, 10000000000000000LL },	/* 0.0226026965354587 */
	{ 226632235208875LL, 10000000000000000LL },	/* 0.0226632235208875 */
	{ 227235978230625LL, 10000000000000000LL },	/* 0.0227235978230625 */
	{ 22783820656224LL, 1000000000000000LL },	/* 0.022783820656224 */
	{ 228438932187787LL, 10000000000000000LL },	/* 0.0228438932187787 */
	{ 229038166935873LL, 10000000000000000LL },	/* 0.0229038166935873 */
	{ 229635922482444LL, 10000000000000000LL },	/* 0.0229635922482444 */
	{ 230232210353529LL, 10000000000000000LL },	/* 0.0230232210353529 */
	{ 230827041927913LL, 10000000000000000LL },	/* 0.0230827041927913 */
	{ 231420428439758LL, 10000000000000000LL },	/* 0.0231420428439758 */
	{ 232012380981154LL, 10000000000000000LL },	/* 0.0232012380981154 */
	{ 232602910504621LL, 10000000000000000LL },	/* 0.0232602910504621 */
	{ 233192027825551LL, 10000000000000000LL },	/* 0.0233192027825551 */
	{ 233779743624595LL, 10000000000000000LL },	/* 0.0233779743624595 */
	{ 234366068449998LL, 10000000000000000LL },	/* 0.0234366068449998 */
	{ 234951012719883LL, 10000000000000000LL },	/* 0.0234951012719883 */
	{ 235534586724479LL, 10000000000000000LL },	/* 0.0235534586724479 */
	{ 236116800628313LL, 10000000000000000LL },	/* 0.0236116800628313 */
	{ 236697664472338LL, 10000000000000000LL },	/* 0.0236697664472338 */
	{ 237277188176025LL, 10000000000000000LL },	/* 0.0237277188176025 */
	{ 23785538153941LL, 1000000000000000LL },	/* 0.023785538153941 */
	{ 238432254245091LL, 10000000000000000LL },	/* 0.0238432254245091 */
	{ 239007815860187LL, 10000000000000000LL },	/* 0.0239007815860187 */
	{ 239582075838253LL, 10000000000000000LL },	/* 0.0239582075838253 */
	{ 240155043521156LL, 10000000000000000LL },	/* 0.0240155043521156 */
	{ 240726728140909LL, 10000000000000000LL },	/* 0.0240726728140909 */
	{ 241297138821471LL, 10000000000000000LL },	/* 0.0241297138821471 */
	{ 241866284580502LL, 10000000000000000LL },	/* 0.0241866284580502 */
	{ 24243417433109LL, 1000000000000000LL },	/* 0.024243417433109 */
	{ 243000816883436LL, 10000000000000000LL },	/* 0.0243000816883436 */
	{ 243566220946503LL, 10000000000000000LL },	/* 0.0243566220946503 */
	{ 244130395129642LL, 10000000000000000LL },	/* 0.0244130395129642 */
	{ 244693347944169LL, 10000000000000000LL },	/* 0.0244693347944169 */
	{ 245255087804923LL, 10000000000000000LL },	/* 0.0245255087804923 */
	{ 245815623031787LL, 10000000000000000LL },	/* 0.0245815623031787 */
	{ 246374961851176LL, 10000000000000000LL },	/* 0.0246374961851176 */
	{ 246933112397499LL, 10000000000000000LL },	/* 0.0246933112397499 */
	{ 247490082714593LL, 10000000000000000LL },	/* 0.0247490082714593 */
	{ 248045880757123LL, 10000000000000000LL },	/* 0.0248045880757123 */
	{ 248600514391958LL, 10000000000000000LL },	/* 0.0248600514391958 */
	{ 249153991399521LL, 10000000000000000LL },	/* 0.0249153991399521 */
	{ 249706319475108LL, 10000000000000000LL },	/* 0.0249706319475108 */
	{ 250257506230185LL, 10000000000000000LL },	/* 0.0250257506230185 */
	{ 25080755919366LL, 1000000000000000LL },	/* 0.025080755919366 */
	{ 251356485813126LL, 10000000000000000LL },	/* 0.0251356485813126 */
	{ 251904293456085LL, 10000000000000000LL },	/* 0.0251904293456085 */
	{ 252450989411148LL, 10000000000000000LL },	/* 0.0252450989411148 */
	{ 252996580889205LL, 10000000000000000LL },	/* 0.0252996580889205 */
	{ 253541075024583LL, 10000000000000000LL },	/* 0.0253541075024583 */
	{ 254084478876176LL, 10000000000000000LL },	/* 0.0254084478876176 */
	{ 254626799428553LL, 10000000000000000LL },	/* 0.0254626799428553 */
	{ 25516804359305LL, 1000000000000000LL },	/* 0.025516804359305 */
	{ 255708218208836LL, 10000000000000000LL },	/* 0.0255708218208836 */
	{ 256247330043961LL, 10000000000000000LL },	/* 0.0256247330043961 */
	{ 256785385796388LL, 10000000000000000LL },	/* 0.0256785385796388 */
	{ 257322392095LL, 10000000000000LL },	/* 0.0257322392095 */
	{ 257858355500594LL, 10000000000000000LL },	/* 0.0257858355500594 */
	{ 25839328250685LL, 1000000000000000LL },	/* 0.025839328250685 */
	{ 258927179541294LL, 10000000000000000LL },	/* 0.0258927179541294 */
	{ 259460052966225LL, 10000000000000000LL },	/* 0.0259460052966225 */
	{ 259991909079647LL, 10000000000000000LL },	/* 0.0259991909079647 */
	{ 260522754116166LL, 10000000000000000LL },	/* 0.0260522754116166 */
	{ 26105259424788LL, 1000000000000000LL },	/* 0.026105259424788 */
	{ 261581435585253LL, 10000000000000000LL },	/* 0.0261581435585253 */
	{ 262109284177969LL, 10000000000000000LL },	/* 0.0262109284177969 */
	{ 262636146015774LL, 10000000000000000LL },	/* 0.0262636146015774 */
	{ 263162027029303LL, 10000000000000000LL },	/* 0.0263162027029303 */
	{ 263686933090892LL, 10000000000000000LL },	/* 0.0263686933090892 */
	{ 264210870015373LL, 10000000000000000LL },	/* 0.0264210870015373 */
	{ 264733843560862LL, 10000000000000000LL },	/* 0.0264733843560862 */
	{ 265255859429526LL, 10000000000000000LL },	/* 0.0265255859429526 */
	{ 265776923268339LL, 10000000000000000LL },	/* 0.0265776923268339 */
	{ 266297040669827LL, 10000000000000000LL },	/* 0.0266297040669827 */
	{ 266816217172798LL, 10000000000000000LL },	/* 0.0266816217172798 */
	{ 26733445826306LL, 1000000000000000LL },	/* 0.026733445826306 */
	{ 267851769374128LL, 10000000000000000LL },	/* 0.0267851769374128 */
	{ 268368155887916LL, 10000000000000000LL },	/* 0.0268368155887916 */
	{ 26888362313542LL, 1000000000000000LL },	/* 0.026888362313542 */
	{ 269398176397387LL, 10000000000000000LL },	/* 0.0269398176397387 */
	{ 269911820904977LL, 10000000000000000LL },	/* 0.0269911820904977 */
	{ 270424561840408LL, 10000000000000000LL },	/* 0.0270424561840408 */
	{ 270936404337596LL, 10000000000000000LL },	/* 0.0270936404337596 */
	{ 271447353482779LL, 10000000000000000LL },	/* 0.0271447353482779 */
	{ 271957414315136LL, 10000000000000000LL },	/* 0.0271957414315136 */
	{ 272466591827389LL, 10000000000000000LL },	/* 0.0272466591827389 */
	{ 272974890966405LL, 10000000000000000LL },	/* 0.0272974890966405 */
	{ 273482316633775LL, 10000000000000000LL },	/* 0.0273482316633775 */
	{ 273988873686397LL, 10000000000000000LL },	/* 0.0273988873686397 */
	{ 27449456693704LL, 1000000000000000LL },	/* 0.027449456693704 */
	{ 274999401154902LL, 10000000000000000LL },	/* 0.0274999401154902 */
	{ 27550338106616LL, 1000000000000000LL },	/* 0.027550338106616 */
	{ 276006511354511LL, 10000000000000000LL },	/* 0.0276006511354511 */
	{ 2765087966617LL, 100000000000000LL },	/* 0.02765087966617 */
	{ 277010241588047LL, 10000000000000000LL },	/* 0.0277010241588047 */
	{ 27751085069296LL, 1000000000000000LL },	/* 0.027751085069296 */
	{ 278010628495439LL, 10000000000000000LL },	/* 0.0278010628495439 */
	{ 27850957947458LL, 1000000000000000LL },	/* 0.027850957947458 */
	{ 279007708070058LL, 10000000000000000LL },	/* 0.0279007708070058 */
	{ 279505018682618LL, 10000000000000000LL },	/* 0.0279505018682618 */
	{ 280001515674544LL, 10000000000000000LL },	/* 0.0280001515674544 */
	{ 280497203370128LL, 10000000000000000LL },	/* 0.0280497203370128 */
	{ 280992086056135LL, 10000000000000000LL },	/* 0.0280992086056135 */
	{ 28148616798225LL, 1000000000000000LL },	/* 0.028148616798225 */
	{ 281979453361527LL, 10000000000000000LL },	/* 0.0281979453361527 */
	{ 28247194637083LL, 1000000000000000LL },	/* 0.028247194637083 */
	{ 282963651151265LL, 10000000000000000LL },	/* 0.0282963651151265 */
	{ 283454571808605LL, 10000000000000000LL },	/* 0.0283454571808605 */
	{ 283944712413708LL, 10000000000000000LL },	/* 0.0283944712413708 */
	{ 284434077002936LL, 10000000000000000LL },	/* 0.0284434077002936 */
	{ 284922669578557LL, 10000000000000000LL },	/* 0.0284922669578557 */
	{ 285410494109145LL, 10000000000000000LL },	/* 0.0285410494109145 */
	{ 285897554529981LL, 10000000000000000LL },	/* 0.0285897554529981 */
	{ 286383854743433LL, 10000000000000000LL },	/* 0.0286383854743433 */
	{ 286869398619349LL, 10000000000000000LL },	/* 0.0286869398619349 */
	{ 287354189995426LL, 10000000000000000LL },	/* 0.0287354189995426 */
	{ 287838232677585LL, 10000000000000000LL },	/* 0.0287838232677585 */
	{ 288321530440338LL, 10000000000000000LL },	/* 0.0288321530440338 */
	{ 288804087027148LL, 10000000000000000LL },	/* 0.0288804087027148 */
	{ 289285906150784LL, 10000000000000000LL },	/* 0.0289285906150784 */
	{ 289766991493673LL, 10000000000000000LL },	/* 0.0289766991493673 */
	{ 290247346708242LL, 10000000000000000LL },	/* 0.0290247346708242 */
	{ 290726975417263LL, 10000000000000000LL },	/* 0.0290726975417263 */
	{ 291205881214181LL, 10000000000000000LL },	/* 0.0291205881214181 */
	{ 291684067663454LL, 10000000000000000LL },	/* 0.0291684067663454 */
	{ 292161538300869LL, 10000000000000000LL },	/* 0.0292161538300869 */
	{ 29263829663387LL, 1000000000000000LL },	/* 0.029263829663387 */
	{ 293114346141869LL, 10000000000000000LL },	/* 0.0293114346141869 */
	{ 293589690276564LL, 10000000000000000LL },	/* 0.0293589690276564 */
	{ 29406433246224LL, 1000000000000000LL },	/* 0.029406433246224 */
	{ 294538276096075LL, 10000000000000000LL },	/* 0.0294538276096075 */
	{ 295011524548438LL, 10000000000000000LL },	/* 0.0295011524548438 */
	{ 295484081163186LL, 10000000000000000LL },	/* 0.0295484081163186 */
	{ 29595594925795LL, 1000000000000000LL },	/* 0.029595594925795 */
	{ 296427132124425LL, 10000000000000000LL },	/* 0.0296427132124425 */
	{ 29689763302865LL, 1000000000000000LL },	/* 0.029689763302865 */
	{ 297367455211288LL, 10000000000000000LL },	/* 0.0297367455211288 */
	{ 297836601887898LL, 10000000000000000LL },	/* 0.0297836601887898 */
	{ 298305076249208LL, 10000000000000000LL },	/* 0.0298305076249208 */
	{ 298772881461383LL, 10000000000000000LL },	/* 0.0298772881461383 */
	{ 299240020666283LL, 10000000000000000LL },	/* 0.0299240020666283 */
	{ 299706496981729LL, 10000000000000000LL },	/* 0.0299706496981729 */
	{ 300172313501756LL, 10000000000000000LL },	/* 0.0300172313501756 */
	{ 300637473296863LL, 10000000000000000LL },	/* 0.0300637473296863 */
	{ 301101979414268LL, 10000000000000000LL },	/* 0.0301101979414268 */
	{ 30156583487815LL, 1000000000000000LL },	/* 0.030156583487815 */
	{ 302029042689891LL, 10000000000000000LL },	/* 0.0302029042689891 */
	{ 302491605828317LL, 10000000000000000LL },	/* 0.0302491605828317 */
	{ 302953527249935LL, 10000000000000000LL },	/* 0.0302953527249935 */
	{ 303414809889161LL, 10000000000000000LL },	/* 0.0303414809889161 */
	{ 303875456658556LL, 10000000000000000LL },	/* 0.0303875456658556 */
	{ 304335470449047LL, 10000000000000000LL },	/* 0.0304335470449047 */
	{ 304794854130155LL, 10000000000000000LL },	/* 0.0304794854130155 */
	{ 305253610550213LL, 10000000000000000LL },	/* 0.0305253610550213 */
	{ 305711742536585LL, 10000000000000000LL },	/* 0.0305711742536585 */
	{ 30616925289588LL, 1000000000000000LL },	/* 0.030616925289588 */
	{ 306626144414165LL, 10000000000000000LL },	/* 0.0306626144414165 */
	{ 307082419857174LL, 10000000000000000LL },	/* 0.0307082419857174 */
	{ 307538081970513LL, 10000000000000000LL },	/* 0.0307538081970513 */
	{ 307993133479868LL, 10000000000000000LL },	/* 0.0307993133479868 */
	{ 308447577091201LL, 10000000000000000LL },	/* 0.0308447577091201 */
	{ 308901415490953LL, 10000000000000000LL },	/* 0.0308901415490953 */
	{ 309354651346236LL, 10000000000000000LL },	/* 0.0309354651346236 */
	{ 309807287305032LL, 10000000000000000LL },	/* 0.0309807287305032 */
	{ 310259325996379LL, 10000000000000000LL },	/* 0.0310259325996379 */
	{ 310710770030561LL, 10000000000000000LL },	/* 0.0310710770030561 */
	{ 311161621999296LL, 10000000000000000LL },	/* 0.0311161621999296 */
	{ 311611884475917LL, 10000000000000000LL },	/* 0.0311611884475917 */
	{ 312061560015558LL, 10000000000000000LL },	/* 0.0312061560015558 */
	{ 312510651155326LL, 10000000000000000LL },	/* 0.0312510651155326 */
	{ 312959160414486LL, 10000000000000000LL },	/* 0.0312959160414486 */
	{ 31340709029463LL, 1000000000000000LL },	/* 0.031340709029463 */
	{ 313854443279853LL, 10000000000000000LL },	/* 0.0313854443279853 */
	{ 31430122183692LL, 1000000000000000LL },	/* 0.031430122183692 */
	{ 314747428415438LL, 10000000000000000LL },	/* 0.0314747428415438 */
	{ 315193065448019LL, 10000000000000000LL },	/* 0.0315193065448019 */
	{ 315638135350446LL, 10000000000000000LL },	/* 0.0315638135350446 */
	{ 316082640521835LL, 10000000000000000LL },	/* 0.0316082640521835 */
	{ 316526583344794LL, 10000000000000000LL },	/* 0.0316526583344794 */
	{ 316969966185581LL, 10000000000000000LL },	/* 0.0316969966185581 */
	{ 317412791394264LL, 10000000000000000LL },	/* 0.0317412791394264 */
	{ 317855061304867LL, 10000000000000000LL },	/* 0.0317855061304867 */
	{ 318296778235532LL, 10000000000000000LL },	/* 0.0318296778235532 */
	{ 318737944488663LL, 10000000000000000LL },	/* 0.0318737944488663 */
	{ 319178562351077LL, 10000000000000000LL },	/* 0.0319178562351077 */
	{ 319618634094152LL, 10000000000000000LL },	/* 0.0319618634094152 */
	{ 320058161973967LL, 10000000000000000LL },	/* 0.0320058161973967 */
	{ 320497148231454LL, 10000000000000000LL },	/* 0.0320497148231454 */
	{ 320935595092531LL, 10000000000000000LL },	/* 0.0320935595092531 */
	{ 321373504768247LL, 10000000000000000LL },	/* 0.0321373504768247 */
	{ 32181087945492LL, 1000000000000000LL },	/* 0.032181087945492 */
	{ 32224772133427LL, 1000000000000000LL },	/* 0.032224772133427 */
	{ 32268403257356LL, 1000000000000000LL },	/* 0.032268403257356 */
	{ 323119815325724LL, 10000000000000000LL },	/* 0.0323119815325724 */
	{ 323555071729501LL, 10000000000000000LL },	/* 0.0323555071729501 */
	{ 323989803909566LL, 10000000000000000LL },	/* 0.0323989803909566 */
	{ 324424013976657LL, 10000000000000000LL },	/* 0.0324424013976657 */
	{ 324857704027703LL, 10000000000000000LL },	/* 0.0324857704027703 */
	{ 325290876145952LL, 10000000000000000LL },	/* 0.0325290876145952 */
	{ 32572353240109LL, 1000000000000000LL },	/* 0.032572353240109 */
	{ 32615567484937LL, 1000000000000000LL },	/* 0.032615567484937 */
	{ 326587305533729LL, 10000000000000000LL },	/* 0.0326587305533729 */
	{ 32701842648391LL, 1000000000000000LL },	/* 0.032701842648391 */
	{ 327449039716579LL, 10000000000000000LL },	/* 0.0327449039716579 */
	{ 327879147235444LL, 10000000000000000LL },	/* 0.0327879147235444 */
	{ 328308751031372LL, 10000000000000000LL },	/* 0.0328308751031372 */
	{ 328737853082498LL, 10000000000000000LL },	/* 0.0328737853082498 */
	{ 329166455354347LL, 10000000000000000LL },	/* 0.0329166455354347 */
	{ 329594559799936LL, 10000000000000000LL },	/* 0.0329594559799936 */
	{ 330022168359894LL, 10000000000000000LL },	/* 0.0330022168359894 */
	{ 330449282962565LL, 10000000000000000LL },	/* 0.0330449282962565 */
	{ 330875905524119LL, 10000000000000000LL },	/* 0.0330875905524119 */
	{ 331302037948658LL, 10000000000000000LL },	/* 0.0331302037948658 */
	{ 331727682128323LL, 10000000000000000LL },	/* 0.0331727682128323 */
	{ 332152839943397LL, 10000000000000000LL },	/* 0.0332152839943397 */
	{ 332577513262411LL, 10000000000000000LL },	/* 0.0332577513262411 */
	{ 333001703942243LL, 10000000000000000LL },	/* 0.0333001703942243 */
	{ 333425413828221LL, 10000000000000000LL },	/* 0.0333425413828221 */
	{ 333848644754222LL, 10000000000000000LL },	/* 0.0333848644754222 */
	{ 334271398542773LL, 10000000000000000LL },	/* 0.0334271398542773 */
	{ 334693677005146LL, 10000000000000000LL },	/* 0.0334693677005146 */
	{ 335115481941457LL, 10000000000000000LL },	/* 0.0335115481941457 */
	{ 335536815140761LL, 10000000000000000LL },	/* 0.0335536815140761 */
	{ 335957678381145LL, 10000000000000000LL },	/* 0.0335957678381145 */
	{ 336378073429825LL, 10000000000000000LL },	/* 0.0336378073429825 */
	{ 336798002043235LL, 10000000000000000LL },	/* 0.0336798002043235 */
	{ 337217465967119LL, 10000000000000000LL },	/* 0.0337217465967119 */
	{ 337636466936625LL, 10000000000000000LL },	/* 0.0337636466936625 */
	{ 338055006676391LL, 10000000000000000LL },	/* 0.0338055006676391 */
	{ 338473086900635LL, 10000000000000000LL },	/* 0.0338473086900635 */
	{ 338890709313242LL, 10000000000000000LL },	/* 0.0338890709313242 */
	{ 33930787560785LL, 1000000000000000LL },	/* 0.033930787560785 */
	{ 33972458746794LL, 1000000000000000LL },	/* 0.033972458746794 */
	{ 340140846566914LL, 10000000000000000LL },	/* 0.0340140846566914 */
	{ 340556654568185LL, 10000000000000000LL },	/* 0.0340556654568185 */
	{ 340972013125256LL, 10000000000000000LL },	/* 0.0340972013125256 */
	{ 341386923881805LL, 10000000000000000LL },	/* 0.0341386923881805 */
	{ 341801388471764LL, 10000000000000000LL },	/* 0.0341801388471764 */
	{ 342215408519403LL, 10000000000000000LL },	/* 0.0342215408519403 */
	{ 342628985639403LL, 10000000000000000LL },	/* 0.0342628985639403 */
	{ 343042121436941LL, 10000000000000000LL },	/* 0.0343042121436941 */
	{ 343454817507766LL, 10000000000000000LL },	/* 0.0343454817507766 */
	{ 343867075438276LL, 10000000000000000LL },	/* 0.0343867075438276 */
	{ 344278896805592LL, 10000000000000000LL },	/* 0.0344278896805592 */
	{ 344690283177636LL, 10000000000000000LL },	/* 0.0344690283177636 */
	{ 345101236113208LL, 10000000000000000LL },	/* 0.0345101236113208 */
	{ 345511757162053LL, 10000000000000000LL },	/* 0.0345511757162053 */
	{ 345921847864941LL, 10000000000000000LL },	/* 0.0345921847864941 */
	{ 346331509753735LL, 10000000000000000LL },	/* 0.0346331509753735 */
	{ 346740744351467LL, 10000000000000000LL },	/* 0.0346740744351467 */
	{ 347149553172402LL, 10000000000000000LL },	/* 0.0347149553172402 */
	{ 347557937722115LL, 10000000000000000LL },	/* 0.0347557937722115 */
	{ 347965899497558LL, 10000000000000000LL },	/* 0.0347965899497558 */
	{ 348373439987127LL, 10000000000000000LL },	/* 0.0348373439987127 */
	{ 348780560670734LL, 10000000000000000LL },	/* 0.0348780560670734 */
	{ 349187263019868LL, 10000000000000000LL },	/* 0.0349187263019868 */
	{ 34959354849767LL, 1000000000000000LL },	/* 0.034959354849767 */
	{ 349999418558991LL, 10000000000000000LL },	/* 0.0349999418558991 */
	{ 350404874650462LL, 10000000000000000LL },	/* 0.0350404874650462 */
	{ 35080991821056LL, 1000000000000000LL },	/* 0.035080991821056 */
	{ 351214550669666LL, 10000000000000000LL },	/* 0.0351214550669666 */
	{ 351618773450133LL, 10000000000000000LL },	/* 0.0351618773450133 */
	{ 352022587966348LL, 10000000000000000LL },	/* 0.0352022587966348 */
	{ 352425995624795LL, 10000000000000000LL },	/* 0.0352425995624795 */
	{ 352828997824113LL, 10000000000000000LL },	/* 0.0352828997824113 */
	{ 35323159595516LL, 1000000000000000LL },	/* 0.035323159595516 */
	{ 353633791401072LL, 10000000000000000LL },	/* 0.0353633791401072 */
	{ 354035585537324LL, 10000000000000000LL },	/* 0.0354035585537324 */
	{ 354436979731787LL, 10000000000000000LL },	/* 0.0354436979731787 */
	{ 354837975344788LL, 10000000000000000LL },	/* 0.0354837975344788 */
	{ 355238573729168LL, 10000000000000000LL },	/* 0.0355238573729168 */
	{ 355638776230337LL, 10000000000000000LL },	/* 0.0355638776230337 */
	{ 356038584186336LL, 10000000000000000LL },	/* 0.0356038584186336 */
	{ 356437998927886LL, 10000000000000000LL },	/* 0.0356437998927886 */
	{ 356837021778449LL, 10000000000000000LL },	/* 0.0356837021778449 */
	{ 357235654054283LL, 10000000000000000LL },	/* 0.0357235654054283 */
	{ 357633897064494LL, 10000000000000000LL },	/* 0.0357633897064494 */
	{ 358031752111091LL, 10000000000000000LL },	/* 0.0358031752111091 */
	{ 35842922048904LL, 1000000000000000LL },	/* 0.035842922048904 */
	{ 358826303486317LL, 10000000000000000LL },	/* 0.0358826303486317 */
	{ 359223002383961LL, 10000000000000000LL },	/* 0.0359223002383961 */
	{ 359619318456125LL, 10000000000000000LL },	/* 0.0359619318456125 */
	{ 360015252970127LL, 10000000000000000LL },	/* 0.0360015252970127 */
	{ 360410807186503LL, 10000000000000000LL },	/* 0.0360410807186503 */
	{ 360805982359056LL, 10000000000000000LL },	/* 0.0360805982359056 */
	{ 361200779734907LL, 10000000000000000LL },	/* 0.0361200779734907 */
	{ 361595200554543LL, 10000000000000000LL },	/* 0.0361595200554543 */
	{ 361989246051867LL, 10000000000000000LL },	/* 0.0361989246051867 */
	{ 362382917454249LL, 10000000000000000LL },	/* 0.0362382917454249 */
	{ 362776215982569LL, 10000000000000000LL },	/* 0.0362776215982569 */
	{ 36316914285127LL, 1000000000000000LL },	/* 0.036316914285127 */
	{ 363561699268402LL, 10000000000000000LL },	/* 0.0363561699268402 */
	{ 363953886435669LL, 10000000000000000LL },	/* 0.0363953886435669 */
	{ 364345705548478LL, 10000000000000000LL },	/* 0.0364345705548478 */
	{ 36473715779598LL, 1000000000000000LL },	/* 0.036473715779598 */
	{ 365128244361123LL, 10000000000000000LL },	/* 0.0365128244361123 */
	{ 365518966420688LL, 10000000000000000LL },	/* 0.0365518966420688 */
	{ 365909325145341LL, 10000000000000000LL },	/* 0.0365909325145341 */
	{ 366299321699675LL, 10000000000000000LL },	/* 0.0366299321699675 */
	{ 366688957242252LL, 10000000000000000LL },	/* 0.0366688957242252 */
	{ 367078232925648LL, 10000000000000000LL },	/* 0.0367078232925648 */
	{ 367467149896497LL, 10000000000000000LL },	/* 0.0367467149896497 */
	{ 367855709295533LL, 10000000000000000LL },	/* 0.0367855709295533 */
	{ 368243912257629LL, 10000000000000000LL },	/* 0.0368243912257629 */
	{ 368631759911844LL, 10000000000000000LL },	/* 0.0368631759911844 */
	{ 369019253381463LL, 10000000000000000LL },	/* 0.0369019253381463 */
	{ 369406393784034LL, 10000000000000000LL },	/* 0.0369406393784034 */
	{ 369793182231416LL, 10000000000000000LL },	/* 0.0369793182231416 */
	{ 370179619829813LL, 10000000000000000LL },	/* 0.0370179619829813 */
	{ 370565707679816LL, 10000000000000000LL },	/* 0.0370565707679816 */
	{ 370951446876444LL, 10000000000000000LL },	/* 0.0370951446876444 */
	{ 371336838509182LL, 10000000000000000LL },	/* 0.0371336838509182 */
	{ 371721883662021LL, 10000000000000000LL },	/* 0.0371721883662021 */
	{ 371721883662021LL, 10000000000000000LL }	/* 0.0371721883662021 */
};

const struct fixpoint flarge_table[] = {
	{ 243315981116462LL, 1000000000000LL },	/* 243.315981116462 */
	{ 243315981116462LL, 1000000000000LL },	/* 243.315981116462 */
	{ 239600361713695LL, 10000000000000LL },	/* 23.9600361713695 */
	{ 69139329716018LL, 10000000000000LL },	/* 6.9139329716018 */
	{ 316392425109494LL, 100000000000000LL },	/* 3.16392425109494 */
	{ 186371728900425LL, 100000000000000LL },	/* 1.86371728900425 */
	{ 127777777777778LL, 100000000000000LL },	/* 1.27777777777778 */
	{ 964508403261589LL, 1000000000000000LL },	/* 0.964508403261589 */
	{ 77581442422356LL, 100000000000000LL },	/* 0.77581442422356 */
	{ 651853237448473LL, 1000000000000000LL },	/* 0.651853237448473 */
	{ 564939170766789LL, 1000000000000000LL },	/* 0.564939170766789 */
	{ 50087416614881LL, 100000000000000LL },	/* 0.50087416614881 */
	{ 451762665758072LL, 1000000000000000LL },	/* 0.451762665758072 */
	{ 412917778678493LL, 1000000000000000LL },	/* 0.412917778678493 */
	{ 381404155091771LL, 1000000000000000LL },	/* 0.381404155091771 */
	{ 355299463329141LL, 1000000000000000LL },	/* 0.355299463329141 */
	{ 333296455886513LL, 1000000000000000LL },	/* 0.333296455886513 */
	{ 314477147580053LL, 1000000000000000LL },	/* 0.314477147580053 */
	{ 298178842729622LL, 1000000000000000LL },	/* 0.298178842729622 */
	{ 283911535127666LL, 1000000000000000LL },	/* 0.283911535127666 */
	{ 271305240150892LL, 1000000000000000LL },	/* 0.271305240150892 */
	{ 260075403532531LL, 1000000000000000LL },	/* 0.260075403532531 */
	{ 249999578782356LL, 1000000000000000LL },	/* 0.249999578782356 */
	{ 24090133037795LL, 100000000000000LL },	/* 0.24090133037795 */
	{ 232638888888889LL, 1000000000000000LL },	/* 0.232638888888889 */
	{ 225097003008273LL, 1000000000000000LL },	/* 0.225097003008273 */
	{ 218180986989316LL, 1000000000000000LL },	/* 0.218180986989316 */
	{ 211812304114001LL, 1000000000000000LL },	/* 0.211812304114001 */
	{ 205925243280314LL, 1000000000000000LL },	/* 0.205925243280314 */
	{ 200464385692282LL, 1000000000000000LL },	/* 0.200464385692282 */
	{ 195382650833982LL, 1000000000000000LL },	/* 0.195382650833982 */
	{ 19063977276852LL, 100000000000000LL },	/* 0.19063977276852 */
	{ 186201099999877LL, 1000000000000000LL },	/* 0.186201099999877 */
	{ 182036641362817LL, 1000000000000000LL },	/* 0.182036641362817 */
	{ 178120300939LL, 1000000000000LL },	/* 0.178120300939 */
	{ 174429259613497LL, 1000000000000000LL },	/* 0.174429259613497 */
	{ 170943471418511LL, 1000000000000000LL },	/* 0.170943471418511 */
	{ 16764525048842LL, 100000000000000LL },	/* 0.16764525048842 */
	{ 164518930106658LL, 1000000000000000LL },	/* 0.164518930106658 */
	{ 161550579534251LL, 1000000000000000LL },	/* 0.161550579534251 */
	{ 158727767472067LL, 1000000000000000LL },	/* 0.158727767472067 */
	{ 156039363405452LL, 1000000000000000LL },	/* 0.156039363405452 */
	{ 153475369911586LL, 1000000000000000LL },	/* 0.153475369911586 */
	{ 151026780420806LL, 1000000000000000LL },	/* 0.151026780420806 */
	{ 148685458018048LL, 1000000000000000LL },	/* 0.148685458018048 */
	{ 146444031726265LL, 1000000000000000LL },	/* 0.146444031726265 */
	{ 144295807386892LL, 1000000000000000LL },	/* 0.144295807386892 */
	{ 142234690785429LL, 1000000000000000LL },	/* 0.142234690785429 */
	{ 140255121094728LL, 1000000000000000LL },	/* 0.140255121094728 */
	{ 13835201304867LL, 100000000000000LL },	/* 0.13835201304867 */
	{ 136520706532794LL, 1000000000000000LL },	/* 0.136520706532794 */
	{ 1347569225002LL, 10000000000000LL },	/* 0.1347569225002 */
	{ 133056724301448LL, 1000000000000000LL },	/* 0.133056724301448 */
	{ 131416483664691LL, 1000000000000000LL },	/* 0.131416483664691 */
	{ 129832850683331LL, 1000000000000000LL },	/* 0.129832850683331 */
	{ 128302727268412LL, 1000000000000000LL },	/* 0.128302727268412 */
	{ 12682324360563LL, 100000000000000LL },	/* 0.12682324360563 */
	{ 125391737225632LL, 1000000000000000LL },	/* 0.125391737225632 */
	{ 12400573435363LL, 100000000000000LL },	/* 0.12400573435363 */
	{ 122662933252459LL, 1000000000000000LL },	/* 0.122662933252459 */
	{ 121361189313573LL, 1000000000000000LL },	/* 0.121361189313573 */
	{ 12009850168457LL, 100000000000000LL },	/* 0.12009850168457 */
	{ 118873001250667LL, 1000000000000000LL },	/* 0.118873001250667 */
	{ 117682939811998LL, 1000000000000000LL },	/* 0.117682939811998 */
	{ 116526680319474LL, 1000000000000000LL },	/* 0.116526680319474 */
	{ 115402688049678LL, 1000000000000000LL },	/* 0.115402688049678 */
	{ 114309522614568LL, 1000000000000000LL },	/* 0.114309522614568 */
	{ 113245830714757LL, 1000000000000000LL },	/* 0.113245830714757 */
	{ 11221033955645LL, 100000000000000LL },	/* 0.11221033955645 */
	{ 111201850861809LL, 1000000000000000LL },	/* 0.111201850861809 */
	{ 1102192354109LL, 10000000000000LL },	/* 0.1102192354109 */
	{ 109261428060689LL, 1000000000000000LL },	/* 0.109261428060689 */
	{ 108327423192858LL, 1000000000000000LL },	/* 0.108327423192858 */
	{ 107416270547744LL, 1000000000000000LL },	/* 0.107416270547744 */
	{ 106527071406495LL, 1000000000000000LL },	/* 0.106527071406495 */
	{ 105658975087763LL, 1000000000000000LL },	/* 0.105658975087763 */
	{ 104811175728943LL, 1000000000000000LL },	/* 0.104811175728943 */
	{ 103982909325178LL, 1000000000000000LL },	/* 0.103982909325178 */
	{ 103173451002242LL, 1000000000000000LL },	/* 0.103173451002242 */
	{ 102382112501895LL, 1000000000000000LL },	/* 0.102382112501895 */
	{ 101608239860516LL, 1000000000000000LL },	/* 0.101608239860516 */
	{ 100851211263824LL, 1000000000000000LL },	/* 0.100851211263824 */
	{ 100110435062178LL, 1000000000000000LL },	/* 0.100110435062178 */
	{ 993853479325371LL, 10000000000000000LL },	/* 0.0993853479325371 */
	{ 986754131745014LL, 10000000000000000LL },	/* 0.0986754131745014 */
	{ 97980119129101LL, 1000000000000000LL },	/* 0.097980119129101 */
	{ 972989777100651LL, 10000000000000000LL },	/* 0.0972989777100651 */
	{ 96631523038292LL, 1000000000000000LL },	/* 0.096631523038292 */
	{ 959773101711038LL, 10000000000000000LL },	/* 0.0959773101711038 */
	{ 953359139186481LL, 10000000000000000LL },	/* 0.0953359139186481 */
	{ 947069277405102LL, 10000000000000000LL },	/* 0.0947069277405102 */
	{ 940899627162219LL, 10000000000000000LL },	/* 0.0940899627162219 */
	{ 934846465839213LL, 10000000000000000LL },	/* 0.0934846465839213 */
	{ 928906228419223LL, 10000000000000000LL },	/* 0.0928906228419223 */
	{ 923075499084108LL, 10000000000000000LL },	/* 0.0923075499084108 */
	{ 917351003348998LL, 10000000000000000LL },	/* 0.0917351003348998 */
	{ 911729600694444LL, 10000000000000000LL },	/* 0.0911729600694444 */
	{ 906208277659599LL, 10000000000000000LL },	/* 0.0906208277659599 */
	{ 900784141362873LL, 10000000000000000LL },	/* 0.0900784141362873 */
	{ 895454413419325LL, 10000000000000000LL },	/* 0.0895454413419325 */
	{ 890216424226529LL, 10000000000000000LL },	/* 0.0890216424226529 */
	{ 885067607592958LL, 10000000000000000LL },	/* 0.0885067607592958 */
	{ 88000549568501LL, 1000000000000000LL },	/* 0.088000549568501 */
	{ 875027714270677LL, 10000000000000000LL },	/* 0.0875027714270677 */
	{ 870131978239609LL, 10000000000000000LL },	/* 0.0870131978239609 */
	{ 865316087380871LL, 10000000000000000LL },	/* 0.0865316087380871 */
	{ 860577922401151LL, 10000000000000000LL },	/* 0.0860577922401151 */
	{ 855915441167475LL, 10000000000000000LL },	/* 0.0855915441167475 */
	{ 851326675159692LL, 10000000000000000LL },	/* 0.0851326675159692 */
	{ 846809726119106LL, 10000000000000000LL },	/* 0.0846809726119106 */
	{ 842362762880613LL, 10000000000000000LL },	/* 0.0842362762880613 */
	{ 837984018376643LL, 10000000000000000LL },	/* 0.0837984018376643 */
	{ 833671786802068LL, 10000000000000000LL },	/* 0.0833671786802068 */
	{ 829424420929991LL, 10000000000000000LL },	/* 0.0829424420929991 */
	{ 825240329569059LL, 10000000000000000LL },	/* 0.0825240329569059 */
	{ 821117975153618LL, 10000000000000000LL },	/* 0.0821117975153618 */
	{ 817055871458615LL, 10000000000000000LL },	/* 0.0817055871458615 */
	{ 813052581431724LL, 10000000000000000LL },	/* 0.0813052581431724 */
	{ 809106715135683LL, 10000000000000000LL },	/* 0.0809106715135683 */
	{ 805216927794322LL, 10000000000000000LL },	/* 0.0805216927794322 */
	{ 801381917936175LL, 10000000000000000LL },	/* 0.0801381917936175 */
	{ 797600425630009LL, 10000000000000000LL },	/* 0.0797600425630009 */
	{ 793871230806953LL, 10000000000000000LL },	/* 0.0793871230806953 */
	{ 790193151664281LL, 10000000000000000LL },	/* 0.0790193151664281 */
	{ 786565043146194LL, 10000000000000000LL },	/* 0.0786565043146194 */
	{ 782985795497303LL, 10000000000000000LL },	/* 0.0782985795497303 */
	{ 779454332884719LL, 10000000000000000LL },	/* 0.0779454332884719 */
	{ 775969612084976LL, 10000000000000000LL },	/* 0.0775969612084976 */
	{ 77253062123222LL, 1000000000000000LL },	/* 0.077253062123222 */
	{ 769136378624335LL, 10000000000000000LL },	/* 0.0769136378624335 */
	{ 765785931583867LL, 10000000000000000LL },	/* 0.0765785931583867 */
	{ 762478355370815LL, 10000000000000000LL },	/* 0.0762478355370815 */
	{ 759212752144541LL, 10000000000000000LL },	/* 0.0759212752144541 */
	{ 755988249972193LL, 10000000000000000LL },	/* 0.0755988249972193 */
	{ 752804001881223LL, 10000000000000000LL },	/* 0.0752804001881223 */
	{ 749659184953696LL, 10000000000000000LL },	/* 0.0749659184953696 */
	{ 746552999460257LL, 10000000000000000LL },	/* 0.0746552999460257 */
	{ 743484668031706LL, 10000000000000000LL },	/* 0.0743484668031706 */
	{ 740453434866294LL, 10000000000000000LL },	/* 0.0740453434866294 */
	{ 737458564970926LL, 10000000000000000LL },	/* 0.0737458564970926 */
	{ 734499343434585LL, 10000000000000000LL },	/* 0.0734499343434585 */
	{ 731575074732384LL, 10000000000000000LL },	/* 0.0731575074732384 */
	{ 728685082058719LL, 10000000000000000LL },	/* 0.0728685082058719 */
	{ 725828706688121LL, 10000000000000000LL },	/* 0.0725828706688121 */
	{ 723005307362458LL, 10000000000000000LL },	/* 0.0723005307362458 */
	{ 720214259703205LL, 10000000000000000LL },	/* 0.0720214259703205 */
	{ 717454955647604LL, 10000000000000000LL },	/* 0.0717454955647604 */
	{ 714726802907563LL, 10000000000000000LL },	/* 0.0714726802907563 */
	{ 712029224450229LL, 10000000000000000LL },	/* 0.0712029224450229 */
	{ 70936165799922LL, 1000000000000000LL },	/* 0.070936165799922 */
	{ 706723555555556LL, 10000000000000000LL },	/* 0.0706723555555556 */
	{ 704114382937376LL, 10000000000000000LL },	/* 0.0704114382937376 */
	{ 701533619337587LL, 10000000000000000LL },	/* 0.0701533619337587 */
	{ 698980756898617LL, 10000000000000000LL },	/* 0.0698980756898617 */
	{ 696455300303507LL, 10000000000000000LL },	/* 0.0696455300303507 */
	{ 693956766382614LL, 10000000000000000LL },	/* 0.0693956766382614 */
	{ 691484683735212LL, 10000000000000000LL },	/* 0.0691484683735212 */
	{ 689038592365337LL, 10000000000000000LL },	/* 0.0689038592365337 */
	{ 686618043331262LL, 10000000000000000LL },	/* 0.0686618043331262 */
	{ 684222598407987LL, 10000000000000000LL },	/* 0.0684222598407987 */
	{ 681851829762186LL, 10000000000000000LL },	/* 0.0681851829762186 */
	{ 679505319639075LL, 10000000000000000LL },	/* 0.0679505319639075 */
	{ 677182660060694LL, 10000000000000000LL },	/* 0.0677182660060694 */
	{ 674883452535098LL, 10000000000000000LL },	/* 0.0674883452535098 */
	{ 672607307776018LL, 10000000000000000LL },	/* 0.0672607307776018 */
	{ 670353845432538LL, 10000000000000000LL },	/* 0.0670353845432538 */
	{ 668122693828371LL, 10000000000000000LL },	/* 0.0668122693828371 */
	{ 665913489710335LL, 10000000000000000LL },	/* 0.0665913489710335 */
	{ 663725878005655LL, 10000000000000000LL },	/* 0.0663725878005655 */
	{ 66155951158772LL, 1000000000000000LL },	/* 0.066155951158772 */
	{ 659414051049953LL, 10000000000000000LL },	/* 0.0659414051049953 */
	{ 657289164487471LL, 10000000000000000LL },	/* 0.0657289164487471 */
	{ 655184527286211LL, 10000000000000000LL },	/* 0.0655184527286211 */
	{ 653099821919232LL, 10000000000000000LL },	/* 0.0653099821919232 */
	{ 651034737749902LL, 10000000000000000LL },	/* 0.0651034737749902 */
	{ 648988970841695LL, 10000000000000000LL },	/* 0.0648988970841695 */
	{ 646962223774351LL, 10000000000000000LL },	/* 0.0646962223774351 */
	{ 644954205466131LL, 10000000000000000LL },	/* 0.0644954205466131 */
	{ 642964631001948LL, 10000000000000000LL },	/* 0.0642964631001948 */
	{ 64099322146713LL, 1000000000000000LL },	/* 0.064099322146713 */
	{ 639039703786617LL, 10000000000000000LL },	/* 0.0639039703786617 */
	{ 63710381056937LL, 1000000000000000LL },	/* 0.063710381056937 */
	{ 635185279957794LL, 10000000000000000LL },	/* 0.0635185279957794 */
	{ 633283855482LL, 10000000000000LL },	/* 0.0633283855482 */
	{ 631399285918708LL, 10000000000000000LL },	/* 0.0631399285918708 */
	{ 629531325154621LL, 10000000000000000LL },	/* 0.0629531325154621 */
	{ 62767973205412LL, 1000000000000000LL },	/* 0.062767973205412 */
	{ 625844270331088LL, 10000000000000000LL },	/* 0.0625844270331088 */
	{ 624024708424753LL, 10000000000000000LL },	/* 0.0624024708424753 */
	{ 622220819379358LL, 10000000000000000LL },	/* 0.0622220819379358 */
	{ 620432380727561LL, 10000000000000000LL },	/* 0.0620432380727561 */
	{ 618659174377399LL, 10000000000000000LL },	/* 0.0618659174377399 */
	{ 616900986502709LL, 10000000000000000LL },	/* 0.0616900986502709 */
	{ 61515760743686LL, 1000000000000000LL },	/* 0.061515760743686 */
	{ 61342883156971LL, 1000000000000000LL },	/* 0.061342883156971 */
	{ 611714457247638LL, 10000000000000000LL },	/* 0.0611714457247638 */
	{ 610014286676573LL, 10000000000000000LL },	/* 0.0610014286676573 */
	{ 608328125827897LL, 10000000000000000LL },	/* 0.0608328125827897 */
	{ 606655784347128LL, 10000000000000000LL },	/* 0.0606655784347128 */
	{ 604997075465285LL, 10000000000000000LL },	/* 0.0604997075465285 */
	{ 60335181591285LL, 1000000000000000LL },	/* 0.060335181591285 */
	{ 601719825836224LL, 10000000000000000LL },	/* 0.0601719825836224 */
	{ 600100928716606LL, 10000000000000000LL },	/* 0.0600100928716606 */
	{ 598494951291204LL, 10000000000000000LL },	/* 0.0598494951291204 */
	{ 5969017234767LL, 100000000000000LL },	/* 0.05969017234767 */
	{ 595321078294903LL, 10000000000000000LL },	/* 0.0595321078294903 */
	{ 593752851800498LL, 10000000000000000LL },	/* 0.0593752851800498 */
	{ 592196883010845LL, 10000000000000000LL },	/* 0.0592196883010845 */
	{ 590653013837736LL, 10000000000000000LL },	/* 0.0590653013837736 */
	{ 589121089021067LL, 10000000000000000LL },	/* 0.0589121089021067 */
	{ 587600956064349LL, 10000000000000000LL },	/* 0.0587600956064349 */
	{ 586092465171998LL, 10000000000000000LL },	/* 0.0586092465171998 */
	{ 584595469188356LL, 10000000000000000LL },	/* 0.0584595469188356 */
	{ 583109823538382LL, 10000000000000000LL },	/* 0.0583109823538382 */
	{ 58163538616995LL, 1000000000000000LL },	/* 0.058163538616995 */
	{ 580172017497721LL, 10000000000000000LL },	/* 0.0580172017497721 */
	{ 578719580348524LL, 10000000000000000LL },	/* 0.0578719580348524 */
	{ 577277939908204LL, 10000000000000000LL },	/* 0.0577277939908204 */
	{ 575846963669894LL, 10000000000000000LL },	/* 0.0575846963669894 */
	{ 574426521383656LL, 10000000000000000LL },	/* 0.0574426521383656 */
	{ 573016485007461LL, 10000000000000000LL },	/* 0.0573016485007461 */
	{ 571616728659458LL, 10000000000000000LL },	/* 0.0571616728659458 */
	{ 570227128571493LL, 10000000000000000LL },	/* 0.0570227128571493 */
	{ 568847563043846LL, 10000000000000000LL },	/* 0.0568847563043846 */
	{ 567477912401137LL, 10000000000000000LL },	/* 0.0567477912401137 */
	{ 566118058949378LL, 10000000000000000LL },	/* 0.0566118058949378 */
	{ 564767886934124LL, 10000000000000000LL },	/* 0.0564767886934124 */
	{ 563427282499708LL, 10000000000000000LL },	/* 0.0563427282499708 */
	{ 5620961336495LL, 100000000000000LL },	/* 0.05620961336495 */
	{ 560774330207186LL, 10000000000000000LL },	/* 0.0560774330207186 */
	{ 559461763779024LL, 10000000000000000LL },	/* 0.0559461763779024 */
	{ 558158327717044LL, 10000000000000000LL },	/* 0.0558158327717044 */
	{ 556863917083178LL, 10000000000000000LL },	/* 0.0556863917083178 */
	{ 555578428614275LL, 10000000000000000LL },	/* 0.0555578428614275 */
	{ 554301760687995LL, 10000000000000000LL },	/* 0.0554301760687995 */
	{ 553033813289536LL, 10000000000000000LL },	/* 0.0553033813289536 */
	{ 551774487979186LL, 10000000000000000LL },	/* 0.0551774487979186 */
	{ 550523687860669LL, 10000000000000000LL },	/* 0.0550523687860669 */
	{ 549281317550259LL, 10000000000000000LL },	/* 0.0549281317550259 */
	{ 548047283146649LL, 10000000000000000LL },	/* 0.0548047283146649 */
	{ 546821492201547LL, 10000000000000000LL },	/* 0.0546821492201547 */
	{ 545603853690978LL, 10000000000000000LL },	/* 0.0545603853690978 */
	{ 544394277987275LL, 10000000000000000LL },	/* 0.0544394277987275 */
	{ 543192676831744LL, 10000000000000000LL },	/* 0.0543192676831744 */
	{ 541998963307965LL, 10000000000000000LL },	/* 0.0541998963307965 */
	{ 540813051815741LL, 10000000000000000LL },	/* 0.0540813051815741 */
	{ 539634858045649LL, 10000000000000000LL },	/* 0.0539634858045649 */
	{ 538464298954196LL, 10000000000000000LL },	/* 0.0538464298954196 */
	{ 537301292739549LL, 10000000000000000LL },	/* 0.0537301292739549 */
	{ 536145758817836LL, 10000000000000000LL },	/* 0.0536145758817836 */
	{ 534997617799989LL, 10000000000000000LL },	/* 0.0534997617799989 */
	{ 533856791469134LL, 10000000000000000LL },	/* 0.0533856791469134 */
	{ 532723202758481LL, 10000000000000000LL },	/* 0.0532723202758481 */
	{ 531596775729743LL, 10000000000000000LL },	/* 0.0531596775729743 */
	{ 530477435552026LL, 10000000000000000LL },	/* 0.0530477435552026 */
	{ 529365108481215LL, 10000000000000000LL },	/* 0.0529365108481215 */
	{ 528259721839814LL, 10000000000000000LL },	/* 0.0528259721839814 */
	{ 527161203997248LL, 10000000000000000LL },	/* 0.0527161203997248 */
	{ 526069484350602LL, 10000000000000000LL },	/* 0.0526069484350602 */
	{ 524984493305793LL, 10000000000000000LL },	/* 0.0524984493305793 */
	{ 523906162259159LL, 10000000000000000LL },	/* 0.0523906162259159 */
	{ 522834423579459LL, 10000000000000000LL },	/* 0.0522834423579459 */
	{ 521769210590265LL, 10000000000000000LL },	/* 0.0521769210590265 */
	{ 52071045755275LL, 1000000000000000LL },	/* 0.052071045755275 */
	{ 519658099648841LL, 10000000000000000LL },	/* 0.0519658099648841 */
	{ 518612072964751LL, 10000000000000000LL },	/* 0.0518612072964751 */
	{ 517572314474861LL, 10000000000000000LL },	/* 0.0517572314474861 */
	{ 516538762025956LL, 10000000000000000LL },	/* 0.0516538762025956 */
	{ 515511354321798LL, 10000000000000000LL },	/* 0.0515511354321798 */
	{ 514490030908028LL, 10000000000000000LL },	/* 0.0514490030908028 */
	{ 5134747321574LL, 100000000000000LL },	/* 0.05134747321574 */
	{ 512465399255321LL, 10000000000000000LL },	/* 0.0512465399255321 */
	{ 511461974185697LL, 10000000000000000LL },	/* 0.0511461974185697 */
	{ 510464399717091LL, 10000000000000000LL },	/* 0.0510464399717091 */
	{ 509472619389156LL, 10000000000000000LL },	/* 0.0509472619389156 */
	{ 508486577499364LL, 10000000000000000LL },	/* 0.0508486577499364 */
	{ 507506219090011LL, 10000000000000000LL },	/* 0.0507506219090011 */
	{ 506531489935488LL, 10000000000000000LL },	/* 0.0506531489935488 */
	{ 505562336529823LL, 10000000000000000LL },	/* 0.0505562336529823 */
	{ 504598706074472LL, 10000000000000000LL },	/* 0.0504598706074472 */
	{ 503640546466374LL, 10000000000000000LL },	/* 0.0503640546466374 */
	{ 502687806286237LL, 10000000000000000LL },	/* 0.0502687806286237 */
	{ 501740434787074LL, 10000000000000000LL },	/* 0.0501740434787074 */
	{ 500798381882968LL, 10000000000000000LL },	/* 0.0500798381882968 */
	{ 499861598138068LL, 10000000000000000LL },	/* 0.0499861598138068 */
	{ 498930034755803LL, 10000000000000000LL },	/* 0.0498930034755803 */
	{ 498003643568319LL, 10000000000000000LL },	/* 0.0498003643568319 */
	{ 497082377026125LL, 10000000000000000LL },	/* 0.0497082377026125 */
	{ 496166188187944LL, 10000000000000000LL },	/* 0.0496166188187944 */
	{ 495255030710775LL, 10000000000000000LL },	/* 0.0495255030710775 */
	{ 494348858840139LL, 10000000000000000LL },	/* 0.0494348858840139 */
	{ 493447627400532LL, 10000000000000000LL },	/* 0.0493447627400532 */
	{ 492551291786056LL, 10000000000000000LL },	/* 0.0492551291786056 */
	{ 491659807951242LL, 10000000000000000LL },	/* 0.0491659807951242 */
	{ 490773132402045LL, 10000000000000000LL },	/* 0.0490773132402045 */
	{ 489891222187022LL, 10000000000000000LL },	/* 0.0489891222187022 */
	{ 489014034888677LL, 10000000000000000LL },	/* 0.0489014034888677 */
	{ 488141528614973LL, 10000000000000000LL },	/* 0.0488141528614973 */
	{ 487273661991017LL, 10000000000000000LL },	/* 0.0487273661991017 */
	{ 486410394150891LL, 10000000000000000LL },	/* 0.0486410394150891 */
	{ 485551684729651LL, 10000000000000000LL },	/* 0.0485551684729651 */
	{ 484697493855474LL, 10000000000000000LL },	/* 0.0484697493855474 */
	{ 483847782141954LL, 10000000000000000LL },	/* 0.0483847782141954 */
	{ 48300251068055LL, 1000000000000000LL },	/* 0.048300251068055 */
	{ 48216164103317LL, 1000000000000000LL },	/* 0.048216164103317 */
	{ 481325135224896LL, 10000000000000000LL },	/* 0.0481325135224896 */
	{ 48049295573685LL, 1000000000000000LL },	/* 0.048049295573685 */
	{ 479665065499194LL, 10000000000000000LL },	/* 0.0479665065499194 */
	{ 478841427884249LL, 10000000000000000LL },	/* 0.0478841427884249 */
	{ 478022006699761LL, 10000000000000000LL },	/* 0.0478022006699761 */
	{ 477206766182274LL, 10000000000000000LL },	/* 0.0477206766182274 */
	{ 476395670990636LL, 10000000000000000LL },	/* 0.0476395670990636 */
	{ 475588686199625LL, 10000000000000000LL },	/* 0.0475588686199625 */
	{ 474785777293681LL, 10000000000000000LL },	/* 0.0474785777293681 */
	{ 47398691016077LL, 1000000000000000LL },	/* 0.047398691016077 */
	{ 473192051086343LL, 10000000000000000LL },	/* 0.0473192051086343 */
	{ 472401166747416LL, 10000000000000000LL },	/* 0.0472401166747416 */
	{ 471614224206753LL, 10000000000000000LL },	/* 0.0471614224206753 */
	{ 470831190907155LL, 10000000000000000LL },	/* 0.0470831190907155 */
	{ 470052034665852LL, 10000000000000000LL },	/* 0.0470052034665852 */
	{ 469276723668991LL, 10000000000000000LL },	/* 0.0469276723668991 */
	{ 468505226466234LL, 10000000000000000LL },	/* 0.0468505226466234 */
	{ 467737511965439LL, 10000000000000000LL },	/* 0.0467737511965439 */
	{ 466973549427445LL, 10000000000000000LL },	/* 0.0466973549427445 */
	{ 466213308460944LL, 10000000000000000LL },	/* 0.0466213308460944 */
	{ 465456759017447LL, 10000000000000000LL },	/* 0.0465456759017447 */
	{ 464703871386338LL, 10000000000000000LL },	/* 0.0464703871386338 */
	{ 463954616190012LL, 10000000000000000LL },	/* 0.0463954616190012 */
	{ 463208964379101LL, 10000000000000000LL },	/* 0.0463208964379101 */
	{ 462466887227783LL, 10000000000000000LL },	/* 0.0462466887227783 */
	{ 461728356329171LL, 10000000000000000LL },	/* 0.0461728356329171 */
	{ 460993343590784LL, 10000000000000000LL },	/* 0.0460993343590784 */
	{ 460261821230094LL, 10000000000000000LL },	/* 0.0460261821230094 */
	{ 459533761770151LL, 10000000000000000LL },	/* 0.0459533761770151 */
	{ 458809138035283LL, 10000000000000000LL },	/* 0.0458809138035283 */
	{ 45808792314687LL, 1000000000000000LL },	/* 0.045808792314687 */
	{ 457370090519191LL, 10000000000000000LL },	/* 0.0457370090519191 */
	{ 456655613855335LL, 10000000000000000LL },	/* 0.0456655613855335 */
	{ 455944467143193LL, 10000000000000000LL },	/* 0.0455944467143193 */
	{ 455236624651509LL, 10000000000000000LL },	/* 0.0455236624651509 */
	{ 454532060925998LL, 10000000000000000LL },	/* 0.0454532060925998 */
	{ 453830750785534LL, 10000000000000000LL },	/* 0.0453830750785534 */
	{ 453132669318397LL, 10000000000000000LL },	/* 0.0453132669318397 */
	{ 452437791878588LL, 10000000000000000LL },	/* 0.0452437791878588 */
	{ 451746094082199LL, 10000000000000000LL },	/* 0.0451746094082199 */
	{ 451057551803846LL, 10000000000000000LL },	/* 0.0451057551803846 */
	{ 450372141173166LL, 10000000000000000LL },	/* 0.0450372141173166 */
	{ 449689838571361LL, 10000000000000000LL },	/* 0.0449689838571361 */
	{ 449010620627813LL, 10000000000000000LL },	/* 0.0449010620627813 */
	{ 448334464216739LL, 10000000000000000LL },	/* 0.0448334464216739 */
	{ 447661346453912LL, 10000000000000000LL },	/* 0.0447661346453912 */
	{ 446991244693435LL, 10000000000000000LL },	/* 0.0446991244693435 */
	{ 446324136524557LL, 10000000000000000LL },	/* 0.0446324136524557 */
	{ 445659999768557LL, 10000000000000000LL },	/* 0.0445659999768557 */
	{ 444998812475661LL, 10000000000000000LL },	/* 0.0444998812475661 */
	{ 444340552922024LL, 10000000000000000LL },	/* 0.0444340552922024 */
	{ 44368519960675LL, 1000000000000000LL },	/* 0.044368519960675 */
	{ 443032731248964LL, 10000000000000000LL },	/* 0.0443032731248964 */
	{ 442383126784931LL, 10000000000000000LL },	/* 0.0442383126784931 */
	{ 44173636536522LL, 1000000000000000LL },	/* 0.044173636536522 */
	{ 441092426351912LL, 10000000000000000LL },	/* 0.0441092426351912 */
	{ 440451289315857LL, 10000000000000000LL },	/* 0.0440451289315857 */
	{ 439812934033966LL, 10000000000000000LL },	/* 0.0439812934033966 */
	{ 439177340486556LL, 10000000000000000LL },	/* 0.0439177340486556 */
	{ 438544488854725LL, 10000000000000000LL },	/* 0.0438544488854725 */
	{ 43791435951778LL, 1000000000000000LL },	/* 0.043791435951778 */
	{ 437286933050696LL, 10000000000000000LL },	/* 0.0437286933050696 */
	{ 436662190221621LL, 10000000000000000LL },	/* 0.0436662190221621 */
	{ 436040111989415LL, 10000000000000000LL },	/* 0.0436040111989415 */
	{ 435420679501227LL, 10000000000000000LL },	/* 0.0435420679501227 */
	{ 434803874090116LL, 10000000000000000LL },	/* 0.0434803874090116 */
	{ 434189677272704LL, 10000000000000000LL },	/* 0.0434189677272704 */
	{ 433578070746858LL, 10000000000000000LL },	/* 0.0433578070746858 */
	{ 432969036389425LL, 10000000000000000LL },	/* 0.0432969036389425 */
	{ 432362556253984LL, 10000000000000000LL },	/* 0.0432362556253984 */
	{ 431758612568642LL, 10000000000000000LL },	/* 0.0431758612568642 */
	{ 431157187733861LL, 10000000000000000LL },	/* 0.0431157187733861 */
	{ 430558264320317LL, 10000000000000000LL },	/* 0.0430558264320317 */
	{ 429961825066796LL, 10000000000000000LL },	/* 0.0429961825066796 */
	{ 429367852878112LL, 10000000000000000LL },	/* 0.0429367852878112 */
	{ 428776330823068LL, 10000000000000000LL },	/* 0.0428776330823068 */
	{ 428187242132439LL, 10000000000000000LL },	/* 0.0428187242132439 */
	{ 427600570196989LL, 10000000000000000LL },	/* 0.0427600570196989 */
	{ 427016298565515LL, 10000000000000000LL },	/* 0.0427016298565515 */
	{ 426434410942925LL, 10000000000000000LL },	/* 0.0426434410942925 */
	{ 425854891188339LL, 10000000000000000LL },	/* 0.0425854891188339 */
	{ 425277723313219LL, 10000000000000000LL },	/* 0.0425277723313219 */
	{ 424702891479532LL, 10000000000000000LL },	/* 0.0424702891479532 */
	{ 424130379997931LL, 10000000000000000LL },	/* 0.0424130379997931 */
	{ 423560173325973LL, 10000000000000000LL },	/* 0.0423560173325973 */
	{ 422992256066352LL, 10000000000000000LL },	/* 0.0422992256066352 */
	{ 422426612965169LL, 10000000000000000LL },	/* 0.0422426612965169 */
	{ 421863228910218LL, 10000000000000000LL },	/* 0.0421863228910218 */
	{ 421302088929301LL, 10000000000000000LL },	/* 0.0421302088929301 */
	{ 420743178188567LL, 10000000000000000LL },	/* 0.0420743178188567 */
	{ 420186481990879LL, 10000000000000000LL },	/* 0.0420186481990879 */
	{ 419631985774193LL, 10000000000000000LL },	/* 0.0419631985774193 */
	{ 419079675109974LL, 10000000000000000LL },	/* 0.0419079675109974 */
	{ 418529535701626LL, 10000000000000000LL },	/* 0.0418529535701626 */
	{ 417981553382947LL, 10000000000000000LL },	/* 0.0417981553382947 */
	{ 417435714116607LL, 10000000000000000LL },	/* 0.0417435714116607 */
	{ 416892003992645LL, 10000000000000000LL },	/* 0.0416892003992645 */
	{ 416350409226989LL, 10000000000000000LL },	/* 0.0416350409226989 */
	{ 41581091616LL, 1000000000000LL },	/* 0.041581091616 */
	{ 415273511255028LL, 10000000000000000LL },	/* 0.0415273511255028 */
	{ 414738181096999LL, 10000000000000000LL },	/* 0.0414738181096999 */
	{ 414204912391014LL, 10000000000000000LL },	/* 0.0414204912391014 */
	{ 413673691960969LL, 10000000000000000LL },	/* 0.0413673691960969 */
	{ 413144506748198LL, 10000000000000000LL },	/* 0.0413144506748198 */
	{ 412617343810132LL, 10000000000000000LL },	/* 0.0412617343810132 */
	{ 412092190318976LL, 10000000000000000LL },	/* 0.0412092190318976 */
	{ 411569033560404LL, 10000000000000000LL },	/* 0.0411569033560404 */
	{ 411047860932278LL, 10000000000000000LL },	/* 0.0411047860932278 */
	{ 410528659943376LL, 10000000000000000LL },	/* 0.0410528659943376 */
	{ 410011418212142LL, 10000000000000000LL },	/* 0.0410011418212142 */
	{ 409496123465455LL, 10000000000000000LL },	/* 0.0409496123465455 */
	{ 40898276353741LL, 1000000000000000LL },	/* 0.040898276353741 */
	{ 408471326368122LL, 10000000000000000LL },	/* 0.0408471326368122 */
	{ 407961800002536LL, 10000000000000000LL },	/* 0.0407961800002536 */
	{ 407454172589268LL, 10000000000000000LL },	/* 0.0407454172589268 */
	{ 406948432379447LL, 10000000000000000LL },	/* 0.0406948432379447 */
	{ 406444567725581LL, 10000000000000000LL },	/* 0.0406444567725581 */
	{ 405942567080438LL, 10000000000000000LL },	/* 0.0405942567080438 */
	{ 40544241899594LL, 1000000000000000LL },	/* 0.040544241899594 */
	{ 404944112122069LL, 10000000000000000LL },	/* 0.0404944112122069 */
	{ 404447635205797LL, 10000000000000000LL },	/* 0.0404447635205797 */
	{ 403952977090019LL, 10000000000000000LL },	/* 0.0403952977090019 */
	{ 403460126712507LL, 10000000000000000LL },	/* 0.0403460126712507 */
	{ 402969073104878LL, 10000000000000000LL },	/* 0.0402969073104878 */
	{ 402479805391573LL, 10000000000000000LL },	/* 0.0402479805391573 */
	{ 40199231278885LL, 1000000000000000LL },	/* 0.040199231278885 */
	{ 401506584603793LL, 10000000000000000LL },	/* 0.0401506584603793 */
	{ 401022610233328LL, 10000000000000000LL },	/* 0.0401022610233328 */
	{ 400540379163262LL, 10000000000000000LL },	/* 0.0400540379163262 */
	{ 400059880967321LL, 10000000000000000LL },	/* 0.0400059880967321 */
	{ 399581105306216LL, 10000000000000000LL },	/* 0.0399581105306216 */
	{ 399104041926707LL, 10000000000000000LL },	/* 0.0399104041926707 */
	{ 398628680660689LL, 10000000000000000LL },	/* 0.0398628680660689 */
	{ 398155011424285LL, 10000000000000000LL },	/* 0.0398155011424285 */
	{ 397683024216952LL, 10000000000000000LL },	/* 0.0397683024216952 */
	{ 397212709120599LL, 10000000000000000LL },	/* 0.0397212709120599 */
	{ 396744056298716LL, 10000000000000000LL },	/* 0.0396744056298716 */
	{ 396277055995515LL, 10000000000000000LL },	/* 0.0396277055995515 */
	{ 39581169853508LL, 1000000000000000LL },	/* 0.039581169853508 */
	{ 395347974320531LL, 10000000000000000LL },	/* 0.0395347974320531 */
	{ 394885873833192LL, 10000000000000000LL },	/* 0.0394885873833192 */
	{ 394425387631782LL, 10000000000000000LL },	/* 0.0394425387631782 */
	{ 393966506351601LL, 10000000000000000LL },	/* 0.0393966506351601 */
	{ 393509220703742LL, 10000000000000000LL },	/* 0.0393509220703742 */
	{ 393053521474297LL, 10000000000000000LL },	/* 0.0393053521474297 */
	{ 392599399523587LL, 10000000000000000LL },	/* 0.0392599399523587 */
	{ 392146845785392LL, 10000000000000000LL },	/* 0.0392146845785392 */
	{ 391695851266197LL, 10000000000000000LL },	/* 0.0391695851266197 */
	{ 391246407044446LL, 10000000000000000LL },	/* 0.0391246407044446 */
	{ 390798504269797LL, 10000000000000000LL },	/* 0.0390798504269797 */
	{ 390352134162404LL, 10000000000000000LL },	/* 0.0390352134162404 */
	{ 38990728801219LL, 1000000000000000LL },	/* 0.038990728801219 */
	{ 389463957178138LL, 10000000000000000LL },	/* 0.0389463957178138 */
	{ 389022133087593LL, 10000000000000000LL },	/* 0.0389022133087593 */
	{ 388581807235562LL, 10000000000000000LL },	/* 0.0388581807235562 */
	{ 388142971184039LL, 10000000000000000LL },	/* 0.0388142971184039 */
	{ 387705616561318LL, 10000000000000000LL },	/* 0.0387705616561318 */
	{ 387269735061335LL, 10000000000000000LL },	/* 0.0387269735061335 */
	{ 386835318443004LL, 10000000000000000LL },	/* 0.0386835318443004 */
	{ 386402358529565LL, 10000000000000000LL },	/* 0.0386402358529565 */
	{ 385970847207942LL, 10000000000000000LL },	/* 0.0385970847207942 */
	{ 385540776428107LL, 10000000000000000LL },	/* 0.0385540776428107 */
	{ 385112138202453LL, 10000000000000000LL },	/* 0.0385112138202453 */
	{ 384684924605173LL, 10000000000000000LL },	/* 0.0384684924605173 */
	{ 384259127771645LL, 10000000000000000LL },	/* 0.0384259127771645 */
	{ 38383473989783LL, 1000000000000000LL },	/* 0.038383473989783 */
	{ 383411753239674LL, 10000000000000000LL },	/* 0.0383411753239674 */
	{ 382990160112515LL, 10000000000000000LL },	/* 0.0382990160112515 */
	{ 382569952890498LL, 10000000000000000LL },	/* 0.0382569952890498 */
	{ 382151124006002LL, 10000000000000000LL },	/* 0.0382151124006002 */
	{ 38173366594907LL, 1000000000000000LL },	/* 0.038173366594907 */
	{ 381317571266841LL, 10000000000000000LL },	/* 0.0381317571266841 */
	{ 380902832562998LL, 10000000000000000LL },	/* 0.0380902832562998 */
	{ 380489442497219LL, 10000000000000000LL },	/* 0.0380489442497219 */
	{ 380077393784629LL, 10000000000000000LL },	/* 0.0380077393784629 */
	{ 379666679195267LL, 10000000000000000LL },	/* 0.0379666679195267 */
	{ 379257291553555LL, 10000000000000000LL },	/* 0.0379257291553555 */
	{ 378849223737772LL, 10000000000000000LL },	/* 0.0378849223737772 */
	{ 378442468679537LL, 10000000000000000LL },	/* 0.0378442468679537 */
	{ 378037019363299LL, 10000000000000000LL },	/* 0.0378037019363299 */
	{ 377632868825826LL, 10000000000000000LL },	/* 0.0377632868825826 */
	{ 37723001015571LL, 1000000000000000LL },	/* 0.037723001015571 */
	{ 376828436492868LL, 10000000000000000LL },	/* 0.0376828436492868 */
	{ 376428141028059LL, 10000000000000000LL },	/* 0.0376428141028059 */
	{ 376029117002394LL, 10000000000000000LL },	/* 0.0376029117002394 */
	{ 375631357706867LL, 10000000000000000LL },	/* 0.0375631357706867 */
	{ 375234856481875LL, 10000000000000000LL },	/* 0.0375234856481875 */
	{ 374839606716758LL, 10000000000000000LL },	/* 0.0374839606716758 */
	{ 374445601849334LL, 10000000000000000LL },	/* 0.0374445601849334 */
	{ 374052835365444LL, 10000000000000000LL },	/* 0.0374052835365444 */
	{ 373661300798504LL, 10000000000000000LL },	/* 0.0373661300798504 */
	{ 373270991729057LL, 10000000000000000LL },	/* 0.0373270991729057 */
	{ 372881901784334LL, 10000000000000000LL },	/* 0.0372881901784334 */
	{ 372494024637818LL, 10000000000000000LL },	/* 0.0372494024637818 */
	{ 372107354008813LL, 10000000000000000LL },	/* 0.0372107354008813 */
	{ 371721883662021LL, 10000000000000000LL },	/* 0.0371721883662021 */
	{ 371721883662021LL, 10000000000000000LL }	/* 0.0371721883662021 */
};

#endif
