/* $NetBSD: irix_syscallargs.h,v 1.52 2003/01/18 23:33:37 thorpej Exp $ */

/*
 * System call argument lists.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.47 2003/01/18 07:44:52 thorpej Exp 
 */

#ifndef _IRIX_SYS__SYSCALLARGS_H_
#define	_IRIX_SYS__SYSCALLARGS_H_

#ifdef	syscallarg
#undef	syscallarg
#endif

#define	syscallarg(x)							\
	union {								\
		register_t pad;						\
		struct { x datum; } le;					\
		struct { /* LINTED zero array dimension */		\
			int8_t pad[  /* CONSTCOND */			\
				(sizeof (register_t) < sizeof (x))	\
				? 0					\
				: sizeof (register_t) - sizeof (x)];	\
			x datum;					\
		} be;							\
	}

struct irix_sys_open_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
	syscallarg(int) mode;
};

struct irix_sys_break_args {
	syscallarg(caddr_t) nsize;
};

struct irix_sys_syssgi_args {
	syscallarg(int) request;
	syscallarg(void *) arg1;
	syscallarg(void *) arg2;
	syscallarg(void *) arg3;
	syscallarg(void *) arg4;
	syscallarg(void *) arg5;
};

struct irix_sys_shmsys_args {
	syscallarg(int) what;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
};

struct irix_sys_ioctl_args {
	syscallarg(int) fd;
	syscallarg(u_long) com;
	syscallarg(caddr_t) data;
};

struct irix_sys_sysmp_args {
	syscallarg(int) cmd;
	syscallarg(void *) arg1;
	syscallarg(void *) arg2;
	syscallarg(void *) arg3;
	syscallarg(void *) arg4;
};

struct irix_sys_utssys_args {
	syscallarg(void *) a1;
	syscallarg(void *) a2;
	syscallarg(int) sel;
	syscallarg(void *) a3;
};

struct irix_sys_fcntl_args {
	syscallarg(int) fd;
	syscallarg(int) cmd;
	syscallarg(char *) arg;
};

struct irix_sys_getrlimit64_args {
	syscallarg(int) resource;
	syscallarg(struct irix_rlimit64 *) rlp;
};

struct irix_sys_setrlimit64_args {
	syscallarg(int) resource;
	syscallarg(const struct irix_rlimit64 *) rlp;
};

struct irix_sys_lseek64_args {
	syscallarg(int) fd;
	syscallarg(int) pad1;
	syscallarg(irix_off64_t) offset;
	syscallarg(int) whence;
	syscallarg(int) pad2;
	syscallarg(int) pad3;
	syscallarg(int) pad4;
};

struct irix_sys_getdents_args {
	syscallarg(int) fildes;
	syscallarg(irix_dirent_t *) buf;
	syscallarg(int) nbytes;
};

struct irix_sys_sginap_args {
	syscallarg(long) ticks;
};

struct irix_sys_sigreturn_args {
	syscallarg(struct irix_sigcontext *) scp;
	syscallarg(struct irix_ucontext *) ucp;
	syscallarg(int) signo;
};

struct irix_sys_sproc_args {
	syscallarg(void *) entry;
	syscallarg(unsigned int) inh;
	syscallarg(void *) arg;
};

struct irix_sys_prctl_args {
	syscallarg(unsigned int) option;
	syscallarg(void *) arg1;
};

struct irix_sys_procblk_args {
	syscallarg(int) cmd;
	syscallarg(pid_t) pid;
	syscallarg(int) count;
};

struct irix_sys_sprocsp_args {
	syscallarg(void *) entry;
	syscallarg(unsigned int) inh;
	syscallarg(void *) arg;
	syscallarg(caddr_t) sp;
	syscallarg(irix_size_t) len;
};

struct irix_sys_mmap_args {
	syscallarg(void *) addr;
	syscallarg(irix_size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(irix_off_t) pos;
};

struct irix_sys_munmap_args {
	syscallarg(void *) addr;
	syscallarg(int) len;
};

struct irix_sys_mprotect_args {
	syscallarg(void *) addr;
	syscallarg(int) len;
	syscallarg(int) prot;
};

struct irix_sys_setpgrp_args {
	syscallarg(int) pid;
	syscallarg(int) pgid;
};

struct irix_sys_getrlimit_args {
	syscallarg(int) resource;
	syscallarg(struct irix_rlimit *) rlp;
};

struct irix_sys_setrlimit_args {
	syscallarg(int) resource;
	syscallarg(const struct irix_rlimit *) rlp;
};

struct irix_sys_systeminfo_args {
	syscallarg(int) what;
	syscallarg(char *) buf;
	syscallarg(long) len;
};

struct irix_sys_uname_args {
	syscallarg(struct irix_utsname *) name;
};

struct irix_sys_xstat_args {
	syscallarg(const int) version;
	syscallarg(const char *) path;
	syscallarg(struct stat *) buf;
};

struct irix_sys_lxstat_args {
	syscallarg(const int) version;
	syscallarg(const char *) path;
	syscallarg(struct stat *) buf;
};

struct irix_sys_fxstat_args {
	syscallarg(const int) version;
	syscallarg(const int) fd;
	syscallarg(struct stat *) buf;
};

struct irix_sys_sigaction_args {
	syscallarg(int) signum;
	syscallarg(const struct svr4_sigaction *) nsa;
	syscallarg(struct svr4_sigaction *) osa;
	syscallarg(void *) sigtramp;
};

struct irix_sys_sigprocmask_args {
	syscallarg(int) how;
	syscallarg(const irix_sigset_t *) set;
	syscallarg(irix_sigset_t *) oset;
};

struct irix_sys_swapctl_args {
	syscallarg(int) cmd;
	syscallarg(void *) arg;
};

struct irix_sys_getcontext_args {
	syscallarg(irix_ucontext_t *) ucp;
};

struct irix_sys_setcontext_args {
	syscallarg(const irix_ucontext_t *) ucp;
};

struct irix_sys_waitsys_args {
	syscallarg(int) type;
	syscallarg(int) pid;
	syscallarg(struct irix_irix5_siginfo *) info;
	syscallarg(int) options;
	syscallarg(struct rusage *) ru;
};

struct irix_sys_mmap64_args {
	syscallarg(void *) addr;
	syscallarg(irix_size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(int) pad1;
	syscallarg(irix_off_t) pos;
};

struct irix_sys_getmountid_args {
	syscallarg(const char *) path;
	syscallarg(irix_mountid_t *) buf;
};

struct irix_sys_getdents64_args {
	syscallarg(int) fildes;
	syscallarg(irix_dirent64_t *) buf;
	syscallarg(int) nbytes;
};

struct irix_sys_ngetdents_args {
	syscallarg(int) fildes;
	syscallarg(irix_dirent_t *) buf;
	syscallarg(unsigned short) nbyte;
	syscallarg(int *) eof;
};

struct irix_sys_ngetdents64_args {
	syscallarg(int) fildes;
	syscallarg(irix_dirent64_t *) buf;
	syscallarg(unsigned short) nbyte;
	syscallarg(int *) eof;
};

struct irix_sys_pidsprocsp_args {
	syscallarg(void *) entry;
	syscallarg(unsigned int) inh;
	syscallarg(void *) arg;
	syscallarg(caddr_t) sp;
	syscallarg(irix_size_t) len;
	syscallarg(irix_pid_t) pid;
};

struct irix_sys_usync_cntl_args {
	syscallarg(int) cmd;
	syscallarg(void *) arg;
};

/*
 * System call prototypes.
 */

int	sys_nosys(struct lwp *, void *, register_t *);
int	sys_exit(struct lwp *, void *, register_t *);
int	sys_fork(struct lwp *, void *, register_t *);
int	sys_read(struct lwp *, void *, register_t *);
int	sys_write(struct lwp *, void *, register_t *);
int	irix_sys_open(struct lwp *, void *, register_t *);
int	sys_close(struct lwp *, void *, register_t *);
int	svr4_sys_creat(struct lwp *, void *, register_t *);
int	sys_link(struct lwp *, void *, register_t *);
int	sys_unlink(struct lwp *, void *, register_t *);
int	svr4_sys_execv(struct lwp *, void *, register_t *);
int	sys_chdir(struct lwp *, void *, register_t *);
int	svr4_sys_time(struct lwp *, void *, register_t *);
int	sys_chmod(struct lwp *, void *, register_t *);
int	sys___posix_chown(struct lwp *, void *, register_t *);
int	irix_sys_break(struct lwp *, void *, register_t *);
int	compat_43_sys_lseek(struct lwp *, void *, register_t *);
int	sys_getpid(struct lwp *, void *, register_t *);
int	sys_setuid(struct lwp *, void *, register_t *);
int	sys_getuid_with_euid(struct lwp *, void *, register_t *);
int	svr4_sys_alarm(struct lwp *, void *, register_t *);
int	svr4_sys_fstat(struct lwp *, void *, register_t *);
int	svr4_sys_pause(struct lwp *, void *, register_t *);
int	svr4_sys_utime(struct lwp *, void *, register_t *);
int	svr4_sys_access(struct lwp *, void *, register_t *);
int	svr4_sys_nice(struct lwp *, void *, register_t *);
int	sys_sync(struct lwp *, void *, register_t *);
int	svr4_sys_kill(struct lwp *, void *, register_t *);
int	svr4_sys_pgrpsys(struct lwp *, void *, register_t *);
int	irix_sys_syssgi(struct lwp *, void *, register_t *);
int	sys_dup(struct lwp *, void *, register_t *);
int	sys_pipe(struct lwp *, void *, register_t *);
int	svr4_sys_times(struct lwp *, void *, register_t *);
int	sys_setgid(struct lwp *, void *, register_t *);
int	sys_getgid_with_egid(struct lwp *, void *, register_t *);
#ifdef SYSVMSG
int	svr4_sys_msgsys(struct lwp *, void *, register_t *);
#else
#endif
#ifdef SYSVSHM
int	irix_sys_shmsys(struct lwp *, void *, register_t *);
#else
#endif
#ifdef SYSVSEM
int	svr4_sys_semsys(struct lwp *, void *, register_t *);
#else
#endif
int	irix_sys_ioctl(struct lwp *, void *, register_t *);
int	irix_sys_sysmp(struct lwp *, void *, register_t *);
int	irix_sys_utssys(struct lwp *, void *, register_t *);
int	svr4_sys_execve(struct lwp *, void *, register_t *);
int	sys_umask(struct lwp *, void *, register_t *);
int	sys_chroot(struct lwp *, void *, register_t *);
int	irix_sys_fcntl(struct lwp *, void *, register_t *);
int	svr4_sys_ulimit(struct lwp *, void *, register_t *);
int	irix_sys_getrlimit64(struct lwp *, void *, register_t *);
int	irix_sys_setrlimit64(struct lwp *, void *, register_t *);
int	sys_nanosleep(struct lwp *, void *, register_t *);
int	irix_sys_lseek64(struct lwp *, void *, register_t *);
int	sys_rmdir(struct lwp *, void *, register_t *);
int	sys_mkdir(struct lwp *, void *, register_t *);
int	irix_sys_getdents(struct lwp *, void *, register_t *);
int	irix_sys_sginap(struct lwp *, void *, register_t *);
int	svr4_sys_getmsg(struct lwp *, void *, register_t *);
int	svr4_sys_putmsg(struct lwp *, void *, register_t *);
int	sys_poll(struct lwp *, void *, register_t *);
int	irix_sys_sigreturn(struct lwp *, void *, register_t *);
int	compat_43_sys_accept(struct lwp *, void *, register_t *);
int	sys_bind(struct lwp *, void *, register_t *);
int	sys_connect(struct lwp *, void *, register_t *);
int	compat_43_sys_gethostid(struct lwp *, void *, register_t *);
int	compat_43_sys_getpeername(struct lwp *, void *, register_t *);
int	compat_43_sys_getsockname(struct lwp *, void *, register_t *);
int	sys_getsockopt(struct lwp *, void *, register_t *);
int	sys_listen(struct lwp *, void *, register_t *);
int	compat_43_sys_recv(struct lwp *, void *, register_t *);
int	compat_43_sys_recvfrom(struct lwp *, void *, register_t *);
int	compat_43_sys_recvmsg(struct lwp *, void *, register_t *);
int	sys_select(struct lwp *, void *, register_t *);
int	compat_43_sys_send(struct lwp *, void *, register_t *);
int	compat_43_sys_sendmsg(struct lwp *, void *, register_t *);
int	sys_sendto(struct lwp *, void *, register_t *);
int	compat_43_sys_sethostid(struct lwp *, void *, register_t *);
int	sys_setsockopt(struct lwp *, void *, register_t *);
int	sys_shutdown(struct lwp *, void *, register_t *);
int	svr4_sys_socket(struct lwp *, void *, register_t *);
int	compat_43_sys_gethostname(struct lwp *, void *, register_t *);
int	compat_43_sys_sethostname(struct lwp *, void *, register_t *);
int	compat_09_sys_getdomainname(struct lwp *, void *, register_t *);
int	compat_09_sys_setdomainname(struct lwp *, void *, register_t *);
int	sys_truncate(struct lwp *, void *, register_t *);
int	sys_ftruncate(struct lwp *, void *, register_t *);
int	sys_rename(struct lwp *, void *, register_t *);
int	sys_symlink(struct lwp *, void *, register_t *);
int	sys_readlink(struct lwp *, void *, register_t *);
int	sys_setregid(struct lwp *, void *, register_t *);
int	sys_setreuid(struct lwp *, void *, register_t *);
int	sys_getitimer(struct lwp *, void *, register_t *);
int	sys_setitimer(struct lwp *, void *, register_t *);
int	sys_adjtime(struct lwp *, void *, register_t *);
int	svr4_sys_gettimeofday(struct lwp *, void *, register_t *);
int	irix_sys_sproc(struct lwp *, void *, register_t *);
int	irix_sys_prctl(struct lwp *, void *, register_t *);
int	irix_sys_procblk(struct lwp *, void *, register_t *);
int	irix_sys_sprocsp(struct lwp *, void *, register_t *);
int	irix_sys_mmap(struct lwp *, void *, register_t *);
int	irix_sys_munmap(struct lwp *, void *, register_t *);
int	irix_sys_mprotect(struct lwp *, void *, register_t *);
int	sys___msync13(struct lwp *, void *, register_t *);
int	sys_getpgrp(struct lwp *, void *, register_t *);
int	irix_sys_setpgrp(struct lwp *, void *, register_t *);
int	sys_fsync(struct lwp *, void *, register_t *);
int	sys_fchdir(struct lwp *, void *, register_t *);
int	irix_sys_getrlimit(struct lwp *, void *, register_t *);
int	irix_sys_setrlimit(struct lwp *, void *, register_t *);
int	sys___posix_fchown(struct lwp *, void *, register_t *);
int	sys_fchmod(struct lwp *, void *, register_t *);
int	irix_sys_systeminfo(struct lwp *, void *, register_t *);
int	irix_sys_uname(struct lwp *, void *, register_t *);
int	irix_sys_xstat(struct lwp *, void *, register_t *);
int	irix_sys_lxstat(struct lwp *, void *, register_t *);
int	irix_sys_fxstat(struct lwp *, void *, register_t *);
int	irix_sys_sigaction(struct lwp *, void *, register_t *);
int	svr4_sys_sigpending(struct lwp *, void *, register_t *);
int	irix_sys_sigprocmask(struct lwp *, void *, register_t *);
int	svr4_sys_sigsuspend(struct lwp *, void *, register_t *);
int	irix_sys_swapctl(struct lwp *, void *, register_t *);
int	irix_sys_getcontext(struct lwp *, void *, register_t *);
int	irix_sys_setcontext(struct lwp *, void *, register_t *);
int	irix_sys_waitsys(struct lwp *, void *, register_t *);
int	svr4_sys_statvfs(struct lwp *, void *, register_t *);
int	svr4_sys_fstatvfs(struct lwp *, void *, register_t *);
int	sys_readv(struct lwp *, void *, register_t *);
int	sys_writev(struct lwp *, void *, register_t *);
int	sys_truncate(struct lwp *, void *, register_t *);
int	sys_ftruncate(struct lwp *, void *, register_t *);
int	irix_sys_mmap64(struct lwp *, void *, register_t *);
int	svr4_sys_pread(struct lwp *, void *, register_t *);
int	svr4_sys_pwrite(struct lwp *, void *, register_t *);
int	irix_sys_getmountid(struct lwp *, void *, register_t *);
int	irix_sys_getdents64(struct lwp *, void *, register_t *);
int	irix_sys_ngetdents(struct lwp *, void *, register_t *);
int	irix_sys_ngetdents64(struct lwp *, void *, register_t *);
int	irix_sys_pidsprocsp(struct lwp *, void *, register_t *);
int	irix_sys_usync_cntl(struct lwp *, void *, register_t *);
#endif /* _IRIX_SYS__SYSCALLARGS_H_ */
