/*	$NetBSD: j720kbdmap.c,v 1.10 2004/03/13 17:23:32 bjh21 Exp $	*/

/*-
 * Copyright (c) 1997, 2001 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Juergen Hannken-Illjes.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the NetBSD
 *	Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: j720kbdmap.c,v 1.10 2004/03/13 17:23:32 bjh21 Exp $");

#include <sys/types.h>
#include <dev/wscons/wsksymdef.h>
#include <dev/wscons/wsksymvar.h>

#define KC(n) KS_KEYCODE(n)

static const keysym_t j720kbd_keydesc_us[] = {
/*  pos      command		normal		shifted		altgr */
    KC(1),   KS_Cmd_Debugger,	KS_Escape,
    KC(2),   KS_Cmd_Screen0,	KS_f1,
    KC(3),   KS_Cmd_Screen1,	KS_f2,
    KC(4),   KS_Cmd_Screen2,	KS_f3,
    KC(5),   KS_Cmd_Screen3,	KS_f4,
    KC(6),   KS_Cmd_Screen4,	KS_f5,
    KC(7),   KS_Cmd_Screen5,	KS_f6,
    KC(8),   KS_Cmd_Screen6,	KS_f7,
    KC(9),   KS_Cmd_Screen7,	KS_f8,
    KC(10),			KS_f9,
    KC(11),			KS_f10,
    KC(12),			KS_f11,
    KC(17),  			KS_1,		KS_exclam,	KS_asciitilde,
    KC(18),  			KS_2,		KS_at,		KS_grave,
    KC(19),  			KS_3,		KS_numbersign,	KS_sterling,
    KC(20),  			KS_4,		KS_dollar,   /* KS_euro, */
    KC(21),  			KS_5,		KS_percent,
    KC(22),  			KS_6,		KS_asciicircum,
    KC(23),  			KS_7,		KS_ampersand,
    KC(24),  			KS_8,		KS_asterisk,
    KC(25), 			KS_9,		KS_parenleft,
    KC(26), 			KS_0,		KS_parenright,
    KC(27), 			KS_minus,	KS_underscore,
    KC(28), 			KS_equal,	KS_plus,
    KC(33), 			KS_q,
    KC(34), 			KS_w,
    KC(35), 			KS_e,
    KC(36), 			KS_r,
    KC(37), 			KS_t,
    KC(38), 			KS_y,
    KC(39), 			KS_u,
    KC(40), 			KS_i,
    KC(41), 			KS_o,
    KC(42), 			KS_p,           KS_P,		KS_braceleft,
    KC(43), 			KS_backslash,	KS_bar,		KS_braceright,
    KC(44),			KS_BackSpace,
    KC(49), 			KS_a,
    KC(50), 			KS_s,
    KC(51), 			KS_d,
    KC(52), 			KS_f,
    KC(53), 			KS_g,
    KC(54), 			KS_h,
    KC(55), 			KS_j,
    KC(56), 			KS_k,
    KC(57), 			KS_l,
    KC(58), 			KS_semicolon,	KS_colon,	KS_bracketleft,
    KC(65), 			KS_z,
    KC(66), 			KS_x,
    KC(67), 			KS_c,
    KC(68), 			KS_v,
    KC(69), 			KS_b,
    KC(70), 			KS_n,
    KC(71), 			KS_m,
    KC(72), 			KS_comma,	KS_less,
    KC(73), 			KS_period,	KS_greater,
    KC(75), 			KS_apostrophe,	KS_quotedbl,	KS_bracketright,
    KC(76), 			KS_Return,
    KC(81), 			KS_Tab,
    KC(83), 			KS_Shift_L,
    KC(92), 			KS_Shift_R,
    KC(101),  KS_Cmd2,		KS_Alt_L,
    KC(102),			KS_Mode_switch,

    KC(113),			KS_Meta_L,
    KC(114),  KS_Cmd1,		KS_Control_L,
    KC(116), 			KS_space,
    KC(120), 			KS_slash,	KS_question,
    KC(121),  KS_Cmd_ResetEmul,	KS_Delete,

    KC(90),			KS_Up,
    KC(105),			KS_Left,
    KC(107),			KS_Right,
    KC(106),			KS_Down,
};

static const keysym_t j720kbd_keydesc_fr[] = {
/*  pos      normal		shifted		altgr		shift-altgr */
    KC(17),  KS_ampersand,	KS_1,		KS_plusminus,
    KC(18),  KS_eacute,		KS_2,		KS_asciitilde,
    KC(19),  KS_quotedbl,	KS_3,		KS_numbersign,
    KC(20),  KS_apostrophe,	KS_4,		KS_braceleft,
    KC(21),  KS_parenleft,	KS_5,		KS_bracketleft,
    KC(22),  KS_minus,		KS_6,		KS_bar,
    KC(23),  KS_egrave,		KS_7,		KS_grave,
    KC(24),  KS_underscore,	KS_8,		KS_backslash,
    KC(25),  KS_ccedilla,	KS_9,		KS_asciicircum,
    KC(26),  KS_agrave,		KS_0,		KS_at,
    KC(27),  KS_parenright,	KS_degree,	KS_bracketright,
    KC(28),  KS_equal,		KS_plus,	KS_braceright,
    KC(33),  KS_a,
    KC(34),  KS_z,
    KC(36),  KS_r,		KS_R,		KS_onequarter,
    KC(37),  KS_t,		KS_T,		KS_onehalf,
    KC(38),  KS_y,		KS_Y,		KS_threequarters,
    KC(43),  KS_dead_circumflex,KS_dead_diaeresis,
    KC(50),  KS_s,		KS_S,		KS_guillemotleft,
    KC(51),  KS_d,		KS_D,		KS_guillemotright,
    KC(59),  KS_dollar,		KS_sterling,	KS_currency,
    KC(49),  KS_q,		KS_Q,		KS_bar,
    KC(58),  KS_m,
    KC(60),  KS_asterisk,	KS_mu,
    KC(75),  KS_ugrave,		KS_percent,	KS_apostrophe,
    KC(65),  KS_w,		KS_W,		KS_less,
    KC(66),  KS_x,		KS_X,		KS_greater,
    KC(71),  KS_comma,		KS_question,	KS_mu,
    KC(72),  KS_semicolon,	KS_period,
    KC(73),  KS_colon,		KS_slash,
    KC(74),  KS_exclam,		KS_section,	KS_eacute,
    KC(83),  KS_Shift_L, 	KS_Shift_L,	KS_Caps_Lock,
    KC(102), KS_twosuperior,	KS_twosuperior,	KS_threesuperior,
    KC(114), KS_Cmd1,	KS_Control_L, KS_Control_L, KS_Num_Lock, 
    KC(120), KS_Mode_switch,	KS_Multi_key, 
};

static const keysym_t j720kbd_keydesc_jp[] = {
/*  pos      normal		shifted		altgr		shift-altgr */
    KC(18),  KS_2,              KS_quotedbl,
    KC(22),  KS_6,              KS_ampersand,
    KC(23),  KS_7,              KS_apostrophe,
    KC(24),  KS_8,              KS_parenleft,
    KC(25),  KS_9,              KS_parenright,
    KC(26),  KS_0,
    KC(27),  KS_minus,          KS_equal,
    KC(28),  KS_asciicircum,    KS_asciitilde,
    KC(43),  KS_at,             KS_grave,
    KC(59),  KS_bracketleft,    KS_braceleft,
    KC(58),  KS_semicolon,      KS_plus,
    KC(74),  KS_slash,		KS_question,
    KC(75),  KS_colon,          KS_asterisk,
    KC(12),  KS_Zenkaku_Hankaku, /* replace grave/tilde */
    KC(60),  KS_bracketright,   KS_braceright,
    KC(11),  KS_Hiragana_Katakana,
    KC(120), KS_backslash,      KS_underscore,

    KC(119), KS_Henkan,
    KC(102), KS_Muhenkan,
    KC(91),  KS_backslash,      KS_bar,
};

static const keysym_t j720kbd_keydesc_pt[] = {
/*  pos      normal		shifted		altgr		shift-altgr */
    KC(17),  KS_1,		KS_exclam,	KS_onesuperior,
    KC(18),  KS_2,		KS_at,		KS_twosuperior,
    KC(19),  KS_3,		KS_numbersign,	KS_threesuperior,
    KC(20),  KS_4,		KS_backslash,	KS_dollar,
    KC(21),  KS_5,		KS_percent,	KS_cent,
    KC(22),  KS_6,		KS_dead_diaeresis, KS_notsign,
    KC(23),  KS_7,		KS_ampersand,	KS_sterling,
    KC(28),  KS_equal,		KS_plus,	KS_section,
    KC(33),  KS_q,		KS_Q,		KS_slash,
    KC(34),  KS_w,		KS_W,		KS_question,	
    KC(35),  KS_e,		KS_E,
    KC(42),  KS_p,		KS_P,
    KC(43),  KS_dead_acute,    KS_dead_grave,
    KC(49),  KS_a,		KS_A,		KS_degree,
    KC(58),  KS_ccedilla,
    KC(59),  KS_bracketleft,	KS_braceleft,	KS_ordfeminine,
    KC(60),  KS_bracketright,	KS_braceright,	KS_masculine,
    KC(65),  KS_z,		KS_Z,		KS_backslash,
    KC(66),  KS_x,		KS_X,		KS_bar,
    KC(72),  KS_comma,		KS_less,	KS_guillemotleft,
    KC(73),  KS_period,	KS_greater,	KS_guillemotright,
    KC(74),  KS_semicolon,	KS_colon,
    KC(75),  KS_dead_tilde,	KS_dead_circumflex,
    KC(83),  KS_Shift_L,	KS_Shift_L,     KS_Caps_Lock,
    KC(102), KS_apostrophe,	KS_quotedbl,
    KC(113), KS_slash,		KS_bar,		KS_backslash,
    KC(120), KS_Mode_switch,	KS_Multi_key,

    KC(90),  KS_Up,             KS_Up,          KS_Prior,
    KC(105), KS_Left,           KS_Left,        KS_Home,
    KC(107), KS_Right,          KS_Right,       KS_End,
    KC(106), KS_Down,           KS_Down,        KS_Next,
};

#define KBD_MAP(name, base, map) \
			{ name, base, sizeof(map)/sizeof(keysym_t), map }
/* KBD_NULLMAP generates a entry for machine native variant.
   the entry will be modified by machine dependent keyboard driver. */
#define KBD_NULLMAP(name, base) { name, base, 0, 0 }

const struct wscons_keydesc j720kbd_keydesctab[] = {
	KBD_MAP(KB_US,			0,	j720kbd_keydesc_us),
	KBD_MAP(KB_JP,			KB_US,	j720kbd_keydesc_jp),
	KBD_MAP(KB_FR,			KB_US,	j720kbd_keydesc_fr),
	KBD_MAP(KB_PT,			KB_US,	j720kbd_keydesc_pt),
	{0, 0, 0, 0}
};

#undef KBD_MAP
#undef KC
