/*	$NetBSD: strncmp.S,v 1.1 2002/10/17 11:53:33 scw Exp $	*/

/*
 * Copyright 2002 Wasabi Systems, Inc.
 * All rights reserved.
 *
 * Written by Steve C. Woodford for Wasabi Systems, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed for the NetBSD Project by
 *      Wasabi Systems, Inc.
 * 4. The name of Wasabi Systems, Inc. may not be used to endorse
 *    or promote products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY WASABI SYSTEMS, INC. ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL WASABI SYSTEMS, INC
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <machine/asm.h>

/*
 * int strncmp(const char *s1, const char *s2, size_t len)
 *
 * Note:
 * We assume that this routine is mostly called for short strings, and that
 * the overhead of aligning s1/s2 to permit long or quad comparisons is
 * just Not Worth The Effort.
 */
ENTRY(strncmp)
#ifndef _LP64
	add.l	r2, r63, r5
	add.l	r3, r63, r3
	addz.l	r4, r63, r4
#else
	add	r2, r63, r5
#endif
	pta/l	1f, tr1
	ptabs/u	r18, tr0
	movi	0, r2
	beq/u	r4, r63, tr0		/* Bail out now if len == 0 */
	movi	0, r6
1:	ldx.ub	r5, r6, r0		/* r0 = *s1 */
	ldx.ub	r3, r6, r1		/* r1 = *s2 */
	addi	r6, 1, r6		/* s1++, s2++ */
	sub	r0, r1, r2		/* r2 = r0 - r1 */
	beq/u	r4, r6, tr0		/* Return now if compared "len" bytes */
	bne/u	r0, r1, tr0		/* Return if no match */
	bne/l	r0, r63, tr1		/* Loop until *s1 == '\0' */
	blink	tr0, r63
