# BSDI Makefile.inc,v 1.7 2000/03/08 19:11:42 jch Exp

BINDDIR=${.CURDIR}/../../contrib/bind
BINDLIBSRC=${BINDDIR}/src/lib
BINDINCSRC=${BINDDIR}/src/include
#BINDMANSRC=${BINDDIR}/doc/man
#BINDMAN3=	getaddrinfo.0 gethostbyname.0 getipnodebyname.0 getnameinfo.0 \
#		getnetent.0 hesiod.0 inet_cidr.0 resolver.0 tsig.0
#BINDMANSRC3=${BINDMAN3:S/.0$/.3/g}
#CLEANFILES+=${BINDMANSRC3}

CFLAGS+=-I${BINDINCSRC} -I${BINDDIR}/src/port/bsdos/include
CFLAGS+=-I${BINDLIBSRC}/cylink -I${BINDLIBSRC}/dnssafe -I${BINDLIBSRC}/irs
CFLAGS+=-D_REENTRANT -DCYLINK_DSS -DHMAC_MD5 -DUSE_MD5 -DDNSSAFE

.PATH:	${BINDLIBSRC}/cylink ${BINDLIBSRC}/dnssafe ${BINDLIBSRC}/dst \
	${BINDLIBSRC}/inet ${BINDLIBSRC}/irs ${BINDLIBSRC}/isc \
	${BINDLIBSRC}/nameser ${BINDLIBSRC}/resolv

bindbeforeinstall: 
	cd ${BINDINCSRC} && install -c \
	    -o ${BINOWN} -g ${BINGRP} -m 444 hesiod.h irp.h irs.h \
	    netdb.h res_update.h resolv.h ${DESTDIR}/usr/include/
	cd ${BINDINCSRC}/arpa && install -c \
	    -o ${BINOWN} -g ${BINGRP} -m 444 inet.h nameser.h \
	    nameser_compat.h ${DESTDIR}/usr/include/arpa/
	cd ${BINDINCSRC}/isc && install -c -o ${BINOWN} -g ${BINGRP} -m 444 \
	    assertions.h dst.h eventlib.h heap.h irpmarshall.h list.h \
	    logging.h memcluster.h misc.h tree.h ${DESTDIR}/usr/include/isc/
	install -c -o ${BINOWN} -g ${BINGRP} -m 444 \
	    ${BINDDIR}/src/port/bsdos/include/sys/bitypes.h \
	    ${DESTDIR}/usr/include/sys/

## cylink:
SRCS+=	bits.c bn.c bn00.c ctk_prime.c dss.c lbn00.c lbnmem.c legal.c \
	math.c rand.c sha.c swap.c

## dnssafe:
SRCS+=	ahcbcpad.c ahchdig.c ahchencr.c ahchgen.c ahchrand.c ahdigest.c \
	ahencryp.c ahgen.c ahrandom.c ahrsaenc.c ahrsaepr.c ahrsaepu.c \
	aichdig.c aichenc8.c aichencn.c aichencr.c aichgen.c aichrand.c \
	aimd5.c aimd5ran.c ainfotyp.c ainull.c airsaepr.c airsaepu.c \
	airsakgn.c airsaprv.c airsapub.c algchoic.c algobj.c amcrte.c \
	ammd5.c ammd5r.c amrkg.c amrsae.c balg.c bgclrbit.c bgmdmpyx.c \
	bgmdsqx.c bgmodexp.c bgpegcd.c big2exp.c bigabs.c bigacc.c \
	bigarith.c bigcmp.c bigconst.c biginv.c biglen.c bigmodx.c bigmpy.c \
	bigpdiv.c bigpmpy.c bigpmpyh.c bigpmpyl.c bigpsq.c bigqrx.c bigsmod.c \
	bigtocan.c bigu.c bigunexp.c binfocsh.c bkey.c bmempool.c cantobig.c \
	crt2.c digest.c digrand.c encrypt.c generate.c intbits.c intitem.c \
	keyobj.c ki8byte.c kifulprv.c kiitem.c kinfotyp.c kipkcrpr.c \
	kirsacrt.c kirsapub.c md5.c md5rand.c prime.c random.c rsa.c \
	rsakeygn.c seccbcd.c seccbce.c surrendr.c

## dst:
SRCS+=	bsafe_link.c cylink_link.c dst_api.c eay_dss_link.c hmac_link.c \
	md5_dgst.c prandom.c rsaref_link.c support.c

# inet
SRCS+=	inet_addr.c inet_cidr_ntop.c inet_cidr_pton.c inet_lnaof.c \
	inet_makeaddr.c inet_net_ntop.c inet_net_pton.c inet_neta.c \
	inet_netof.c inet_network.c inet_ntoa.c inet_ntop.c inet_pton.c \
	nsap_addr.c

## isc
SRCS+=	assertions.c base64.c bitncmp.c ctl_clnt.c ctl_p.c ctl_srvr.c \
	ev_connects.c ev_files.c ev_streams.c ev_timers.c ev_waits.c \
	eventlib.c heap.c logging.c memcluster.c tree.c

# irs
SRCS+=	dns.c dns_gr.c dns_ho.c dns_nw.c dns_pr.c dns_pw.c dns_sv.c \
	gen.c gen_gr.c gen_ho.c gen_ng.c gen_nw.c gen_pr.c \
	gen_pw.c gen_sv.c getgrent.c getgrent_r.c gethostent.c \
	gethostent_r.c getnetent.c getnetent_r.c getnetgrent.c \
	getnetgrent_r.c getprotoent.c getprotoent_r.c getpwent.c \
	getpwent_r.c getservent.c getservent_r.c hesiod.c irp.c irp_gr.c \
	irp_ho.c irp_ng.c irp_nw.c irp_pr.c irp_pw.c irp_sv.c irpmarshall.c \
	irs_data.c lcl.c lcl_gr.c lcl_ho.c lcl_ng.c lcl_nw.c lcl_pr.c \
	lcl_pw.c lcl_sv.c nis.c nis_gr.c nis_ho.c nis_ng.c nis_nw.c \
	nis_pr.c nis_pw.c nis_sv.c nul_ng.c util.c

## nameser
SRCS+=	ns_date.c ns_name.c ns_netint.c ns_parse.c ns_print.c \
	ns_samedomain.c ns_sign.c ns_ttl.c ns_verify.c

# resolv
SRCS+=	herror.c res_comp.c res_data.c res_debug.c res_findzonecut.c \
	res_init.c res_mkquery.c res_mkupdate.c res_query.c res_send.c \
	res_sendsigned.c res_update.c
