/*
 * Copyright (c) 1992, 1993
 *	Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)netstat.h	8.2 (Berkeley) 1/4/94
 */

#include <sys/cdefs.h>

extern int	Aflag;		/* show addresses of protocol control block */
extern int	aflag;		/* show all sockets (including servers) */
extern int	bflag;		/* show bytes instead of packets */
extern int	dflag;		/* show i/f dropped packets */
extern int	gflag;		/* show group (multicast) routing or stats */
extern int	kflag;		/* use kmem instead of sysctl */
extern int	iflag;		/* show interfaces */
extern int	lflag;		/* show routing table with use and ref */
extern int	mflag;		/* show memory stats */
extern int	nflag;		/* show addresses numerically */
extern int	pflag;		/* show given protocol */
extern int	rflag;		/* show routing tables (or routing stats) */
extern int	sflag;		/* show protocol statistics */
extern int	tflag;		/* show i/f watchdog timers */

extern int	interval;	/* repeat interval for i/f stats */

extern char	*interface;	/* desired i/f for stats, or NULL for all i/fs */
extern int	unit;		/* unit number for above */

extern int	af;		/* address family */

extern char	*prog;		/* program name */


extern int	kread __P((u_long, void *, size_t));
extern int	skread __P((char *, int *, size_t, u_long, void *, size_t));

extern void	protopr __P((u_long, char *));
extern void	tcp_stats __P((u_long, char *));
extern void	udp_stats __P((u_long, char *));
extern void	ip_stats __P((u_long, char *));
extern void	icmp_stats __P((u_long, char *));
extern void	igmp_stats __P((u_long, char *));

#ifdef INET6
extern void	ip6protopr __P((u_long, char *));
extern void	tcp6_stats __P((u_long, char *));
extern void	udp6_stats __P((u_long, char *));
extern void	ip6_stats __P((u_long, char *));
extern void	ip6_ifstats __P((char *));
extern void	icmp6_stats __P((u_long, char *));
extern void	icmp6_ifstats __P((char *));
extern void	pim6_stats __P((u_long, char *));
extern void	rip6_stats __P((u_long, char *));
extern void	mroute6pr __P((u_long, u_long, u_long));
extern void	mrt6_stats __P((u_long, u_long));
extern char	*netname6 __P((struct sockaddr_in6 *, struct in6_addr *));
extern char	*routename6 __P((struct sockaddr_in6 *));
#endif /* INET6 */
#ifdef IPSEC
extern void	ipsec_stats __P((u_long, char *));
extern void	pfkey_stats __P((u_long, char *));
#endif

extern void	mbpr(u_long);

extern void	hostpr __P((u_long, u_long));
extern void	impstats __P((u_long, u_long));

extern void	intpr __P((int, u_long));

extern void	pr_rthdr __P(());
extern void	pr_family __P((int));
extern void	rt_stats __P((u_long));
extern char	*ns_phost __P((struct sockaddr *));
extern void	upHex __P((char *));

extern char	*routename __P((u_long));
extern char	*netname __P((u_long, u_long));
extern char	*ns_print __P((struct sockaddr *));
extern void	routepr __P((u_long));

extern void	nsprotopr __P((u_long, char *));
extern void	spp_stats __P((u_long, char *));
extern void	idp_stats __P((u_long, char *));
extern void	nserr_stats __P((u_long, char *));

extern void	intpr __P((int, u_long));

extern void	unixpr __P((u_long));

extern void	esis_stats __P((u_long, char *));
extern void	clnp_stats __P((u_long, char *));
extern void	cltp_stats __P((u_long, char *));
extern void	iso_protopr __P((u_long, char *));
extern void	iso_protopr1 __P((u_long, int));
extern void	tp_protopr __P((u_long, char *));
extern void	tp_inproto __P((u_long));
extern void	tp_stats __P((caddr_t, caddr_t));

extern void	mroutepr __P((off_t, off_t, off_t));
extern void	mrt_stats __P((off_t, off_t, off_t));

extern 	void	if_stats __P((u_long, void (*) __P((char *))));

#define	PLURAL(n)	(n == 1 ? "" : "s")
#define	PLURALES(n)	(n == 1 ? "" : "es")
#define	PLURALIES(n)	(n == 1 ? "y" : "ies")
