/*	BSDI inet.c,v 2.8 1996/11/12 20:08:05 jch Exp	*/
/*
 * Copyright (c) 1983, 1988, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char sccsid[] = "@(#)inet.c	8.4 (Berkeley) 4/20/94";
#endif /* not lint */

#include <sys/param.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/mbuf.h>
#include <sys/protosw.h>
#include <sys/sysctl.h>

#include <net/route.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/in_pcb.h>
#include <netinet/ip_icmp.h>
#include <netinet/icmp_var.h>
#include <netinet/igmp_var.h>
#include <netinet/ip_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>
#include <netinet/tcp_seq.h>
#define TCPSTATES
#include <netinet/tcp_fsm.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>
#include <netinet/tcp_debug.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>

#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "netstat.h"

struct	inpcb inpcb;
struct	tcpcb tcpcb;
struct	socket sockb;

char	*inetname __P((struct in_addr *));
void	inetprint __P((struct in_addr *, int, char *));

/*
 * Print a summary of connections related to an Internet
 * protocol.  For TCP, also give state of connection.
 * Listening processes (aflag) are suppressed unless the
 * -a (all) flag is specified.
 */
void
protopr(off, name)
	u_long off;
	char *name;
{
	struct inpcb cb;
	struct inpcb *prev, *next;
	int istcp;
	static int first = 1;

	if (off == 0)
		return;
	istcp = strcmp(name, "tcp") == 0;
	kread(off, (char *)&cb, sizeof (struct inpcb));
	inpcb = cb;
	prev = (struct inpcb *)off;
	if (inpcb.inp_next == (struct inpcb *)off)
		return;
	while (inpcb.inp_next != (struct inpcb *)off) {
		next = inpcb.inp_next;
		kread((u_long)next, (char *)&inpcb, sizeof (inpcb));
		if (inpcb.inp_prev != prev) {
			printf("???\n");
			break;
		}
		if (!aflag &&
		  inet_lnaof(inpcb.inp_laddr) == INADDR_ANY) {
			prev = next;
			continue;
		}
		kread((u_long)inpcb.inp_socket, (char *)&sockb, sizeof (sockb));
		if (istcp) {
			kread((u_long)inpcb.inp_ppcb,
			    (char *)&tcpcb, sizeof (tcpcb));
		}
		if (first) {
			printf("Active Internet connections");
			if (aflag)
				printf(" (including servers)");
			putchar('\n');
			if (Aflag)
				printf("%-8.8s ", "PCB");
			printf(Aflag ?
				"%-5.5s %-6.6s %-6.6s  %-18.18s %-18.18s %s\n" :
				"%-5.5s %-6.6s %-6.6s  %-22.22s %-22.22s %s\n",
				"Proto", "Recv-Q", "Send-Q",
				"Local Address", "Foreign Address", "(state)");
			first = 0;
		}
		if (Aflag)
			if (istcp)
				printf("%8lx ", (u_long)inpcb.inp_ppcb);
			else
				printf("%8lx ", (u_long)next);
		printf("%-5.5s %6ld %6ld ", name, sockb.so_rcv.sb_cc,
		    sockb.so_snd.sb_cc);
		inetprint(&inpcb.inp_laddr, (int)inpcb.inp_lport, name);
		inetprint(&inpcb.inp_faddr, (int)inpcb.inp_fport, name);
		if (istcp) {
			if (tcpcb.t_state < 0 || tcpcb.t_state >= TCP_NSTATES)
				printf(" %d", tcpcb.t_state);
			else
				printf(" %s", tcpstates[tcpcb.t_state]);
		}
		putchar('\n');
		prev = next;
	}
}

/*
 * Dump TCP statistics structure.
 */
void
tcp_stats(off, name)
	u_long off;
	char *name;
{
	struct tcpstat tcpstat;
	int mib[] = { CTL_NET, PF_INET, IPPROTO_TCP, TCPCTL_STATS };

	if (skread(name, mib, sizeof(mib)/sizeof(*mib),
	    off, &tcpstat, sizeof(tcpstat)))
		return;

	printf ("%s:\n", name);

#define	p(f, m) if (tcpstat.f || sflag <= 1) \
    printf(m, (u_quad_t)tcpstat.f, PLURAL(tcpstat.f))
#define	p_5(f, m) if (tcpstat.f || sflag <= 1) \
    printf(m, (u_quad_t)tcpstat.f)
#define	p2(f1, f2, m) if (tcpstat.f1 || tcpstat.f2 || sflag <= 1) \
    printf(m, (u_quad_t)tcpstat.f1, PLURAL(tcpstat.f1), \
        (u_quad_t)tcpstat.f2, PLURAL(tcpstat.f2))
#define	p2_5(f1, f2, m) if (tcpstat.f1 || tcpstat.f2 || sflag <= 1) \
    printf(m, (u_quad_t)tcpstat.f1, PLURAL(tcpstat.f1), \
        (u_quad_t)tcpstat.f2)
#define	p3(f, m) if (tcpstat.f || sflag <= 1) \
    printf(m, (u_quad_t)tcpstat.f, PLURALES(tcpstat.f))

	p(tcps_sndtotal, "\t%qu packet%s sent\n");
	p2(tcps_sndpack,tcps_sndbyte,
		"\t\t%qu data packet%s (%qu byte%s)\n");
	p2(tcps_sndrexmitpack, tcps_sndrexmitbyte,
		"\t\t%qu data packet%s (%qu byte%s) retransmitted\n");
	p(tcps_sndrexmitfast, "\t\t%qu fast retransmit%s\n");
	p2_5(tcps_sndacks, tcps_delack,
		"\t\t%qu ack-only packet%s (%qu delayed)\n");
	p(tcps_sndurg, "\t\t%qu URG only packet%s\n");
	p(tcps_sndprobe, "\t\t%qu window probe packet%s\n");
	p(tcps_sndwinup, "\t\t%qu window update packet%s\n");
	p(tcps_sndctrl, "\t\t%qu control packet%s\n");
	p(tcps_rcvtotal, "\t%qu packet%s received\n");
	p2(tcps_rcvackpack, tcps_rcvackbyte, "\t\t%qu ack%s (for %qu byte%s)\n");
	p(tcps_rcvdupack, "\t\t%qu duplicate ack%s\n");
	p(tcps_rcvacktoomuch, "\t\t%qu ack%s for unsent data\n");
	p2(tcps_rcvpack, tcps_rcvbyte,
		"\t\t%qu packet%s (%qu byte%s) received in-sequence\n");
	p2(tcps_rcvduppack, tcps_rcvdupbyte,
		"\t\t%qu completely duplicate packet%s (%qu byte%s)\n");
	p(tcps_pawsdrop, "\t\t%qu old duplicate packet%s\n");
	p2(tcps_rcvpartduppack, tcps_rcvpartdupbyte,
		"\t\t%qu packet%s with some dup. data (%qu byte%s duped)\n");
	p2(tcps_rcvoopack, tcps_rcvoobyte,
		"\t\t%qu out-of-order packet%s (%qu byte%s)\n");
	p2(tcps_rcvpackafterwin, tcps_rcvbyteafterwin,
		"\t\t%qu packet%s (%qu byte%s) of data after window\n");
	p(tcps_rcvwinprobe, "\t\t%qu window probe%s\n");
	p(tcps_rcvwinupd, "\t\t%qu window update packet%s\n");
	p(tcps_rcvafterclose, "\t\t%qu packet%s received after close\n");
	p(tcps_rcvbadsum, "\t\t%qu discarded for bad checksum%s\n");
	p(tcps_rcvbadoff, "\t\t%qu discarded for bad header offset field%s\n");
	p_5(tcps_rcvshort, "\t\t%qu discarded because packet too short\n");
	p(tcps_connattempt, "\t%qu connection request%s\n");
	p(tcps_accepts, "\t%qu connection accept%s\n");
	p(tcps_badsyn, "\t%qu bad connection attempt%s\n");
	p(tcps_connects, "\t%qu connection%s established (including accepts)\n");
	p2(tcps_closed, tcps_drops,
		"\t%qu connection%s closed (including %qu drop%s)\n");
	p(tcps_conndrops, "\t%qu embryonic connection%s dropped\n");
	p2(tcps_rttupdated, tcps_segstimed,
		"\t%qu segment%s updated rtt (of %qu attempt%s)\n");
	p(tcps_rexmttimeo, "\t%qu retransmit timeout%s\n");
	p(tcps_timeoutdrop, "\t\t%qu connection%s dropped by rexmit timeout\n");
	p(tcps_persisttimeo, "\t%qu persist timeout%s\n");
	p(tcps_persistdrop, "\t%qu connection%s timed out in persist\n");
	p(tcps_keeptimeo, "\t%qu keepalive timeout%s\n");
	p(tcps_keepprobe, "\t\t%qu keepalive probe%s sent\n");
	p(tcps_keepdrops, "\t\t%qu connection%s dropped by keepalive\n");
	p(tcps_droppedsyn, "\t\t%qu syn%s dropped due to queue or memory full\n");
	p(tcps_predack, "\t%qu correct ACK header prediction%s\n");
	p(tcps_preddat, "\t%qu correct data packet header prediction%s\n");
	p3(tcps_pcbcachemiss, "\t%qu PCB cache miss%s\n");
	p_5(tcps_sc_added, "\t%qu SYN cache entries added\n");
	p_5(tcps_sc_completed, "\t\t%qu completed\n");
	p_5(tcps_sc_aborted, "\t\t%qu aborted (no space to build PCB)\n");
	p_5(tcps_sc_timed_out, "\t\t%qu timed out\n");
	p_5(tcps_sc_overflowed, "\t\t%qu dropped due to overflow\n");
	p_5(tcps_sc_bucketoverflow, "\t\t%qu dropped due to bucket overflow\n");
	p_5(tcps_sc_reset, "\t\t%qu dropped due to RST\n");
	p_5(tcps_sc_unreach, "\t\t%qu dropped due to ICMP unreachable\n");
	p(tcps_sc_dupesyn, "\t%qu duplicate SYN%s received for entries already in the cache\n");
	p(tcps_sc_dropped, "\t%qu SYN%s dropped (no route or no space)\n");

#undef	p
#undef	p_5
#undef	p2
#undef	p2_5
#undef	p3
}

/*
 * Dump UDP statistics structure.
 */
void
udp_stats(off, name)
	u_long off;
	char *name;
{
	struct udpstat udpstat;
	u_quad_t delivered;
	int mib[] = { CTL_NET, PF_INET, IPPROTO_UDP, UDPCTL_STATS };

	if (skread(name, mib, sizeof(mib)/sizeof(*mib),
	    off, &udpstat, sizeof(udpstat)))
		return;

	printf("%s:\n", name);
#define	p(f, m) if (udpstat.f || sflag <= 1) \
    printf(m, (u_quad_t)udpstat.f, PLURAL(udpstat.f))
#define	p_5(f, m) if (udpstat.f || sflag <= 1) \
    printf(m, (u_quad_t)udpstat.f)
	p(udps_ipackets, "\t%qu datagram%s received\n");
	p_5(udps_hdrops, "\t%qu with incomplete header\n");
	p_5(udps_badlen, "\t%qu with bad data length field\n");
	p_5(udps_badsum, "\t%qu with bad checksum\n");
	p_5(udps_nosum, "\t%qu with no checksum\n");
	p_5(udps_noport, "\t%qu dropped due to no socket\n");
	p(udps_noportbcast, "\t%qu broadcast/multicast datagram%s dropped due to no socket\n");
	p_5(udps_fullsock, "\t%qu dropped due to full socket buffers\n");
	delivered = udpstat.udps_ipackets -
		    udpstat.udps_hdrops -
		    udpstat.udps_badlen -
		    udpstat.udps_badsum -
		    udpstat.udps_noport -
		    udpstat.udps_fullsock;
	if (delivered || sflag <= 1)
		printf("\t%qu delivered\n", delivered);
	p(udps_opackets, "\t%qu datagram%s output\n");
#undef	p
#undef	p_5
}

/*
 * Dump IP statistics structure.
 */
void
ip_stats(off, name)
	u_long off;
	char *name;
{
	struct ipstat ipstat;
	int mib[] = { CTL_NET, PF_INET, IPPROTO_IP, IPCTL_STATS };

	if (skread(name, mib, sizeof(mib)/sizeof(*mib),
	    off, &ipstat, sizeof(ipstat)))
		return;

	printf("%s:\n", name);

#define	p(f, m) if (ipstat.f || sflag <= 1) \
    printf(m, (u_quad_t)ipstat.f, PLURAL(ipstat.f))
#define	p_5(f, m) if (ipstat.f || sflag <= 1) \
    printf(m, (u_quad_t)ipstat.f)

	p(ips_total, "\t%qu total packet%s received\n");
	p(ips_badsum, "\t%qu bad header checksum%s\n");
	p_5(ips_toosmall, "\t%qu with size smaller than minimum\n");
	p_5(ips_tooshort, "\t%qu with data size < data length\n");
	p_5(ips_badhlen, "\t%qu with header length < data size\n");
	p_5(ips_badlen, "\t%qu with data length < header length\n");
	p_5(ips_badoptions, "\t%qu with bad options\n");
	p_5(ips_badvers, "\t%qu with incorrect version number\n");
	p_5(ips_badsrcintf, "\t%qu with bad source interface\n");
	p(ips_fragments, "\t%qu fragment%s received\n");
	p(ips_fragdropped, "\t%qu fragment%s dropped (dup or out of space)\n");
	p(ips_fragtimeout, "\t%qu fragment%s dropped after timeout\n");
	p(ips_fragoverflow, "\t%qu fragmented packet%s dropped due to overflow\n");
	p(ips_reassembled, "\t%qu packet%s reassembled ok\n");
	p(ips_delivered, "\t%qu packet%s for this host\n");
	p(ips_noproto, "\t%qu packet%s for unknown/unsupported protocol\n");
	p(ips_forward, "\t%qu packet%s forwarded\n");
	p(ips_cantforward, "\t%qu packet%s not forwardable\n");
	p(ips_redirectsent, "\t%qu redirect%s sent\n");
	p(ips_localout, "\t%qu packet%s sent from this host\n");
	p(ips_rawout, "\t%qu packet%s sent with fabricated ip header\n");
	p(ips_odropped, "\t%qu output packet%s dropped due to no bufs, etc.\n");
	p(ips_noroute, "\t%qu output packet%s discarded due to no route\n");
	p(ips_fragmented, "\t%qu output datagram%s fragmented\n");
	p(ips_ofragments, "\t%qu fragment%s created\n");
	p(ips_cantfrag, "\t%qu datagram%s that can't be fragmented\n");
	p(ips_nogif, "\t%qu tunneling packet%s that can't find gif\n");
	p(ips_badaddr, "\t%qu datagram%s with bad address in header\n");
#undef p
}

static	char *icmpnames[] = {
	"echo reply",
	"#1",
	"#2",
	"destination unreachable",
	"source quench",
	"routing redirect",
	"#6",
	"#7",
	"echo",
	"router advertisement",
	"router solicitation",
	"time exceeded",
	"parameter problem",
	"time stamp",
	"time stamp reply",
	"information request",
	"information request reply",
	"address mask request",
	"address mask reply",
};

/*
 * Dump ICMP statistics.
 */
void
icmp_stats(off, name)
	u_long off;
	char *name;
{
	struct icmpstat icmpstat;
	int i, first;
	int mib[] = { CTL_NET, PF_INET, IPPROTO_ICMP, ICMPCTL_STATS };

	if (skread(name, mib, sizeof(mib)/sizeof(*mib),
	    off, &icmpstat, sizeof (icmpstat)))
		return;
	
	printf("%s:\n", name);

#define	p(f, m) if (icmpstat.f || sflag <= 1) \
    printf(m, (u_quad_t)icmpstat.f, PLURAL(icmpstat.f))

	p(icps_error, "\t%qu call%s to icmp_error\n");
	p(icps_oldicmp,
	    "\t%qu error%s not generated because old message was icmp\n");
	for (first = 1, i = 0; i < ICMP_MAXTYPE + 1; i++)
		if (icmpstat.icps_outhist[i] != 0) {
			if (first) {
				printf("\tOutput histogram:\n");
				first = 0;
			}
			printf("\t\t%s: %qu\n", icmpnames[i],
				(u_quad_t)icmpstat.icps_outhist[i]);
		}
	p(icps_badcode, "\t%qu message%s with bad code fields\n");
	p(icps_tooshort, "\t%qu message%s < minimum length\n");
	p(icps_checksum, "\t%qu bad checksum%s\n");
	p(icps_badlen, "\t%qu message%s with bad length\n");
	for (first = 1, i = 0; i < ICMP_MAXTYPE + 1; i++)
		if (icmpstat.icps_inhist[i] != 0) {
			if (first) {
				printf("\tInput histogram:\n");
				first = 0;
			}
			printf("\t\t%s: %qu\n", icmpnames[i],
				(u_quad_t)icmpstat.icps_inhist[i]);
		}
	p(icps_reflect, "\t%qu message response%s generated\n");
#undef p
}

/*
 * Dump IGMP statistics structure.
 */
void
igmp_stats(off, name)
	u_long off;
	char *name;
{
	struct igmpstat igmpstat;
	int mib[] = { CTL_NET, PF_INET, IPPROTO_IGMP, IGMPCTL_STATS };

	if (skread(name, mib, sizeof(mib)/sizeof(*mib),
	    off, &igmpstat, sizeof(igmpstat)))
		return;

	printf("%s:\n", name);

#define	p(f, m) if (igmpstat.f || sflag <= 1) \
    printf(m, (u_quad_t)igmpstat.f, PLURAL(igmpstat.f))
#define	py(f, m) if (igmpstat.f || sflag <= 1) \
    printf(m, (u_quad_t)igmpstat.f, PLURALIES(igmpstat.f))
	p(igps_rcv_total, "\t%qu message%s received\n");
        p(igps_rcv_tooshort, "\t%qu message%s received with too few bytes\n");
        p(igps_rcv_badsum, "\t%qu message%s received with bad checksum\n");
        py(igps_rcv_queries, "\t%qu membership quer%s received\n");
        py(igps_rcv_badqueries, "\t%qu membership quer%s received with invalid field(s)\n");
        p(igps_rcv_reports, "\t%qu membership report%s received\n");
        p(igps_rcv_badreports, "\t%qu membership report%s received with invalid field(s)\n");
        p(igps_rcv_ourreports, "\t%qu membership report%s received for groups to which we belong\n");
        p(igps_snd_reports, "\t%qu membership report%s sent\n");
#undef p
#undef py
}

/*
 * Pretty print an Internet address (net address + port).
 * If the nflag was specified, use numbers instead of names.
 */
void
inetprint(in, port, proto)
	struct in_addr *in;
	int port;
	char *proto;
{
	struct servent *sp = 0;
	char line[80], *cp;
	int width;

	sprintf(line, "%.*s.", (Aflag && !nflag) ? 12 : 16, inetname(in));
	cp = index(line, '\0');
	if (!nflag && port)
		sp = getservbyport((int)port, proto);
	if (sp || port == 0)
		sprintf(cp, "%.8s", sp ? sp->s_name : "*");
	else
		sprintf(cp, "%d", ntohs((u_short)port));
	width = Aflag ? 18 : 22;
	printf(" %-*.*s", width, width, line);
}

/*
 * Construct an Internet address representation.
 * If the nflag has been supplied, give
 * numeric value, otherwise try for symbolic name.
 */
char *
inetname(inp)
	struct in_addr *inp;
{
	char *cp;
	static char line[50];
	struct hostent *hp;
	struct netent *np;
	static char domain[MAXHOSTNAMELEN + 1];
	static int first = 1;

	if (first && !nflag) {
		first = 0;
		if (gethostname(domain, MAXHOSTNAMELEN) == 0 &&
		    (cp = index(domain, '.')))
			(void) strcpy(domain, cp + 1);
		else
			domain[0] = 0;
	}
	cp = 0;
	if (!nflag && inp->s_addr != INADDR_ANY) {
		int net = inet_netof(*inp);
		int lna = inet_lnaof(*inp);

		if (lna == INADDR_ANY) {
			np = getnetbyaddr(net, AF_INET);
			if (np)
				cp = np->n_name;
		}
		if (cp == 0) {
			hp = gethostbyaddr((char *)inp, sizeof (*inp), AF_INET);
			if (hp) {
				if ((cp = index(hp->h_name, '.')) &&
				    !strcmp(cp + 1, domain))
					*cp = 0;
				cp = hp->h_name;
			}
		}
	}
	if (inp->s_addr == INADDR_ANY)
		strcpy(line, "*");
	else if (cp)
		strcpy(line, cp);
	else {
		inp->s_addr = ntohl(inp->s_addr);
#define C(x)	((x) & 0xff)
		sprintf(line, "%lu.%lu.%lu.%lu", C(inp->s_addr >> 24),
		    C(inp->s_addr >> 16), C(inp->s_addr >> 8), C(inp->s_addr));
	}
	return (line);
}
