/*-
 * Copyright (c) 1996 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *      BSDI auth.c,v 2.5 1996/11/20 22:16:49 prb Exp
 */
#include <stdio.h>
#include <string.h>
#include <setjmp.h>
#include <sys/wait.h>
#include <sys/param.h>
#include <pwd.h>
#include <signal.h>

#include <syslog.h>

#include <login_cap.h>

int ext_auth = 0;
static login_cap_t *class;
static char *challenge = NULL;
static char *challenge2 = NULL;

char *
start_auth(char *style, char *name, struct passwd *pwd)
{
	static char path[MAXPATHLEN];
	int s;

	ext_auth = 1;	/* authentication is always external */

	if (challenge)
		free(challenge);
	if (challenge2)
		free(challenge2);
	challenge = NULL;
	challenge2 = NULL;

	if (!(class = login_getclass(pwd ? pwd->pw_class : 0)))
		return (NULL);

	if (pwd && pwd->pw_passwd[0] == '\0')
		return (NULL);

	if ((style = login_getstyle(class, style, "auth-ftp")) == NULL)
		return (NULL);

	if (auth_check(name, class->lc_class, style, "challenge", &s) < 0)
		return (NULL);

	if ((s & AUTH_CHALLENGE) == 0)
		return (NULL);

	/*
	 * if the strdup fails the user will not see the challenge.  sigh.
	 */
	if (challenge = auth_value("challenge"))
		challenge2 = strdup(challenge);
	return (challenge2);
}

char *
check_auth(char *name, char *passwd)
{
	char *e;
	int r;

	if (ext_auth == 0)
		return("Login incorrect.");
	ext_auth = 0;

	r = auth_response(name, class->lc_class, class->lc_style, "response",
	    NULL, challenge ? challenge : "", passwd);

	if (challenge)
		free(challenge);
	challenge = NULL;

	if (r <= 0) {
		e = auth_value("errormsg");
		return (e ? e : "Login incorrect.");
	}

	if (auth_approve(class, name, "ftp") <= 0)
		return("Approval failure.");

    	return (NULL);
}
