/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    its contributors.
 * 4. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* YIPS @(#)$Id: pluto.h,v 1.1.1.1.2.1 1998/07/01 01:41:36 sakane Exp $ */

/* IPsec DOI attributes */

#define AUTH_KEY_LIFE_TYPE      1
#define AUTH_KEY_LIFE_DURATION  2
#define ENC_KEY_LIFE_TYPE       3
#define ENC_KEY_LIFE_DURATION   4
#define SA_LIFE_TYPE            5
#define SA_LIFE_DURATION        6
#define REPLAY_PROTECTION       7
#define GROUP_DESCRIPTION       8
#define CA_DISTINGUISHED_NAME   9
#define ENCAPSULATION_MODE      10
#define HMAC_ALGORITHM          11

/* SA Lifetime Type attribute */

#define SA_LIFE_TYPE_SECONDS   1
#define SA_LIFE_TYPE_KBYTES    2

#define SA_LIFE_DURATION_DEFAULT    28800 /* Eight hours */
#define SA_LIFE_DURATION_MINIMUM    600   /* 10 minutes */
#define SA_LIFE_DURATION_MAXIMUM    86400 /* One day */

#define SA_LIFE_DURATION_K_MINIMUM  0

/* Replay protection attribute */

#define REPLAY_PROTECTION_REQUIRED   1
#define REPLAY_PROTECTION_DISALLOWED 2

/* Default group for Phase 2 */

#define DEFAULT_GROUP    1

/* CA Distinguished name attribute */

#define CA_DISTINGUISHED_NAME_DNSSEC   1

/* Encapsulation Mode attribute */

#define ENCAPSULATION_MODE_TUNNEL     1
#define ENCAPSULATION_MODE_TRANSPORT  2

/* HMAC Algorithm attribute */

#define HMAC_ALGORITHM_MD5    1
#define HMAC_ALGORITHM_SHA1   2

/* HMAC */

#define HMAC_IPAD            0x36
#define HMAC_OPAD            0x5C
#define HMAC_BUFSIZE         64

