%{
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include "var.h"
#include "vmbuf.h"
#include "y.tab.h"
#include "cfparse.h"
#include "extern.h"
#include "debug.h"

int lineno = 1;
int yy_first_time = 1;
extern int reparse;

int cfparse(void);
static void cfdebug_print(char *, char *, int);
void yyerror(char *s);
extern void cf_post_config(void);
extern void cf_post_proxy(void);
%}

nl		\n
ws		[ \t]+
digit		[0-9]
letter		[A-Za-z]
hexdigit	[0-9A-Fa-f]
octet		(([01]?{digit}?{digit})|((2([0-4]{digit}))|(25[0-5])))
dot		\.
hyphen		\-
special		[()\.\-+:\|\?\*,]
bcl		\{
ecl		\}
percent		\%
semi		\;
usec		{dot}{digit}{1,6}

comment		\#.*
ccomment	"/*"
bstring		\<[^>]*\>
qstring		\"[^"]*\"
number		{digit}+
hexpair		{hexdigit}{hexdigit}
hex4string	0[xX]{hexpair}{1,4}
hexstring	0[xX]{hexpair}+
hhexstring	{hexpair}+({hyphen}{hexpair}+)+
octetstring	{octet}({dot}{octet})+
	/* ipaddress	({digit}{1,3}{dot}){3}{digit}{1,3} */
ipaddress	{digit}{1,3}({dot}{digit}{1,3}){0,3}
ipaddrmask	{ipaddress}\/{digit}{1,2}
keyword		{letter}{letter}+
name		{letter}(({letter}|{digit}|{hyphen})*({letter}|{digit}))*
hostname	{name}(({dot}{name})+{dot}?)?

%s S_CNF S_LOG S_LST S_PAD S_DEF S_PRX
%s S_RMT S_RMT_PH S_RMT_P S_RMT_T
%s S_FLT S_FLT_DEF S_FLT_A S_FLT_D
%%
%{
	if (yy_first_time) {
		BEGIN S_CNF;
		yy_first_time = 0;
	}
%}

	/* miscellaneous */
<S_CNF>co_pluto		{ YYD_ECHO; return(CO_PLUTO); }
<S_CNF>try_to_send	{ YYD_ECHO; return(TRY_TO_SEND); }
<S_CNF>send_timer	{ YYD_ECHO; return(SEND_TIMER); }

	/* logging */
<S_CNF>log		{ DP("begin logging"); BEGIN S_LOG; return(LOGGING); }
<S_LOG>info		{ YYD_ECHO; yylval.num = 0x00000032; return(NUMBER); }
<S_LOG>notify		{ YYD_ECHO; yylval.num = 0x00000076; return(NUMBER); }
<S_LOG>sched		{ YYD_ECHO; yylval.num = 0x20000000; return(NUMBER); }
<S_LOG>sched2		{ YYD_ECHO; yylval.num = 0x10000000; return(NUMBER); }
<S_LOG>cipher		{ YYD_ECHO; yylval.num = 0x0f000000; return(NUMBER); }
<S_LOG>sa		{ YYD_ECHO; yylval.num = 0x00100000; return(NUMBER); }
<S_LOG>net		{ YYD_ECHO; yylval.num = 0x00020000; return(NUMBER); }
<S_LOG>misc		{ YYD_ECHO; yylval.num = 0x00000100; return(NUMBER); }
<S_LOG>all		{ YYD_ECHO; yylval.num = 0xffffffff; return(NUMBER); }
<S_LOG>{semi}		{ DP("end logging"); BEGIN S_CNF; return(EOS); }

	/* padding */
<S_CNF>padding		{ DP("begin padding"); BEGIN S_PAD; return(PADDING); }
<S_PAD>{bcl}		{ YYD_ECHO; return(BOC); }
<S_PAD>max_length	{ YYD_ECHO; return(MAX_LENGTH); }
<S_PAD>random_length	{ YYD_ECHO; return(RANDOM_LENGTH); }
<S_PAD>check_length	{ YYD_ECHO; return(CHECK_LENGTH); }
<S_PAD>excl_lastone	{ YYD_ECHO; return(EXCL_LASTONE); }
<S_PAD>{ecl}		{ DP("end padding"); BEGIN S_CNF; return(EOC); }

	/* default */
<S_CNF>default		{ DP("begin default"); BEGIN S_DEF; return(DEFAULT); }
<S_DEF>{bcl}		{ YYD_ECHO; return(BOC); }
<S_DEF>lifetime		{ YYD_ECHO; return(LIFETIME); }
<S_DEF>second		{ YYD_ECHO; return(SECOND); }
<S_DEF>KB		{ YYD_ECHO; return(KB); }
<S_DEF>{ecl}		{ DP("end default"); BEGIN S_CNF; return(EOC); }

	/* listen */
<S_CNF>listen		{ DP("begin listen"); BEGIN S_LST; return(LISTEN); }
<S_LST>{bcl}		{ YYD_ECHO; return(BOC); }
<S_LST>isakmp		{ YYD_ECHO; return(X_ISAKMP); }
<S_LST>port		{ YYD_ECHO; return(PORT); }
<S_LST>admin		{ YYD_ECHO; return(X_ADMIN); }
<S_LST>{ecl}		{ DP("end listen"); BEGIN S_CNF; return(EOC); }

	/* proxy */
<S_CNF>proxy		{ DP("begin proxy"); BEGIN S_PRX; return(PROXY); }
<S_PRX>{bcl}		{ YYD_ECHO; return(BOC); }
<S_PRX>mask		{ YYD_ECHO; return(MASK); }
<S_PRX>remote		{ YYD_ECHO; return(REMOTE); }
<S_PRX>default		{ YYD_ECHO; return(DEFAULT); }
<S_PRX>{ecl}		{ DP("end proxy"); BEGIN S_CNF; return(EOC); }

	/* remote */
<S_CNF>remote		{ DP("begin remote"); BEGIN S_RMT; return(REMOTE); }
<S_RMT>{bcl}		{ YYD_ECHO; return(BOC); }
<S_RMT>default		{ YYD_ECHO; return(DEFAULT); }
<S_RMT>port		{ YYD_ECHO; return(PORT); }
<S_RMT>{ecl}		{ DP("end remote"); BEGIN S_CNF; return(EOC); }
	/* phase */
<S_RMT>phase		{ DP("begin phase"); BEGIN S_RMT_PH; return(PHASE); }
<S_RMT_PH>{bcl}		{ YYD_ECHO; return(BOC); }
<S_RMT_PH>exchange_mode	{ YYD_ECHO; return(EXCHANGE_MODE); }
<S_RMT_PH>main		{ YYD_ECHO; return(MAIN); }
<S_RMT_PH>aggressive	{ YYD_ECHO; return(AGGRESSIVE); }
<S_RMT_PH>quick		{ YYD_ECHO; return(QUICK); }
<S_RMT_PH>doi		{ YYD_ECHO; return(DOI); }
<S_RMT_PH>ipsec_doi	{ YYD_ECHO; return(X_IPSEC_DOI); }
<S_RMT_PH>situation	{ YYD_ECHO; return(SITUATION); }
<S_RMT_PH>identity_only	{ YYD_ECHO; return(IDENTITY_ONLY); }
<S_RMT_PH>id_type		{ YYD_ECHO; return(ID_TYPE); }
<S_RMT_PH>ipv4_address	{ YYD_ECHO; return(IPV4_ADDRESS); }
<S_RMT_PH>port		{ YYD_ECHO; return(PORT); }
<S_RMT_PH>none		{ YYD_ECHO; yylval.num = 0; return(NUMBER); }
<S_RMT_PH>FQDN		{ YYD_ECHO; return(FQDN); }
<S_RMT_PH>{ecl}		{ DP("end phase"); BEGIN S_RMT; return(EOC); }
	/* proposal */
<S_RMT_PH>proposal	{ DP("begin proposal"); BEGIN S_RMT_P; return(PROPOSAL); }
<S_RMT_P>{bcl}		{ YYD_ECHO; return(BOC); }
<S_RMT_P>protocol	{ YYD_ECHO; return(PROTOCOL); }
<S_RMT_P>isakmp		{ YYD_ECHO; return(ISAKMP); }
<S_RMT_P>esp		{ YYD_ECHO; return(ESP); }
<S_RMT_P>ah		{ YYD_ECHO; return(AH); }
<S_RMT_P>spi		{ YYD_ECHO; return(SPI); }
<S_RMT_P>transform	{ YYD_ECHO; return(TRANSFORM); }
<S_RMT_P>{ecl}		{ DP("end proposal"); BEGIN S_RMT_PH; return(EOC); }
	/* transform */
<S_RMT_P>oakley		{ DP("begin oakley transform"); BEGIN S_RMT_T; return(OAKLEY); }
<S_RMT_P>des_iv64	{ DP("begin ipsec transform"); BEGIN S_RMT_T; return(DES_IV64); }
<S_RMT_P>des		{ DP("begin ipsec transform"); BEGIN S_RMT_T; return(DES); }
<S_RMT_P>3des		{ DP("begin ipsec transform"); BEGIN S_RMT_T; return(DES3); }
<S_RMT_P>des_iv32	{ DP("begin ipsec transform"); BEGIN S_RMT_T; return(DES_IV32); }
<S_RMT_P>md5		{ DP("begin ipsec transform"); BEGIN S_RMT_T; return(MD5); }
<S_RMT_P>sha1		{ DP("begin ipsec transform"); BEGIN S_RMT_T; return(SHA1); }
<S_RMT_T>{bcl}		{ YYD_ECHO; return(BOC); }
	/* common */
<S_RMT_T>lifetime	{ YYD_ECHO; return(LIFETIME); }
<S_RMT_T>second		{ YYD_ECHO; return(SECOND); }
<S_RMT_T>KB		{ YYD_ECHO; return(KB); }
	/* oakley */
<S_RMT_T>encryption_algorithm	{ YYD_ECHO; return(ENCRYPTION_ALGORITHM); }
<S_RMT_T>des 		{ YYD_ECHO; return(DES); }
<S_RMT_T>3des 		{ YYD_ECHO; return(DES3); }
<S_RMT_T>hash_algorithm	{ YYD_ECHO; return(HASH_ALGORITHM); }
<S_RMT_T>md5		{ YYD_ECHO; return(MD5); }
<S_RMT_T>sha1		{ YYD_ECHO; return(SHA1); }
<S_RMT_T>authentication_method	{ YYD_ECHO; return(AUTHENTICATION_METHOD); }
<S_RMT_T>pre_shared_key	{ YYD_ECHO; return(PRE_SHARED_KEY); }
<S_RMT_T>rsa		{ YYD_ECHO; return(RSA); }
<S_RMT_T>dss		{ YYD_ECHO; return(DSS); }
<S_RMT_T>dh_group	{ YYD_ECHO; return(DH_GROUP); }
<S_RMT_T>modp768	{ YYD_ECHO; return(MODP768); }
<S_RMT_T>modp1024	{ YYD_ECHO; return(MODP1024); }
<S_RMT_T>nonce_size	{ YYD_ECHO; return(NONCE_SIZE); }
	/* ipsec */
<S_RMT_T>encryption_mode	{ YYD_ECHO; return(ENCRYPTION_MODE); }
<S_RMT_T>tunnnel	{ YYD_ECHO; return(TUNNEL); }
<S_RMT_T>transport	{ YYD_ECHO; return(TRANSPORT); }
<S_RMT_T>authentication_algorithm	{ YYD_ECHO; return(AUTHENTICATION_ALGORITHM); }
<S_RMT_T>none		{ YYD_ECHO; return(NONE); }
<S_RMT_T>hmac_md5	{ YYD_ECHO; return(HMAC_MD5); }
<S_RMT_T>hmac_sha1	{ YYD_ECHO; return(HMAC_SHA1); }
<S_RMT_T>{ecl}		{ DP("end transform"); BEGIN S_RMT_P; return(EOC); }

	/* filter */
<S_CNF>filter		{ DP("begin filter"); BEGIN S_FLT; return(FILTER); }
<S_FLT>{bcl}		{ YYD_ECHO; return(BOC); }
<S_FLT>default		{ DP("begin default"); BEGIN S_FLT_DEF; return(DEFAULT); }
<S_FLT_DEF>allow	{ YYD_ECHO; return(ALLOW); }
<S_FLT_DEF>deny		{ YYD_ECHO; return(DENY); }
<S_FLT_DEF>{semi}	{ DP("end default"); BEGIN S_FLT; return(EOS); }
<S_FLT>allow		{ DP("begin allow"); BEGIN S_FLT_A; return(ALLOW); }
<S_FLT_A>{bcl}		{ YYD_ECHO; return(BOC); }
<S_FLT_A>{ecl}		{ DP("end allow"); BEGIN S_FLT; return(EOC); }
<S_FLT>deny		{ DP("begin deny"); BEGIN S_FLT_D; return(DENY); }
<S_FLT_D>{bcl}		{ YYD_ECHO; return(BOC); }
<S_FLT_D>{ecl}		{ DP("end deny"); BEGIN S_FLT; return(EOC); }
<S_FLT>{ecl}		{ DP("end filter"); BEGIN S_CNF; return(EOC); }

	/* ... */
{special}	{ DP("special"); return (char)*yytext; }
{semi}		{ return(EOS); }
{nl}		{ lineno++; }
{comment}	{ DP("comment"); }
{ws}		{ ; }

	/* parameter */
mask		{ YYD_ECHO; return(MASK); }
on		{ YYD_ECHO; yylval.num = 1; return(SWITCH); }
off		{ YYD_ECHO; yylval.num = 0; return(SWITCH); }

{number}	{
			YYD_ECHO;
			yylval.num = atoi(yytext);
			return(NUMBER);
		}

{hex4string}	{
			YYD_ECHO; 
			yylval.num = strtoul(yytext + 2, &yylval.val.v, 16);
			return(NUMBER);
		}

{hexstring}	{
			char *bp, *yp;

			YYD_ECHO; 
			yylval.val.l = (yyleng - 2 ) / 2;
			yylval.val.v = malloc(yylval.val.l);
			bp = yylval.val.v;

			for (yp = yytext + 2; *yp; yp += 2, bp++)
				*bp = (ATOX(yp[0]) << 4) | ATOX(yp[1]);

			return(VNUMBER);
		}

{hostname}	{
			YYD_ECHO;
			yylval.val.t = HOSTNAME;
			yylval.val.l = yyleng;
			yylval.val.v = yytext;
			return(yylval.val.t);
		}

{ipaddress}	{
			YYD_ECHO;
			yylval.val.t = IP_ADDRESS;
			yylval.val.l = yyleng;
			yylval.val.v = yytext;
			return(yylval.val.t);
		}

{ipaddrmask}	{
			YYD_ECHO;
			yylval.val.t = IP_ADDRMASK;
			yylval.val.l = yyleng;
			yylval.val.v = yytext;
			return(yylval.val.t);
		}

{qstring}	{
			YYD_ECHO;
			yylval.val.t = STRING;
			yylval.val.l = yyleng - 2;
			yylval.val.v = yytext + 1;
			return yylval.val.t;
		}

.		{ DP("other"); }

%%

static void
cfdebug_print(w, t, l)
	char *w, *t;
	int l;
{
	printf("<%d>%s [%s] (%d)\n", yy_start, w, t, l);
}

void
yyerror(char *s)
{
	printf("%d: %s at %s\n", lineno, s, yytext);
}

#if !defined(YYDEBUG)
int
cfparse()
#else
main()
#endif /* defined(YYDEBUG) */
{
#if defined(YYDEBUG)
	printf("S_LOG = %d\n", 1 + 2 * S_LOG);
	printf("S_PAD = %d\n", 1 + 2 * S_PAD);
	printf("S_RMT = %d\n", 1 + 2 * S_RMT);
	printf("S_RMT_O = %d\n", 1 + 2 * S_RMT_O);
	printf("S_RMT_I = %d\n", 1 + 2 * S_RMT_I);
	printf("S_FLT = %d\n", 1 + 2 * S_FLT);
	printf("\n");
#else
	if ((yyin = fopen(racoon_conf, "r")) == NULL) {
		plog("cfparse", "%s, fopen (%s)\n", racoon_conf, strerror(errno));
		return(-1);
	}
#endif /* defined(YYDEBUG) */

	if(yyparse()) {
		YIPSDP(PLOG("parse failed.\n"));
		return(-1);
	}

	YIPSDP(PLOG("parse successed.\n"));
	cf_post_config();
	cf_post_proxy();

	return(0);
}

int
re_cfparse()
{
	reparse = 1;
	return(cfparse());
}
