%{
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <errno.h>
#include "var.h"
#include "vmbuf.h"
#include "isakmp.h"
#include "ipsec_doi.h"
#include "oakley.h"
#include "pluto.h"
#include "cfparse.h"
#include "extern.h"
#include "debug.h"

int default_life_type;
u_int32 default_life_duration;
int reparse = 0;

char *racoon_conf = YIPSD_CONF_FILE;
struct isakmp_conf cftab;
struct isakmp_proxy *proxytab;
static struct isakmp_conf *cfp = 0;
static struct isakmp_proxy *prxp = 0;
static int cf_ph;
static struct isakmp_cf_sa *cur_sap;
static struct isakmp_cf_p  *cur_pp;
static struct isakmp_cf_t  *cur_tp;

#if defined(YYDEBUG)
/* isakmp.c */
int sockI, portI;
u_int isakmp_try;
u_int isakmp_timer;
u_int isakmp_nonce_size;
u_int local_secret_size;
u_int isakmp_pad_lword;
int isakmp_randpad;
int isakmp_pad_check;
int isakmp_pad_exclone;
int isakmp_co_pluto;

/* ipsec_doi.c */
int isakmp_port_type;
int isakmp_id_type;

/* pfkey.c */
int sockP;
u_int pfkey_timer;

/* main.c */
u_int debug;

/* admin.c */
int sockA, portA;

#endif /* defined(YYDEBUG) */

static void cf_init(void);
static int cf_alloc_data(int, int);
static u_long cf_inet_addr __P((vchar_t *));
void cf_post_config(void);
void cf_post_proxy(void);

%}

%union {
	unsigned long num;
	vchar_t val;
}

%token EOS BOC EOC

%token CO_PLUTO TRY_TO_SEND SEND_TIMER
%token LOGGING
%token PADDING MAX_LENGTH RANDOM_LENGTH CHECK_LENGTH EXCL_LASTONE
%token DEFAULT LIFETIME SECOND KB
%token LISTEN X_ISAKMP X_ADMIN
%token PROXY MASK

	/* remote */
%token REMOTE /* DEFAULT MASK */ PHASE
%token EXCHANGE_MODE MAIN AGGRESSIVE QUICK
%token DOI X_IPSEC_DOI
%token SITUATION IDENTITY_ONLY
%token ID_TYPE IPV4_ADDRESS PORT FQDN
%token PROPOSAL PROTOCOL ISAKMP ESP AH SPI
%token TRANSFORM OAKLEY DES_IV64 DES DES3 DES_IV32 MD5 SHA1
%token ENCRYPTION_ALGORITHM /* DES DES3 */
%token HASH_ALGORITHM /* MD5 SHA1 */
%token AUTHENTICATION_METHOD PRE_SHARED_KEY RSA DSS
%token DH_GROUP MODP768 MODP1024
%token NONCE_SIZE
%token /* LIFETIME SECOND KB */ 
%token ENCRYPTION_MODE TUNNEL TRANSPORT
%token AUTHENTICATION_ALGORITHM NONE HMAC_MD5 HMAC_SHA1

	/* filter */
%token FILTER /* DEFAULT MASK */
%token ALLOW DENY

%token SWITCH NUMBER VNUMBER STRING HEXSTRING HOSTNAME IP_ADDRESS IP_ADDRMASK

%%

statements:
		/* empty */
	|	statements statement
	;

statement:
		misc_statement
	|	logging_statement
	|	padding_statement
	|	default_statement
	|	listen_statement
	|	proxy_statement
	|	remote_statement
	|	filter_statement
	;

	/* miscellaneous */
misc_statement:
		CO_PLUTO SWITCH EOS
		{
			isakmp_co_pluto = yylval.num;
		}
	|	TRY_TO_SEND NUMBER EOS
		{
			isakmp_try = yylval.num;
		}
	|	SEND_TIMER NUMBER EOS
		{
			isakmp_timer = yylval.num;
		}
	;

	/* logging */
logging_statement:
		LOGGING log_specs EOS
	;

log_specs:
		/* empty */
	|	log_specs NUMBER
		{
			if (!debug_f)
				debug |= yylval.num;
		}
	;

	/* padding */
padding_statement:
	 	PADDING BOC padding_stmts EOC
	|	PADDING padding_stmt
	;

padding_stmts:
		/* empty */
	|	padding_stmts padding_stmt
	;

padding_stmt:
		MAX_LENGTH NUMBER EOS
		{
			isakmp_pad_lword = yylval.num;
		}
	|	RANDOM_LENGTH SWITCH EOS
		{
			isakmp_randpad = yylval.num;
		}
	|	CHECK_LENGTH SWITCH EOS
		{
			isakmp_pad_check = yylval.num;
		}
	|	EXCL_LASTONE SWITCH EOS
		{
			isakmp_pad_exclone = yylval.num;
		}
	;

	/* default */
default_statement:
		DEFAULT BOC default_stmts EOC
	;

default_stmts:
		/* empty */
	|	default_stmts default_stmt
	;

default_stmt:
		LIFETIME NUMBER
		{
			default_life_duration = yylval.num;
		}
		default_life_t EOS
	;

default_life_t:
		SECOND
		{
			default_life_type = IPSECDOI_ATTR_SA_LTYPE_SEC;
		}
	|	KB
		{
			default_life_type = IPSECDOI_ATTR_SA_LTYPE_KB;
		}
	;

	/* listen */
listen_statement:
		LISTEN BOC listen_stmts EOC
	;

listen_stmts:
		/* empty */
	|	listen_stmts listen_stmt
	;

listen_stmt:
		X_ISAKMP IP_ADDRESS
		{
			if (n_soI >= 10) {
				errno = ENOBUFS;
				perror("listen port");
				return(-1);
			}

			if ((myaddr[n_soI] = CALLOC(sizeof(struct sockaddr_in),
			                            struct sockaddr *)) == 0) {
				perror("calloc");
				return(-1);
			}

			myaddr[n_soI]->sa_len = sizeof(struct sockaddr_in);
			myaddr[n_soI]->sa_family = PF_INET;
			if ((((struct sockaddr_in *)(myaddr[n_soI]))->sin_addr.s_addr
				= cf_inet_addr(&yylval.val)) == 0) {
				errno = EINVAL;
				perror("inet_addr");
				return(-1);
			}
		}
		listen_port EOS
	|	X_ADMIN NUMBER EOS
		{
			portA = yylval.num;
		}
	;

listen_port:
		/* nothing */
		{
			((struct sockaddr_in *)myaddr[n_soI])->sin_port = htons(PORT_ISAKMP);
			n_soI++;
		}
	|	PORT NUMBER
		{
			((struct sockaddr_in *)myaddr[n_soI])->sin_port = htons(yylval.num);
			n_soI++;
		}
	;

	/* proxy */
proxy_statement:
		PROXY BOC proxy_stmts EOC
	;

proxy_stmts:
		/* empty */
	|	proxy_stmts proxy_stmt
	;

proxy_stmt:
		IP_ADDRESS
		{
			struct isakmp_proxy *new;

			YIPSDP(PLOG("*** proxy %s ***\n", yylval.val.v));
			if ((new = CALLOC(sizeof(struct isakmp_proxy),
			                  struct isakmp_proxy *)) == 0) {
				perror("calloc");
				return(-1);
			}
			if ((new->src = cf_inet_addr(&yylval.val)) == 0) {
				errno = EINVAL;
				perror("cf_inet_addr");
				return(-1);
			} 

			if (prxp == 0)
				proxytab = new;
			else
				prxp->next = new;

			prxp = new;
		}
		MASK NUMBER
		{
			if (prxp->masks > 32) {
				perror("out of range");
				return(-1);
			}
			prxp->masks = yylval.num;
		}
		IP_ADDRESS
		{
			if ((prxp->dst = cf_inet_addr(&yylval.val)) == 0) {
				errno = EINVAL;
				perror("cf_inet_addr");
				return(-1);
			} 
		}
		MASK NUMBER
		{
			if (prxp->maskd > 32) {
				perror("out of range");
				return(-1);
			}
			prxp->maskd = yylval.num;
		}
		REMOTE proxy_remote_spec EOS
	|	IP_ADDRMASK
		{
			struct isakmp_proxy *new;
			char buf[20], *p;
			int i;

			YIPSDP(PLOG("*** proxy %s ***\n", yylval.val.v));
			if ((new = CALLOC(sizeof(struct isakmp_proxy),
			                  struct isakmp_proxy *)) == 0) {
				perror("calloc");
				return(-1);
			}

			for (i = 0; yylval.val.v[i] != '/'; i++)
				buf[i] = yylval.val.v[i];
			buf[i++] = '\0';
			if ((new->src = inet_addr(buf)) == 0) {
				errno = EINVAL;
				perror("inet_addr");
				return(-1);
			} 

			new->masks = atoi(&yylval.val.v[i]);

			if (prxp == 0)
				proxytab = new;
			else
				prxp->next = new;

			prxp = new;
		}
		IP_ADDRMASK
		{
			char buf[20], *p;
			int i;

			for (i = 0; yylval.val.v[i] != '/'; i++)
				buf[i] = yylval.val.v[i];
			buf[i++] = '\0';
			if ((prxp->dst = inet_addr(buf)) == 0) {
				errno = EINVAL;
				perror("inet_addr");
				return(-1);
			} 

			prxp->maskd = atoi(&yylval.val.v[i]);
		}
		REMOTE proxy_remote_spec EOS
	;

proxy_remote_spec:
		DEFAULT
		{
			prxp->remote = 0;
		}
	|	IP_ADDRESS
		{
			if ((prxp->remote = cf_inet_addr(&yylval.val)) == 0) {
				errno = EINVAL;
				perror("cf_inet_addr");
				return(-1);
			} 
		}
	;

	/* remote */
remote_statement:
		REMOTE remote_spec BOC remote_stmts EOC
	;

remote_spec:
		DEFAULT
		{
			YIPSDP(PLOG("*** remote default ***\n"));
			cf_init();
			cfp = &cftab;
			cfp->remote = 0;
		}
	|	IP_ADDRESS
		{
			struct isakmp_conf *new;

			YIPSDP(PLOG("*** remote %s ***\n", yylval.val.v));
			if ((new = CALLOC(sizeof(struct isakmp_conf),
			                  struct isakmp_conf *)) == 0) {
				perror("calloc");
				return(-1);
			}
			if ((new->remote = CALLOC(sizeof(struct sockaddr_in),
			                  struct sockaddr *)) == 0) {
				perror("calloc");
				return(-1);
			}
			new->remote->sa_len = sizeof(struct sockaddr_in);
			new->remote->sa_family = PF_INET;
			if ((((struct sockaddr_in *)(new->remote))->sin_addr.s_addr
				= cf_inet_addr(&yylval.val)) == 0) {
				errno = EINVAL;
				perror("inet_addr");
				return(-1);
			}

			if (cfp == 0)
				cftab.next = new;
			else
				cfp->next = new;

			cfp = new;
		}
		remote_port_spec
	;

remote_port_spec:
		/* nothing */
		{
			((struct sockaddr_in *)cfp->remote)->sin_port = htons(PORT_ISAKMP);
		}
	|
		PORT NUMBER
		{
			((struct sockaddr_in *)cfp->remote)->sin_port = htons(yylval.num);
		}
	;

remote_stmts:
		/* empty */
	|	remote_stmts remote_stmt
	;

remote_stmt:
		PHASE NUMBER
		{
			switch (yylval.num) {
			case 1:
				cf_ph = 0;
				break;
			case 2:
				cf_ph = 1;
				break;
			default:
				perror("invalid phase number");
				return(-1);
			}

			if ((cfp->ph[cf_ph] = CALLOC(sizeof(struct isakmp_cf_phase),
			                 struct isakmp_cf_phase *)) == 0) {
				perror("calloc");
				return(-1);
			}

			cur_sap = &cfp->ph[cf_ph]->sa;
			cur_pp = cur_sap->p;

			YIPSDP(PLOG("*** phase %d allocated ***\n", yylval.num));
		}
		BOC phase_stmts EOC
	;

phase_stmts:
		/* empty */
	|	phase_stmts phase_stmt
	;

phase_stmt:
		EXCHANGE_MODE exchange_t EOS
	|	DOI doi_t EOS
	|	SITUATION situation_t EOS
	|	id_statement EOS
	|	PROPOSAL NUMBER
		{
			struct isakmp_cf_p **p;

			if (cur_sap->p == 0)
				p = &cur_sap->p;
			else
				p = &cur_pp->next;

			if ((*p = CALLOC(sizeof(struct isakmp_cf_p),
			                 struct isakmp_cf_p *)) == 0) {
				perror("calloc");
				return(-1);
			}

			(*p)->p_no = yylval.num;
			cur_pp = (*p);

			YIPSDP(PLOG("*** proposal %d allocated ***\n", yylval.num));
		}
		protocol_t BOC transform_stmts EOC
	;

exchange_t:
		MAIN
		{
			cfp->ph[cf_ph]->etype = ISAKMP_ETYPE_IDENT;
		}
	|	AGGRESSIVE
		{
			cfp->ph[cf_ph]->etype = ISAKMP_ETYPE_AGG;
		}
	|	QUICK
		{
			cfp->ph[cf_ph]->etype = ISAKMP_ETYPE_QUICK;
		}
	;

doi_t:
		X_IPSEC_DOI
		{
			cur_sap->doi = htonl(IPSEC_DOI);
		}
	;

situation_t:
		IDENTITY_ONLY
		{
			cur_sap->sit = htonl(IPSECDOI_SIT_IDENTITY_ONLY);
		}
	;

id_statement:
		ID_TYPE IPV4_ADDRESS IP_ADDRESS PORT NUMBER
		{
			int tlen = sizeof(struct isakmp_pl_id);
			int idlen = 4;
			caddr_t bp;
			struct in_addr in;

			if ((cfp->ph[cf_ph]->idb = vmalloc(tlen)) == 0) {
				perror("vmalloc");
				return(-1);
			}
			bp = cfp->ph[cf_ph]->idb->v;

			bp[0] = IPSECDOI_ID_IPV4_ADDR;
			if (yylval.num == 0) {
				bp[1] = 0;
				*(u_int16 *)&bp[2] = 0;
			} else {
				bp[1] = htons(17); /* udp */
				*(u_int16 *)&bp[2] = yylval.num;
			}

			inet_aton(yylval.val.v, &in);
			memcpy(bp + idlen, (char *)&in.s_addr, idlen);
		}
	|	ID_TYPE FQDN HOSTNAME
		{
			int tlen = sizeof(struct isakmp_pl_id);
			int idlen = yylval.val.l;
			caddr_t bp;

			if ((cfp->ph[cf_ph]->idb = vmalloc(tlen)) == 0) {
				perror("vmalloc");
				return(-1);
			}
			bp = cfp->ph[cf_ph]->idb->v;

			bp[0] = IPSECDOI_ID_FQDN;
			bp[1] = 0; /* XXX */
			*(u_int16 *)&bp[2] = 0; /* XXX */
		}
	;

protocol_t:
		ISAKMP
		{
			cur_pp->prot_id = IPSECDOI_PROTO_ISAKMP;
		}
	|	ESP
		{
			cur_pp->prot_id = IPSECDOI_PROTO_IPSEC_ESP;
		}
	|	AH
		{
			cur_pp->prot_id = IPSECDOI_PROTO_IPSEC_AH;
		}
	;

transform_stmts:
		/* empty */
	|	transform_stmts transform_stmt
	;

transform_stmt:
		SPI spi_num EOS
	|	TRANSFORM NUMBER
		{
			struct isakmp_cf_t **t;

			if (cur_pp->t == 0)
				t = &cur_pp->t;
			else
				t = &cur_tp->next;

			if ((*t = CALLOC(sizeof(struct isakmp_cf_t),
			                 struct isakmp_cf_t *)) == 0) {
				perror("calloc");
				return(-1);
			}

			(*t)->t_no = yylval.num;
			cur_tp = (*t);
			cur_pp->num_t++;

			YIPSDP(PLOG("*** transform %d allocated ***\n", yylval.num));
		}
		transform_t BOC transform_attributes EOC
	;

spi_num:
		NUMBER
		{
			cur_pp->spi_size = 4;

			if ((cur_pp->spi = vmalloc(cur_pp->spi_size)) == 0) {
				perror("vmalloc");
				return(-1);
			}

			*(u_int32 *)cur_pp->spi->v = htonl(yylval.num);
		}
	|	VNUMBER
		{
			caddr_t spi;

			cur_pp->spi_size = yylval.val.l;

			if ((cur_pp->spi = vmalloc(cur_pp->spi_size)) == 0) {
				perror("vmalloc");
				return(-1);
			}

			memcpy(cur_pp->spi->v, yylval.val.v, cur_pp->spi_size);

			free(yylval.val.v);
		}
	;

transform_t:
		OAKLEY
		{
			cur_tp->t_id = IPSECDOI_KEY_OAKLEY;
		}
	|	DES_IV64
		{
			cur_tp->t_id = IPSECDOI_ESP_DES_IV64;
		}
	|	DES
		{
			cur_tp->t_id = IPSECDOI_ESP_DES;
		}
	|	DES3
		{
			cur_tp->t_id = IPSECDOI_ESP_3DES;
		}
	|	DES_IV32
		{
			cur_tp->t_id = IPSECDOI_ESP_DES_IV32;
		}
	|	MD5
		{
			cur_tp->t_id = IPSECDOI_AH_MD5;
		}
	|	SHA1
		{
			cur_tp->t_id = IPSECDOI_AH_SHA;
		}
	;

transform_attributes:
		/* empty */
	|	transform_attributes transform_attribute
	;

transform_attribute:
		LIFETIME NUMBER life_t EOS
		{
			cf_alloc_data((ISAKMP_GEN_TV |
			    (cf_ph == 1 ?
			        (isakmp_co_pluto ?
			            SA_LIFE_DURATION : IPSECDOI_ATTR_SA_LDUR)
			      : OAKLEY_ATTR_SA_LDUR)),
			    yylval.num);
		}
	|	ENCRYPTION_ALGORITHM cipher_t EOS
	|	HASH_ALGORITHM hash_t EOS
	|	AUTHENTICATION_METHOD auth_method EOS
	|	DH_GROUP dh_group_t EOS
	|	NONCE_SIZE NUMBER EOS
	|	ENCRYPTION_MODE enc_mode_t EOS
	|	AUTHENTICATION_ALGORITHM auth_t EOS
	;

life_t:
		SECOND
		{
			cf_alloc_data((ISAKMP_GEN_TV |
			    (cf_ph == 1 ?
			        (isakmp_co_pluto ?
			            SA_LIFE_TYPE : IPSECDOI_ATTR_SA_LTYPE)
			      : OAKLEY_ATTR_SA_LTYPE)),
			    cf_ph == 1 ?
			        (isakmp_co_pluto ?
			            SA_LIFE_TYPE_SECONDS : IPSECDOI_ATTR_SA_LTYPE_SEC)
			      : OAKLEY_ATTR_SA_LTYPE_SEC);
		}
	|	KB
		{
			PLOG("KB isn't supported.\n");
			return(-1);
		}
	;

cipher_t:
		DES
		{
			if (cf_ph == 1) {
				PLOG("DES isn't supported.\n");
				return(-1);
			}
			cf_alloc_data(ISAKMP_GEN_TV | OAKLEY_ATTR_ENC_ALG,
			              OAKLEY_ATTR_ENC_ALG_DES);
		}
	|	DES3
		{
			if (cf_ph == 1) {
				PLOG("3DES isn't supported.\n");
				return(-1);
			}
			cf_alloc_data(ISAKMP_GEN_TV | OAKLEY_ATTR_ENC_ALG,
			              OAKLEY_ATTR_ENC_ALG_3DES);
		}
	;

hash_t:
		MD5
		{
			if (cf_ph == 1) {
				PLOG("MD5 isn't supported.\n");
				return(-1);
			}
			cf_alloc_data(ISAKMP_GEN_TV | OAKLEY_ATTR_HASH_ALG,
			              OAKLEY_ATTR_HASH_ALG_MD5);
		}
	|	SHA1
		{
			if (cf_ph == 1) {
				PLOG("SHA1 isn't supported.\n");
				return(-1);
			}
			cf_alloc_data(ISAKMP_GEN_TV | OAKLEY_ATTR_HASH_ALG,
			              OAKLEY_ATTR_HASH_ALG_SHA);
		}
	;

auth_method:
		PRE_SHARED_KEY STRING
		{
			if (cf_ph == 1) {
				PLOG("PRE_SHARED_KEY isn't supported.\n");
				return(-1);
			}
			cf_alloc_data(ISAKMP_GEN_TV | OAKLEY_ATTR_AUTH_METHOD,
			              OAKLEY_ATTR_AUTH_METHOD_PSKEY);

			if ((cfp->ph[cf_ph]->pskey
			    = vmalloc(yylval.val.l)) == 0) {
				perror("vmalloc");
				return(-1);
			}
			memcpy(cfp->ph[cf_ph]->pskey->v, yylval.val.v, yylval.val.l);
		}
	|	RSA
		{
			PLOG("RSA isn't supported.\n");
			return(-1);
		}
	|	DSS
		{
			PLOG("DSS isn't supported.\n");
			return(-1);
		}
	;

dh_group_t:
		MODP768
		{
			if (cf_ph == 1) {
				PLOG("MODP768 isn't supported.\n");
				return(-1);
			}
			cf_alloc_data(ISAKMP_GEN_TV | OAKLEY_ATTR_GRP_DESC,
			              OAKLEY_ATTR_GRP_DESC_MODP768);
		}
	|	MODP1024
		{
			if (cf_ph == 1) {
				PLOG("MODP1024 isn't supported.\n");
				return(-1);
			}
			cf_alloc_data(ISAKMP_GEN_TV | OAKLEY_ATTR_GRP_DESC,
			              OAKLEY_ATTR_GRP_DESC_MODP1024);
		}
	;

enc_mode_t:
		TUNNEL
		{
			if (cf_ph == 0) {
				PLOG("TUNNEL isn't supported.\n");
				return(-1);
			}
			cf_alloc_data(ISAKMP_GEN_TV |
			    (isakmp_co_pluto ? ENCAPSULATION_MODE : IPSECDOI_ATTR_ENC_MODE),
			    isakmp_co_pluto ?
			        ENCAPSULATION_MODE_TUNNEL : IPSECDOI_ATTR_ENC_MODE_TUNNEL);
		}
	|	TRANSPORT
		{
			if (cf_ph == 0) {
				PLOG("TRANSPORT isn't supported.\n");
				return(-1);
			}
			cf_alloc_data(ISAKMP_GEN_TV |
			    (isakmp_co_pluto ? ENCAPSULATION_MODE : IPSECDOI_ATTR_ENC_MODE),
			    isakmp_co_pluto ?
			        ENCAPSULATION_MODE_TRANSPORT : IPSECDOI_ATTR_ENC_MODE_TRNS);
		}
	;

auth_t:
		NONE
		{
			if (cf_ph == 0) {
				PLOG("NONE isn't supported.\n");
				return(-1);
			}
		}
	|	HMAC_MD5
		{
			if (cf_ph == 0) {
				PLOG("HMAC_MD5 isn't supported.\n");
				return(-1);
			}
			cf_alloc_data(ISAKMP_GEN_TV | IPSECDOI_ATTR_AUTH,
			              IPSECDOI_ATTR_AUTH_HMAC_MD5);
		}
	|	HMAC_SHA1
		{
			if (cf_ph == 0) {
				PLOG("HMAC_SHA1 isn't supported.\n");
				return(-1);
			}
			cf_alloc_data(ISAKMP_GEN_TV | IPSECDOI_ATTR_AUTH,
			              IPSECDOI_ATTR_AUTH_HMAC_SHA1);
		}
	;

	/* filter */
filter_statement:
		FILTER BOC filter_stmts EOC
	;

filter_stmts:
		/* empty */
	|	filter_stmts filter_stmt
	;

filter_stmt:
		DEFAULT filter_rule EOS
	|	filter_rule BOC address_patterns EOC
	;

filter_rule:
		ALLOW
	|	DENY
	;

address_patterns:
		/* empty */
	|	address_patterns address_pattern
	;

address_pattern:
		IP_ADDRESS EOS
	|	IP_ADDRESS MASK NUMBER EOS
	;

%%

static u_long
cf_inet_addr(v)
	vchar_t *v;
{
	char str[128];

	if (v->l > 127) return(0);
	memset(str, 0, sizeof(str));
	memcpy(str, v->v, v->l);

	return(inet_addr(str));
}

static int
cf_alloc_data(type, lorv)
	int type, lorv;
{
	struct isakmp_data *data;
	int oldlen;

	if (cur_tp->data == 0)
		oldlen = 0;
	else
		oldlen = cur_tp->data->l;

	if (VREALLOC(cur_tp->data, oldlen + sizeof(struct isakmp_data)) == 0) {
		perror("vrealloc");
		return(-1);
	}

	data = (struct isakmp_data *)(cur_tp->data->v + oldlen);
	data->type = htons((u_int16)type);
	data->lorv = htons((u_int16)lorv);

	return(0);
}

void
cf_post_proxy()
{
	struct isakmp_proxy *p;
	struct isakmp_conf *c;

	for (p = proxytab; p; p = p->next) {
		p->cfp = 0; /* i.e. default */
		for (c = cftab.next; c; c = c->next) { /* skip cftab[0] */
			if (p->remote == ((struct sockaddr_in *)c->remote)->sin_addr.s_addr) {
				p->cfp = c;
				break;
			}
		}
	}

	return;
}

void
cf_post_config()
{
	struct isakmp_conf *p;
	struct isakmp_cf_sa *cf_sa;
	struct isakmp_cf_p *cf_p;
	struct isakmp_cf_t *cf_t;
	u_int32 cf_sa_len, cf_p_len, cf_t_len;
	int i;

	for (p = &cftab; p; p = p->next) {
		for (i = 0; i < 2; i++) {
			cf_sa = &p->ph[i]->sa;
			cf_sa_len = 0;

			/* modifing proposal payload */
			for (cf_p = cf_sa->p; cf_p; cf_p = cf_p->next) {
				cf_p_len = 0;

				/* modifing transform payload */
				for (cf_t = cf_p->t; cf_t; cf_t = cf_t->next) {
					cf_t->len = sizeof(struct isakmp_pl_t)
					    + (cf_t->data ? cf_t->data->l : 0);
					cf_p_len += cf_t->len;
				}
				cf_p->len = sizeof(struct isakmp_pl_p) + cf_p->spi_size
				          + cf_p_len;
				cf_sa_len += cf_p->len;
			}
			cf_sa->len = sizeof(struct isakmp_pl_sa) + cf_sa_len;
		}
	}

	return;
}

void
cf_init()
{
	memset((caddr_t)&cftab, 0, sizeof(cftab));

	return;
}

