#!/usr/bin/perl
#
# PingMan: a perl/Tk Based Metwork Monitor
#
# Copyright (C) 2000, 2001 PingMen. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the all of image
#    files included this package.
# 2. Redistributions of binary form must reproduce the all of image
#    files included this package.
# 3. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 4. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 5. Neither the name of the project nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# PingMan!! history:
#            for N+I 2001 tokyo
#    01 by Noriyuki SHIGECHIKA <nazo@wide.ad.jp>
#            for N+I 2000 tokyo
#    Millennium Edition by Noriyuki SHIGECHIKA <nazo@wide.ad.jp>
#            for N+I 1999 tokyo
#    Superior Edition by Noriyuki SHIGECHIKA <nazo@wide.ad.jp>
#        Photos by Tatsuya Jinmei<jinmei@kame.net>
#        Faces by Atsushi Hagiwara <hagidon@tokugawa.org> and
# 		  Yasuo Tsuchimoto <tsuchy@sfc.wide.ad.jp>
#    Deluxe Edition by Noriyuki SHIGECHIKA <nazo@wide.ad.jp>
#    Pro Edition by Atsushi Hagiwara <hagidon@tokugawa.org>
#    Original PingMan(Light Edition) by
#                   Youki Kadobayashi <youki@center.osaka-u.ac.jp>
$message_from_pingman = <<EOM;
Get the power of PingMan!!


PingMan is developed by
	youki
	hagidon
	nazo
	tsuchy
	jinmei
EOM

### requirements for your perl environment
require 5.003;
use Time::HiRes;
use Net::Ping;
#if ($^O ne 'MSWin32') {
#    use Net::Ping6;
#}
use Tk;
use Tk::Balloon;
use Tk::Dialog;
use Tk::FileSelect;
use Tk::Font;
use Tk::Frame;
use Tk::Table;

### files
$upimage = 'hagidons.gif';
$downimage = 'tsuchys.gif';
$the_pingman = 'hagidonl.gif';
$LOGFILE = './pingman.log';

### global variables
$pingman = 'PingMan!!';
$version = 'ZeroOne(beta-test)';
$round = 0;
$stop = 0;
$reset = 0;
#color		down <- -> up <- -> normal
@colors = ('red', 'orange', 'yellow', 'green', 'blue', 'black');
@normalcolors = ($colors[3], $colors[4]);
$bgcolor = $colors[5];
$ent_fontsize = $pingfontsize = $deffontsize = ($^O eq 'MSWin32')?'10':'14';
@pingfontfamily = ('Times', 'Westminister', 'Helvetica', 'Courier');
$interval = 1_000_000;	#usec
$pingstring = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ23456789';
#              012345678901234567890123456789012345678901234567890123456789
# 0 and 1 are special character
@pingstring = split('', $pingstring);
$rttstring = '000/000/000(000%)';
%rightx = ('-side', 'right', '-fill', 'x');
%leftx = ('-side', 'left', '-fill', 'x');
$columns = 1;

$| = 1;

### sub routines
sub read_config {
    local($config_file) = @_;
    undef %names;
    undef @nodes;
    open(CONF, $config_file) || die "$config: $!\n";
    while (<CONF>) {
        next if /^#/;
        local($addr, $name, $comments) = split;
        push(@nodes, $addr);
        $names{$addr} = $name;
    }
    to_log("loaded: $config\n") if ($log);
}
sub load_config {
    local($config_file) = @_;
    if (-r $config_file) {
        &read_config($config_file);
        to_console(sprintf "%d nodes are loaded from %s.\n(%s)\n",
            $#nodes + 1, $config_file, join(', ', values %names));
    }
}
sub regexp_config{
    local($grepkey) = @_;
    local($tmpnode, %tmpnames, @tmpnodes);
    if (!$grepkey) {
        local($message) = sprintf
	    "***Warning***\nSearch key is null!\n";
        $console->insert('end', "$message", 'bold');
        $console->yviewMoveto(1);
	undef $regexp;
    } elsif (defined @nodes) {
        foreach $tmpnode (@nodes) {
       	    next unless ($tmpnode =~ /$grepkey/ or
		$names{$tmpnode} =~ /$grepkey/);
  	    push(@tmpnodes, $tmpnode);
	    $tmpnames{$tmpnode} = $names{$tmpnode};
        }
        undef @nodes;
        undef %names;
        @nodes = @tmpnodes;
        %names = %tmpnames;
        to_console(sprintf "key %s: %d entries are matched.\n(%s)\n",
            $grepkey, $#nodes + 1, join(', ', values %names));
    } else {
        to_console("***Warning***\nYou must load config file first!\n");
	undef $regexp;
    }
}
sub pingwin {
    if (! Exists ($pingwin) and defined @nodes) {
        to_console("Hello PingMan!!\n");
        $pingwin = $mw->Toplevel();
	$pingwin->title("$pingman: $file");
	$pingwin->geometry("-0-0");

	($canvas_w, $canvas_h) = pingwin_size();
	$pingc = $pingwin->Canvas(-height=>$canvas_h, -width=>$canvas_w,
	    -background=>$bgcolor);
	$pingc->pack(-side=>'bottom', -fill=>'both');

	$pingb = $pingwin->Balloon();
	$pingwin->OnDestroy(sub{$pingb->destroy;});

        $Bpstatus = $pingwin->Frame->pack(%rightx);
        $Bpstatusc = $Bpstatus->Canvas(-width=>30, -height=>40);    #32x47
        $pstatus = $Bpstatusc->create('image', 0, 0, -anchor=>'nw',
	    -image=>'status_down');
	$Bpstatusc->pack();

	$Bclose = $pingwin->Frame->pack(%rightx);
	$Bclose->Button(-text=>'close',
	    -command=>sub{to_console("Goodbye PingMan!!\n");$pingwin->destroy},
	    -bd=>0)->pack();

	$Bpstatusc->pack();
	$Bstart = $pingwin->Frame->pack(%leftx);
	$Bstart->Button(-text=>'start', -command=>sub{$stop=0;
            $Bpstatusc->itemconfigure($pstatus, -image=>'status_up');
            &ping_loop;},
	    -bd=>0)->pack();

	$Bstop = $pingwin->Frame->pack(%leftx);
	$Bstop->Button(-text=>'stop', -command=>sub{$stop=1;
            $Bpstatusc->itemconfigure($pstatus, -image=>'status_down');
     	    }, -bd=>0)->pack();

	$Breset = $pingwin->Frame->pack(%leftx);
	$Breset->Button(-text=>'reset', -command=>sub{$reset=1;
	    $Broundc->itemconfigure($showround, -text=>sprintf "%8d", $round);
	    }, -bd=>0)->pack();

        $Bround = $pingwin->Frame->pack(%leftx);
        $Broundc = $Bround->Canvas(-width=>$char_w * 8, -height=>$line_h);
        $showround = $Broundc->create('text', 0, 0, -anchor=>'nw',
	    -text=>sprintf "%8d", $round);
	$Broundc->pack();

	&write_label;

    } elsif (Exists ($pingwin)) {
	to_console("PingMan is busy!! Close PingMan and Try Again.\n");
    } else {
        to_console("***Warning***\nYou must load config file first!\n");
    }
}
sub pingwin_size {
    $myfont = $mw->Font(-size=>$pingfontsize, -family=>$pingfontfamily[3]);
    undef $label_w;
    local($canvas_w, $canvas_h);
    foreach $addr (@nodes) {
        $label_w = $myfont->measure($names{$addr})
            if $label_w  < $myfont->measure($names{$addr});
    }
    $status_w = length $pingstring;
    $stat_w = $myfont->measure($rttstring);
    $char_w = $myfont->measure('x');

    $line_w = $label_w + $stat_w + $status_w;
    $line_h = $myfont->ascent;
    $canvas_w = sprintf "%d", $line_w + $char_w * 1;
    $canvas_w = $canvas_w * $columns; 
    $lines = ($#nodes + 1);
    $lines = ($lines % $columns) ? sprintf "%d", ($lines / $columns) + 1 : 
        sprintf "%d", ($lines / $columns); 
    $canvas_h = sprintf "%d", $line_h * ($lines + 1);
    ($canvas_w, $canvas_h);
}
sub write_label {
    local($i) = 0;
    $xmargin = $char_w * 0.5;
    $ymargin = $line_h;
    $x = $xmargin;
    $x_dash = $x + $label_w + $char_w * 0;
    $x_dashdash = $x_dash + $stat_w + $char_w * 0;
    foreach $addr (@nodes) {
	if ($i == $lines) {
	    $i = 0;
            $xmargin += $line_w + $char_w * 1;
            $x = $xmargin;
            $x_dash = $x + $label_w + $char_w * 0;
            $x_dashdash = $x_dash + $stat_w + $char_w * 0;

	    $pingc->create('line', $xmargin - $char_w * 0.5, 0,
		$xmargin - $char_w * 0.5, $canvas_h, -fill=>'gray');
	}
	$y = $ymargin + ($i * $line_h);
        $label_names{$addr} = $pingc->create('text', $x, $y, -anchor=>'w',
	    -text=>$names{$addr}, -font=>$myfont, -fill=>$normalcolors[0]);

	$rtts{$addr} = $rttstring;
	$label_rtts{$addr} = $pingc->create('text', $x_dash, $y, -anchor=>'w',
	    -text=>$rtts{$addr}, -font=>$myfont, -fill=>$normalcolors[0]);

	$pinghists{$addr} = $pingstring;
	$x_dashdashtmp = $x_dashdash;
        foreach $histnum (@pingstring) {
            local($addrtmp) = $addr . '-' . $histnum;
	    $line{$addrtmp} = $pingc->create('line',
                $x_dashdashtmp, $y-$line_h/4, $x_dashdashtmp, $y+$line_h/3,
	        -fill => 'gray');
            $x_dashdashtmp++;
	}

        $up{$addr} = 3;
	$balloons{$label_names{$addr}} = $names{$addr} . ': ' .  $addr;
	$i++;
    }
	$pingb->attach($pingc, -msg=> {%balloons},
	    -balloonposition=>'mouse');
}
sub ping_loop {
    while (1) {
	$actualrttsum=0;
	$pingwin->waitVariable(\$stop), redo if $stop;
	$round = 0, undef %success, undef %minrtts, undef %maxrtts,
	    undef %avertts, undef %rounds, $reset = 0 if $reset;
	++$round;
	$Broundc->itemconfigure($showround, -text=>sprintf "%8d", $round);

        foreach $addr (@nodes) {
	    local($targetaddr, $ping, $rtt) = split(',',do_ping($addr));
	    $actualrttsum += $rtt * 1_000;
	    if ($ping) {
		if ($up{$addr} == 0) {
                    to_console(sprintf "%s %-15s %-30s up\n",
			scalar localtime(), $addr, $names{$addr});
		    to_log(sprintf "%s %-15s %-30s up\n",
			scalar localtime(), $addr, $names{$addr}) if ($log);
		    undef %down;
  	            $pingc->itemconfigure($label_rtts{$addr},
			-fill=>$normalcolors[0]);
		}
		$up{$addr} = 3;

		local($foo, @histtmp) = split('',$pinghists{$addr});
		push(@histtmp, '1');
		$pinghists{$addr} = join('',@histtmp);

		$up{$addr} = 3 if ($up{$addr} > 3);
		$color = ($round % 2 ? $normalcolors[0] : $normalcolors[1]);
		$pingc->itemconfigure($label_names{$addr}, -fill=>$color);

		$pingc->itemconfigure($circle{$addr}, -fill=>$color);

		$Bpstatusc->itemconfigure($pstatus, -image=>'status_up');
	    } elsif ($ping == 0) {
		if ($up{$addr} == 1) {
                    to_console(sprintf "%s %-15s %-30s down\n",
			scalar localtime(), $addr, $names{$addr});
		    to_log(sprintf "%s %-15s %-30s down\n",
			scalar localtime(), $addr, $names{$addr}) if ($log);
		    ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday,
			$isdst) = localtime();
		    $down{$addr} = sprintf "%02d/%02d %02d:%02d:%02d",
			++$mon, $mday, $hour, $min, $sec;
		}
		--$up{$addr};

		local($foo, @histtmp) = split('',$pinghists{$addr});
		push(@histtmp, '0');
		$pinghists{$addr} = join('',@histtmp);

		$up{$addr} = 3 if ($up{$addr} > 3);
		$up{$addr} = 0 if ($up{$addr} < 0);
		$pingc->itemconfigure($label_names{$addr},
		    -fill=>$colors[$up{$addr}]);
		$Bpstatusc->itemconfigure($pstatus, -image=>'status_down');
            }

	    @pinghist = split('',$pinghists{$addr});
	    local($i) = 0;
            foreach $histnum (@pingstring) {
                local($addrtmp) = $addr . '-' . $histnum;
		if ($pinghist[$i] eq '1') {
		    $color = $colors[3];
		} elsif ($pinghist[$i] eq '0') {
		    $color = $colors[0];
		} else {
		    $color = gray;
		}
	        $pingc->itemconfigure($line{$addrtmp}, -fill=>$color);
		$i++;
	    }
	    $pingc->itemconfigure($label_rtts{$addr},
	        -text=>stat_proc($targetaddr, $ping, $rtt));
  	    $pingc->itemconfigure($label_rtts{$addr}, -fill=>$color)
                if (defined $down{$addr});

	    $pingwin->update();
	    Tk::DoOneEvent(Tk::DONT_WAIT);
	}
	    Time::HiRes::usleep($interval - $actualrttsum)
	        if ($interval and $interval > $actualrttsum);
    }
}
sub stat_proc {
    local($targetaddr, $ping, $rtt) = @_;
    local($fmin, $fmax, $fave, $fper, $tmpavertt);
    if (!defined $down{$addr}) {
        $rounds{$targetaddr} += 1;
        if ($ping) {
            $minrtts{$targetaddr} = $rtt
   	        if ($rtt < $minrtts{$targetaddr} or
		!defined $minrtts{$targetaddr});
            $fmin = format_string($minrtts{$targetaddr});

            $maxrtts{$targetaddr} = $rtt
                if ($rtt > $maxrtts{$targetaddr} or
		!defined $maxrtts{$targetaddr});

            $fmax = format_string($maxrtts{$targetaddr});

            if (defined $success{$targetaddr}) {
                $fave = $avertts{$targetaddr} =
                    ($avertts{$targetaddr} * $success{$targetaddr} + $rtt)
                    / ($success{$targetaddr} + 1);
                $success{$targetaddr}++;
            } else {
                $fave = $avertts{$targetaddr} = $rtt; 
                $success{$targetaddr} = 1;
            }
            $fave = format_string($fave);
        } else {
	    if (defined $minrtts{$targetaddr}) {
	        $fmin = format_string($minrtts{$targetaddr});
            } else {
                $fmin = 'min';
            }
            if (defined $maxrtts{$targetaddr}) {
                $fmax = format_string($maxrtts{$targetaddr});
            } else {
                $fmax = 'max';
            }
            if (defined $avertts{$targetaddr}) {
                $fave = format_string($avertts{$targetaddr});
            } else {
                $fave = 'ave';
            }
        }
        $fper = 100 * $success{$targetaddr} / $rounds{$targetaddr};
        sprintf "%s/%s/%s(%3d%)", $fmin, $fmax, $fave, $fper;
    } else { 
        sprintf "%s", $down{$targetaddr};
    }
}
sub format_string {
    local($value) = @_;
    if ($value < 1) {
        sprintf ' <1';
    } elsif ($value > 1000) {
        sprintf '>1k';
    } else {
        sprintf "%3d", $value;
    }
}
sub do_ping (addr_or_fqdn) {
    local($targetaddr) = @_;
    local($ping, $before, $after, $rtt = 0);
    local(@stat) = (down, up);

#    $p = ($targetaddr =~ /^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/) ?
#        Net::Ping->new("icmp", 1) : Net::Ping6->new("icmp", 1);
    $p = $p = Net::Ping->new("icmp", 1);

    $before = Time::HiRes::time;
    $ping = $p->ping($targetaddr);
    $after = Time::HiRes::time if $ping;

    $rtt = ($after-$before)*1_000 if $ping;

    sprintf "%s,%d,%f", $addr, $ping, $rtt;
}
sub to_console {
    local($message) = @_;
    $console->insert('end', "$message", 'bold');
    $console->yviewMoveto(1);
}
sub to_log {
    local($message) = @_;
    open(LOG, ">>$LOGFILE") or die "$LOGFILE: $!\n";
    printf LOG "$message";
    close(LOG)
}
sub quit {
    print "$pingman $version finished at " . localtime() . "\n";
    to_log("$pingman $version finished at " . localtime() . "\n") if $log;
    exit;
}

### main routine
$mw = MainWindow->new;
$mw->geometry("+0+0");
$mw->title("$pingman $version");
$mw->iconname("$pingman");
$mw->iconmask();
$mw->iconmask("info");
$mw->client();
$mw->client("$pingman");

$mw->Photo('status_up', -file => $upimage);
$mw->Photo('status_down', -file => $downimage);
$mw->Photo('pingman', -file => $the_pingman);

$console = $mw->Scrolled('Text', -scrollbars=>'e',
    -wrap=> 'word')->pack(-side=>'bottom', -fill=>'both');

$Bstatus = $mw->Frame->pack(%rightx);
$Bstatusc = $Bstatus->Canvas(-width=>30, -height=>40);	#32x47
$status = $Bstatusc->create('image', 0, 0, -anchor=>'nw', -image=>'status_up');
$Bstatusc->pack();

$Bgrep = $mw->Frame->pack(%leftx);
$Bgrep->Label(-text=>'regexp:')->pack(-side=>'left');
$Bgrepi = $Bgrep->Entry(-textvariable=>\$ent_regexp,
    -width=>8)->pack(-side=>'right');
$Bgrepi->bind('<Return>', sub{$regexp = $ent_regexp; &regexp_config($regexp)});

$Bfont = $mw->Frame->pack(%leftx);
$Bfont->Label(-text=>'fontsize:')->pack(-side=>'left');
$fontopt = $Bfont->Optionmenu(-options => ['def', '6', '8', '10', '12', '14',
    '16', '18', '20', '22', '24', '26', '28'],
    -variable=> \$ent_fontsize, -command=>sub{
    $ent_fontsize = $deffontsize if $ent_fontsize eq 'def';
    $pingfontsize = $ent_fontsize,
    to_console("font size is changed to $pingfontsize.\n")
    if ($pingfontsize != $ent_fontsize);}, -bd=>0)->pack(-side=>'right');

$Bcol = $mw->Frame->pack(%leftx);
$Bcol ->Label(-text=>'col:')->pack(-side=>'left');
$colopt = $Bcol->Optionmenu(-options => ['1', '2', '3', '4'],
    -variable=> \$ent_columns, -command=>sub{
        $columns = $ent_columns,
	to_console("columns is changed to $columns.\n")
        if ($ent_columns != $columns);
    }, -bd=>0)->pack(-side=>'right');

$Bconf = $mw->Frame->pack(%leftx);
$Bconf->Button(-text=>'conf', -bd=>0, -command=>sub{$file=$fd->Show;
    &load_config($file)})->pack();
$fd = $mw->FileSelect(-title=>'select a config file', -filter=>'*.conf');

$Bpingman = $mw->Frame->pack(%leftx);
$Bpingman->Button(-text=>'pingman', -command=> \&pingwin, -bd=>0)->pack();

$Babout = $mw->Frame->pack(%leftx);
$Babout->Button(-text=>'about Pingman', -bd=>0,
    -command=>sub{$about_pingman->Show;})->pack();
$about_pingman = $mw->Dialog(-title=>'about PingMan!!',
    -text=>"$message_from_pingman", -width=>25, -image=>'pingman'),

$Bquit = $mw->Frame->pack(%leftx);
$Bquit->Button(-text=>'quit', -command=> \&quit, -bd=>0)->pack();

if ($log and -r $LOGFILE and !-w $LOGFILE) {
   to_console("$LOGFILE is readonly mode.\nlog mode is turned off.\n");
   $log = 0;
}
MainLoop;

