/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */


#include <PP_Types.h>

#pragma once

#include "PrefsPaneIDs.h"

class CMenuTable;
class CPrefsMediator;


//======================================
class CPrefsDialog
//======================================
:	public LCommander
,	public LListener
,	public LBroadcaster
{

	public:

	enum
	{
		cmd_Prefs								= 12000
,		ePrefsTextTraits						= 12000
,		ePrefsTableStrings						= 12000
	};

	enum
	{
		eOKButtonID = 8,
		eCancelButtonID = 2,
		eHelpButtonID,
		eMainCaptionID,
		eSubCaptionID,
		ePanelView,
		eTableView
	};

	enum Expand_T	// note: Appearance is always expanded
	{
		eExpandAppearance = PrefPaneID::eAppearance_Main
		, eExpandBrowser = PrefPaneID::eBrowser_Main
		// Leave this in for Navigator only build to get email addr pref
		, eExpandMailNews = PrefPaneID::eMailNews_Main
		#ifdef EDITOR
		, eExpandEditor = PrefPaneID::eEditor_Main
		#endif
		#ifdef MOZ_MAIL_NEWS
		, eExpandOffline = PrefPaneID::eOffline_Main
		#endif
		, eExpandAdvanced = PrefPaneID::eAdvanced_Main
		, eExpandAll = PrefPaneID::eNoPaneSpecified
	};

	enum Selection_T
	{
		eIgnore,
		eEmailAddress,
		ePOPUserID,
		eSMTPHost,
		ePOPHost,
		eNewsHost
	};

	enum
	{
		ePrefsChanged = 'prfx'
	};

		static	void	RegisterViewClasses();
		static	void	EditPrefs(	Expand_T expand = eExpandAppearance,
									PrefPaneID::ID pane = PrefPaneID::eNoPaneSpecified,
									Selection_T selection = eIgnore);
		static	void	LoadICDependent();
			// This class must know which managers are IC dependent. Ugh.
//		static	void	AddPrefsListener(LListener *newPrefsListener);
							// The listener will receive the ePrefsChanged
							// message and the ioParam will be long * to
							// the value of the pref enum.
							// Note this notification is only for changes
							// generated by using the prefs UI. If there is
							// a possibility that the pref can be change
							// in another way, then a pref call back should
							// be registered with the xp prefs.

		virtual void		FindCommandStatus(CommandT inCommand,
							Boolean &outEnabled, Boolean &outUsesMark,
							Char16 &outMark, Str255 outName);

		virtual void	ListenToMessage(
							MessageT		inMessage,
							void			*ioParam);

		virtual	Boolean	AllowTargetSwitch(LCommander *inNewTarget);
	private:
						CPrefsDialog();
		virtual			~CPrefsDialog();

				void	DoPrefsWindow(	Expand_T expand = eExpandAppearance,
										PrefPaneID::ID pane = PrefPaneID::eNoPaneSpecified,
										Selection_T selection = eIgnore);

		CPrefsMediator 	*GetMediator(ResIDT paneID);
		Boolean				CheckMediator(ResIDT paneID) const;
		CPrefsMediator*	FindMediator( ResIDT paneID );
		
		static	void	CheckForVCard();
				void	Finished();

		static	CPrefsDialog			*sThis;

		static PrefPaneID::ID			sLastPrefPane;

		LWindow							*mWindow;
		CPrefsMediator					*mCurrentMediator;
		CMenuTable						*mTable;
		LView							*mPanel;
		Boolean							mNeedToCheckForVCard;

		LArray							mPanels;
}; // class CPrefsDialog

