/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */

// 
//	CProgressCaption.cp
// 

#include "CProgressCaption.h"

#ifdef PowerPlant_PCH
#include PowerPlant_PCH
#endif

#include <URegions.h>
#include "UGraphicGizmos.h"

#pragma mark public

enum {eNoColorSet = -1};

// 
//	
// 

CProgressCaption::CProgressCaption(LStream* inStream)
	:	CProgressBar(inStream)
{
	inStream->ReadPString(mText);
//	*inStream >> mText;
	*inStream >> mBoundedTraitsID;
	*inStream >> mIndefiniteTraitsID;
	*inStream >> mHiddenTraitsID;
	*inStream >> mEraseColor;
	SetHidden();
}

// 
//	
// 

CProgressCaption::~CProgressCaption()
{
}

// 
//	
// 

StringPtr CProgressCaption::GetDescriptor(
	Str255	outDescriptor) const
{
	return LString::CopyPStr(mText, outDescriptor);
}


// 
//	
// 

void CProgressCaption::SetDescriptor(ConstStringPtr	inDescriptor)
{
	if (inDescriptor == NULL)
		mText = "\p";
	else
		mText = inDescriptor;
	
	if (FocusExposed())
		Draw(NULL);
}

// 
//	
// 

void CProgressCaption::SetDescriptor(const char* inCDescriptor)
{
	if (inCDescriptor == NULL)
		mText = "\p";
	else
		mText = inCDescriptor;

	if (FocusExposed())
		Draw(NULL);
}

// 
//	
// 

void CProgressCaption::Draw(RgnHandle inSuperDrawRgnH)
{
	Rect theFrame;
	if ((mVisible == triState_On) && CalcPortFrameRect(theFrame) &&
			((inSuperDrawRgnH == nil) || RectInRgn(&theFrame, inSuperDrawRgnH)) && FocusDraw())
		{
		PortToLocalPoint(topLeft(theFrame));	// Get Frame in Local coords
		PortToLocalPoint(botRight(theFrame));

		if (ExecuteAttachments(msg_DrawOrPrint, &theFrame))
			{
			Boolean bDidDraw = false;

			StColorPenState thePenSaver;
			StColorPenState::Normalize();
			
			// Fail safe offscreen drawing
			StValueChanger<EDebugAction> okayToFail(gDebugThrow, debugAction_Nothing);
			try
				{			
				LGWorld theOffWorld(theFrame, 0, useTempMem);

				if (!theOffWorld.BeginDrawing())
					throw memFullErr;
					
				DrawSelf();
					
				theOffWorld.EndDrawing();
				theOffWorld.CopyImage(GetMacPort(), theFrame, srcCopy);
				bDidDraw = true;
				}
			catch (...)
				{
				// 	& draw onscreen
				}
				
			if (!bDidDraw)
				DrawSelf();
			}
		}
}

// 
//	
// 

void CProgressCaption::GetActiveColors(RGBColor& bodyColor, RGBColor& barColor, RGBColor& frameColor) const
{
	CProgressBar::GetActiveColors(bodyColor, barColor, frameColor);
	barColor.red = 0x8888;
	barColor.green = 0x8888;
	barColor.blue = 0xFFFF;
}

// 
//	
// 

void CProgressCaption::DrawSelf(void)
{
	Rect theFrame;
	CalcLocalFrameRect(theFrame);

	ResIDT theTraitsID;
	switch (GetValue())
	{
		case eIndefinite:
			theTraitsID = mIndefiniteTraitsID;
			break;
		case eBarHidden:
			theTraitsID = mHiddenTraitsID;
			break;
		default:
			theTraitsID = mBoundedTraitsID;
			break;
	}

	Int16 just = UTextTraits::SetPortTextTraits(theTraitsID);

	if (GetValue() == eBarHidden)
	{
		RGBColor theTextColor;
		::GetForeColor(&theTextColor);
		
		if (mEraseColor != eNoColorSet)
			::PmBackColor(mEraseColor);
		else
			ApplyForeAndBackColors();

		::EraseRect(&theFrame);
		::RGBForeColor(&theTextColor);
	}
	else
	{
		CProgressBar::DrawSelf();
	}
	theFrame.right -= 3;
	theFrame.left += 3;
	theFrame.top -= 1;
	UGraphicGizmos::PlaceStringInRect(mText, theFrame, just);
}

