/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $Id: key.h,v 1.1.1.1.14.1 1998/12/03 06:10:59 itojun Exp $ */

#ifndef _NETKEY_KEY_H_
#define _NETKEY_KEY_H_

#ifdef __NetBSD__
# ifdef _KERNEL
#  define KERNEL
# endif
#endif

#if defined(KERNEL)

extern struct key_cb key_cb;

struct secpc;
struct secasb;
struct secas;
struct secindex;
struct ipsecpolicy;
extern struct secpc *key_allocsp __P((struct secindex *));
extern struct secasb *key_allocsab __P((struct secindex *));
extern struct secas *key_allocsabyspi __P((u_int32_t, caddr_t, caddr_t,
						u_int, u_int));
extern void key_freesp __P((struct secpc *));
extern void key_freeso __P((struct socket *));
extern void key_freesab __P((struct secasb *));
extern void key_freesa __P((struct secas *));
struct secreg;
extern void key_freereg __P((struct socket *));
extern int key_checksab __P((struct secasb *, struct ipsecpolicy *,
			struct secindex *, int *));

struct sadb_msg;
extern void key_init __P((void));
struct secexpire;
extern int key_expire __P((struct secexpire *));
extern void key_kill __P((int));
extern void key_srandom __P((void));
extern int key_parse __P((struct sadb_msg **, struct socket *, int *));
extern int key_checktunnelsanity __P((struct secas *, caddr_t, caddr_t, int));
extern void key_sa_recordxfer __P((struct secas *, struct mbuf *));
extern void key_sab_routechange __P((struct sockaddr *));

#if defined(__bsdi__) || defined(__NetBSD__)
extern int key_sysctl __P((int *, u_int, void *, size_t *, void *, size_t));
#endif

#else
extern int key_parse __P((struct sadb_msg **, int));
#endif /* defined(KERNEL) */

#endif /* _NETKEY_KEY_H_ */

