/*
 * Copyright (C) 1998
 *	Sony Computer Science Laboratories Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY SONY CSL AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL SONY CSL OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: altq_flowvalve.h,v 1.1.2.1 1999/01/20 17:53:48 itojun Exp $
 */

#ifndef _NETINET_ALTQ_FLOWVALVE_H_
#define _NETINET_ALTQ_FLOWVALVE_H_

#if defined(KERNEL) || defined(_KERNEL)

#define FV_HASHSIZE	32		/* flowlist hash table size */
					/* (must be power of two) */

/* fv_flow structure to define a unique address pair */
struct fv_flow {
	int flow_af;		/* address family */
	union {
		struct {
			struct in_addr ip_src;
			struct in_addr ip_dst;
		} _ip;
#ifdef INET6
		struct {
			struct in6_addr ip6_src;
			struct in6_addr ip6_dst;
		} _ip6;
#endif
	} flow_un;
};

#define flow_ip		flow_un._ip
#define flow_ip6	flow_un._ip6

/* flowvalve entry */
struct fve {
	TAILQ_ENTRY(fve) fve_lru;	/* for LRU list */
	LIST_ENTRY(fve) fve_hash;	/* for hash chain */

	struct fv_flow fve_flow;	/* unique address pair */

	int32_t	fve_sadi;		/* scaled average drop interval */
	int	fve_interval;		/* drop interval count */
	struct timeval	fve_lastdrop;	/* timestamp of the last drop */

	int	fve_predrop;		/* predrop counter for statistics */
};

/* flowvalve structure */
struct flowvalve {
	LIST_ENTRY(flowvalve) fv_next;

	int fv_flows;		/* number of valid flows in the flowlist */
	struct callout_handle	fv_callout;	/* handle for timeouts */
	int fv_armed;		/* 1 when callout is set */

	TAILQ_HEAD(fv_flowhead, fve) fv_flowlist;		/* LRU list */
	LIST_HEAD(fv_hashhead, fve) fv_hashtab[FV_HASHSIZE];	/* hash table */
	struct fve *fv_fves;	/* pointer to the allocated fves */
	
	struct {
		quad_t flows;		/* # of total flows which
					   experienced predrop */
		quad_t pass;		/* # of packets that have the fve
					   but aren't predropped */
		quad_t predrop;		/* # of packets predropped */
		quad_t alloc;		/* # of fves assigned */
		quad_t overflow;	/* # of prematurely reclalimed fves */
		quad_t escape;		/* # of fves escaped */
	} fv_stats;
};

#endif /* KERNEL */

#endif /* _NETINET_ALTQ_FLOWVALVE_H_ */
