# EM6 (Elastic multicast over ipv6/Kame patch for FreeBSD2.2.8)
# Copyright (C) 1999 FUJITSU LABORATORIES LTD.
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. Neither the name of the project nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

proc Em6grp_vic_init {} {
    global em6grp_vic_join_nodes
    global em6grp_vic_addrs
    global em6grp_vic_grp_id
    global em6grp_vic_grp_URL

    set em6grp_vic_join_nodes ""
    set em6grp_vic_addrs ""
    set em6grp_vic_grp_URL [ resource em6grp_vic_grp_URL ]
    set tmp_nodes ""
    set tmp_addrs ""
    set HOST [ exec hostname ]

    #      puts stdout "em6grp_vic_grp_URL = $em6grp_vic_grp_URL"

    set em6grp_vic_grp_id \
	    [ Em6grp_open $em6grp_vic_grp_URL nodes addrs ]

    if { [set place [lsearch $nodes $HOST]] != -1 } {
	set nodes [lreplace $nodes $place $place]
	set addrs [lreplace $addrs $place $place]
    }

    foreach i $nodes {
	append tmp_nodes $i
	append tmp_nodes ","
    }
    regexp {(.*),$} $tmp_nodes matched em6grp_vic_join_nodes

    foreach i $addrs {
	append tmp_addrs $i
	append tmp_addrs ","
    }
    regexp {(.*),$} $tmp_nodes matched em6grp_vic_addrs
}



proc Em6grp_vic_finish {} {
    global em6grp_vic_grp_id
    Em6grp_close $em6grp_vic_grp_id
}



proc Em6grp_vic_chk_notify {} {
    global em6grp_vic_join_nodes
    global em6grp_vic_join_addrs
    global em6grp_vic_leave_nodes
    global em6grp_vic_leave_addrs
    global em6grp_vic_grp_id

    set em6grp_vic_join_nodes ""
    set em6grp_vic_join_addrs ""
    set em6grp_vic_leave_nodes ""
    set em6grp_vic_leave_addrs ""
    set em6grp_vic_grp_URL [ resource em6grp_vic_grp_URL ]
    set tmp_jnodes ""
    set tmp_lnodes ""
    set tmp_jaddrs ""
    set tmp_laddrs ""
    set HOST [ exec hostname ]

    Em6grp_chk_notify $em6grp_vic_grp_id jnodes lnodes jaddrs laddrs

    if { [set place [lsearch $jnodes $HOST]] != -1 } {
	set jnodes [lreplace $jnodes $place $place]
	set jaddrs [lreplace $jaddrs $place $place]
    }

    if { [set place [lsearch $lnodes $HOST]] != -1 } {
	set lnodes [lreplace $lnodes $place $place]
	set laddrs [lreplace $laddrs $place $place]
    }

    foreach i $jnodes {
	append tmp_jnodes $i
	append tmp_jnodes ","
    }
    regexp {(.*),$} $tmp_jnodes matched em6grp_vic_join_nodes

    # puts stdout "Em6grp_vic_chk_notify: join_nodes = $em6grp_vic_join_nodes"

    foreach i $lnodes {
	append tmp_lnodes $i
	append tmp_lnodes ","
    }
    regexp {(.*),$} $tmp_lnodes matched em6grp_vic_leave_nodes

    # puts stdout "Em6grp_vic_chk_notify: leave_nodes = $em6grp_vic_leave_nodes"

    foreach i $jaddrs {
	append tmp_jaddrs $i
	append tmp_jaddrs ","
    }
    regexp {(.*),$} $tmp_jaddrs matched em6grp_vic_join_addrs

    foreach i $laddrs {
	append tmp_laddrs $i
	append tmp_laddrs ","
    }
    regexp {(.*),$} $tmp_laddrs matched em6grp_vic_leave_addrs
}



proc Em6grp_vic_join {} {
    set em6grp_keep_alive_interval 10000

    global em6grp_vic_grp_URL
    global em6grp_vic_user_URL
    set em6grp_vic_grp_URL [ resource em6grp_vic_grp_URL ]
    set em6grp_vic_user_URL [ resource em6grp_vic_user_URL ]

    #      puts stdout "em6grp_vic_user_URL = $em6grp_vic_user_URL"

    Em6grp_join $em6grp_vic_grp_URL $em6grp_vic_user_URL $em6grp_keep_alive_interval
}



proc Em6grp_vic_leave {} {
    global em6grp_vic_grp_URL
    global em6grp_vic_user_URL

    Em6grp_leave $em6grp_vic_grp_URL $em6grp_vic_user_URL
}
