/* wptGPGOE.cpp - GPGOE interface
 *	Copyright (C) 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#include <windows.h>

#include "wptTypes.h"
#include "wptErrors.h"
#include "wptGPGME.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptiGPGME.h"
#include "wptW32API.h"
#include "wptKeylist.h"
#include "wptUTF8.h"


/* GPGOE DLL interface */
extern "C" {
int gpgoe_remove( void );
int gpgoe_initialize( void );
void gpgoe_set_interface_cb( void (*interface_cb)( GPGME_INTERFACE *g, WINPT_INTERFACE *w ) );
}

static GPGME_INTERFACE gpgme_iface = NULL;
static WINPT_INTERFACE winpt_iface = NULL;


extern "C" void
get_interfaces( GPGME_INTERFACE *gpgme, WINPT_INTERFACE *winpt )
{    
    *gpgme = gpgme_iface;
    *winpt = winpt_iface;
}


void
interfaces_init( void )
{
    GPGME_INTERFACE p;
    WINPT_INTERFACE q;

    if( gpgme_iface && winpt_iface )
	return;
    p = gpgme_iface = new gpgme_interface_s;
    if( !gpgme_iface )
	BUG( NULL );
    q  = winpt_iface = new winpt_interface_s;
    if( !winpt_iface )
	BUG( NULL );
    
    p->clipboard.decrypt = gpgme_op_decrypt_clipboard;
    p->clipboard.encrypt = gpgme_op_encrypt_clipboard;
    p->clipboard.sign_encrypt = gpgme_op_sign_encrypt_clipboard;
    p->clipboard.verify = gpgme_op_verify_clipboard;
    p->clipboard.sign = gpgme_op_sign_clipboard;

    p->errbox = gpgme_errbox;
    p->new_ctx = gpgme_new;
    p->release = gpgme_release;
    p->decrypt_get_sig_ctx = gpgme_decrypt_get_sig_ctx;    
    p->set_passphrase_cb = gpgme_set_passphrase_cb;

    p->recipients.add_name = gpgme_recipients_add_name;
    p->recipients.count = gpgme_recipients_count;
    p->recipients.release = gpgme_recipients_release;
    p->recipients.new_ctx = gpgme_recipients_new;
    p->recipients.enum_open = gpgme_recipients_enum_open;
    p->recipients.enum_read = gpgme_recipients_enum_read;
    p->recipients.enum_close = gpgme_recipients_enum_close;

    p->sig.get_string_attr = gpgme_sig_get_string_attr;
    p->sig.get_ulong_attr = gpgme_sig_get_ulong_attr;
    p->sig.new_ctx = gpgme_sig_new;
    p->sig.release = gpgme_sig_release;

    p->cache.next_key = gpgme_keycache_next_key;
    p->cache.find_key = gpgme_keycache_find_key;

    //p->key.get_string_attr = gpgme_key_get_string_attr;
    
    p->clipboard.get = get_clip_text;
    p->clipboard.set = set_clip_text;
    p->clipboard.is_secured = gpgme_clip_is_secured;
    p->clipboard.istext_avail = gpgme_clip_istext_avail;
    p->clipboard.parse_pgpid =  gpgme_clip_parse_pgpid;
    
    q->keylist.load = keylist_load;
    
    q->utf8.to_native = utf8_to_native;
    q->utf8.to_utf8 = native_to_utf8;
    q->utf8.conv_charset = conv_charset;

    q->sig.get_status = get_signature_status;

    q->listview.count_items = listview_count_items;
    q->listview.get_item_state = listview_get_item_state;
    q->listview.get_item_text = listview_get_item_text;
    q->listview.release = listview_release;
    q->listview.get_curr_pos = listview_get_curr_pos;

    q->cache.get_ctx = keycache_get_ctx;

    q->gpg.get_default_key = get_gnupg_default_key;
}


void
interfaces_destroy( void )
{
    if( winpt_iface ) {
	delete winpt_iface;
	winpt_iface = NULL;
    }
    if( gpgme_iface ) {
	delete gpgme_iface;
	gpgme_iface = NULL;
    }
}


int
gpgoe_load_plugin( void )
{   
    if( !gpgme_iface && !winpt_iface )
	interfaces_init();
    int rc = gpgoe_initialize( );
    if( !rc )	
	gpgoe_set_interface_cb( get_interfaces );
    return rc;
} /* gpgoe_load_plugin */


void
gpgoe_unload_plugin( void )
{
    interfaces_destroy();
    gpgoe_remove();

} /* gpgoe_unload_plugin */


