/* ops.h - internal operations stuff 
 *	Copyright (C) 2000 Werner Koch (dd9jn)
 *	Copyright (C) 2003, 2004, 2005 Timo Schulz
 *
 * This file is part of MyGPGME.
 *
 * MyGPGME is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MyGPGME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef GPGME_OPS_H
#define GPGME_OPS_H

#include "types.h"
#include "rungpg.h"

/* cleanup */
void  debug_cleanup (void);
void  rungpg_cleanup (void);
void  io_cleanup (void);
void  wait_cleanup (void);

/*-- gpgme.c --*/
void _gpgme_release_result ( gpgme_ctx_t c );
const char* _gpgme_get_tmpfile( int input );
void _gpgme_del_tmpfiles( gpgme_wipe_t wipe_fnc );
gpgme_error_t _gpgme_add_passphrase( gpgme_ctx_t c );
void _gpgme_progress_handler( gpgme_ctx_t ctx, char * args );
void _gpgme_add_comment (gpgme_ctx_t ctx);

/*-- wait.c --*/
gpgme_ctx_t _gpgme_wait_on_condition( gpgme_ctx_t c,
                                      int hang, volatile int *cond );
void _gpgme_freeze_fd( int fd );
void _gpgme_thaw_fd( int fd );


/*-- recipient.c --*/
void _gpgme_append_gpg_args_from_recipients (
    const gpgme_recipients_t rset, _gpg_object_t gpg );
    
int _gpgme_recipients_all_valid ( const gpgme_recipients_t rset );

/*-- data.c --*/
char *        _gpgme_data_release_and_return_string ( gpgme_data_t dh );
gpgme_data_mode_t _gpgme_data_get_mode ( gpgme_data_t dh );
void          _gpgme_data_set_mode ( gpgme_data_t dh, gpgme_data_mode_t mode );
char *        _gpgme_data_get_as_string ( gpgme_data_t dh );
gpgme_error_t    _gpgme_data_append ( gpgme_data_t dh,
                                   const char *buffer, size_t length );
gpgme_error_t    _gpgme_data_append_string ( gpgme_data_t dh, const char *s );
gpgme_error_t    _gpgme_data_unread (gpgme_data_t dh,
                                  const char *buffer, size_t length );
gpgme_error_t    _gpgme_data_read_from_tmpfile( gpgme_data_t dh );
gpgme_error_t    _gpgme_data_write_to_tmpfile( gpgme_data_t dh );
gpgme_error_t _gpgme_decode_c_string( const char *src, char **destp, size_t len );
gpgme_error_t _gpgme_data_eof( gpgme_data_t dh );

/*-- key.c --*/
gpgme_error_t _gpgme_key_new ( gpgme_key_t *r_key );
gpgme_error_t _gpgme_key_new_secret ( gpgme_key_t *r_key );
gpgme_key_t _gpgme_key_new_fromkeyid( const char * keyid );

/*-- encrypt.c --*/
void _gpgme_release_encrypt_result( _encrypt_result_t res );
void _gpgme_encrypt_add_cipher( gpgme_ctx_t ctx );

/*-- verify.c --*/
void _gpgme_release_verify_result ( _verify_result_t res );

/*-- decrypt.c --*/
void _gpgme_release_decrypt_result ( _decrypt_result_t res );

/*-- sign.c --*/
void _gpgme_release_sign_result ( _sign_result_t res );

/*-- sig.c --*/
void _gpgme_sig_ref( gpgme_sig_t sig );

/*-- sign-encrypt.c --*/
void _gpgme_release_sign_encrypt_result( _sign_encrypt_result_t res );

/*-- import.c --*/
void _gpgme_release_import_result ( _import_result_t res );

/*-- sym-encrypt.c --*/
void _gpgme_release_symenc_result( _symenc_result_t res );

/*-- editkey.c --*/
void _gpgme_release_editkey_result (_editkey_result_t res);

/*-- recipients.c --*/
gpgme_error_t _gpgme_recipients_add_name_ext( gpgme_recipients_t rset, 
					    const char * data,
					    unsigned int magic );

/*-- errors.c --*/
const char* _gpgme_gettext( const char *a );

#endif /* GPGME_OPS_H */
