# Makefile - PTD.dsp

ifndef CFG
CFG=PTD - Win32 Debug
endif
CC=gcc
CFLAGS=
CXX=g++
CXXFLAGS=$(CFLAGS)
RC=windres -O COFF
ifeq "$(CFG)"  "PTD - Win32 Release"
CFLAGS+=-W -fexceptions -O2 -I../gnupg -I. -I../include -DWIN32 -DNDEBUG -D_WINDOWS -D_MBCS -D_USRDLL -DPTD_EXPORTS -DHAVE_DOSISH_SYSTEM
LD=dllwrap
LDFLAGS=
LDFLAGS+=-L../Gnupg
LIBS+=-lkernel32 -luser32 -lgdi32 -lwinspool -lcomdlg32 -ladvapi32 -lshell32 -lole32 -loleaut32 -luuid -lodbc32 -lodbccp32 -lgnupg -lstdc++
else
ifeq "$(CFG)"  "PTD - Win32 Debug"
CFLAGS+=-D_MBCS -W -D_USRDLL -DPTD_EXPORTS -fexceptions -g -O0 -I../Src -I../MyGPGME -I../Include -I../Gnupg -I../PTD -DWIN32 -D_DEBUG -D_WINDOWS
LD=dllwrap
LDFLAGS=
LDFLAGS+=-L../Gnupg
LIBS+=-lkernel32 -luser32 -lgdi32 -lwinspool -lcomdlg32 -ladvapi32 -lshell32 -lole32 -loleaut32 -luuid -lodbc32 -lodbccp32 -lgnupg -lstdc++
endif
endif

ifndef TARGET
TARGET=PTD.dll
endif

.PHONY: all
all: $(TARGET)

#%.o: %.c
#	$(CC) $(CFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cc
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cpp
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cxx
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.res: %.rc
	$(RC) $(CPPFLAGS) -o $@ -i $<

RESOURCEN= \
	PTD.def \
	PTD.rc \
	resource.h

SRCS=$(RESOURCEN)  \
	PTD.cpp \
	wptFileDisk.cpp \
	wptGPGZIP.cpp \
	wptGPGZIP.h \
	wptWipeFile.cpp

OBJS=$(patsubst %.rc,%.res,$(patsubst %.cxx,%.o,$(patsubst %.cpp,%.o,$(patsubst %.cc,%.o,$(patsubst %.c,%.o,$(filter %.c %.cc %.cpp %.cxx %.rc,$(SRCS)))))))

$(TARGET): $(OBJS)
	$(LD) $(LDFLAGS) -o $@ $(OBJS) $(LIBS)

.PHONY: clean
clean:
	-rm -f $(OBJS) $(TARGET) PTD.dep

.PHONY: depends
depends:
	-$(CXX) $(CXXFLAGS) $(CPPFLAGS) -MM $(filter %.c %.cc %.cpp %.cxx,$(SRCS)) > PTD.dep

-include PTD.dep

