/* wptAgent.h - WinPT Agent (Bond)
 *	Copyright (C) 2001-2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef WPT_AGENT_H
#define WPT_AGENT_H

void agent_flush_cache (void);
int agent_put_cache (const char * key, const char * data, int ttl);
int agent_del_cache (const char * key);
const char * agent_get_cache (const char * key, void ** cache_id);
void agent_unlock_cache_entry (void ** cache_id);

#endif /* WPT_AGENT_H */