/*
    SPDX-FileCopyrightText: 2018 Chinmoy Ranjan Pradhan <chinmoyrp65@gmail.com>

    SPDX-License-Identifier: GPL-2.0-or-later
*/

#ifndef _OKULAR_GENERATOR_PDF_SIGNATUREUTILS_H_
#define _OKULAR_GENERATOR_PDF_SIGNATUREUTILS_H_

#include <poppler-form.h>
#include <poppler-version.h>
#define POPPLER_VERSION_MACRO ((POPPLER_VERSION_MAJOR << 16) | (POPPLER_VERSION_MINOR << 8) | (POPPLER_VERSION_MICRO))

#include <QDialog>
#include <QLabel>
#include <QLineEdit>

#include "core/signatureutils.h"

class PopplerCertificateInfo : public Okular::CertificateInfo
{
public:
    explicit PopplerCertificateInfo(const Poppler::CertificateInfo &info);
    ~PopplerCertificateInfo() override;

    bool isNull() const override;
    int version() const override;
    QByteArray serialNumber() const override;
    QString issuerInfo(EntityInfoKey) const override;
    QVector<QPair<QString, QString>> splitIssuerDN() const override;
    QString subjectInfo(EntityInfoKey) const override;
    QVector<QPair<QString, QString>> splitSubjectDN() const override;
    QString nickName() const override;
    QDateTime validityStart() const override;
    QDateTime validityEnd() const override;
    KeyUsageExtensions keyUsageExtensions() const override;
    QByteArray publicKey() const override;
    PublicKeyType publicKeyType() const override;
    int publicKeyStrength() const override;
    bool isSelfSigned() const override;
    QByteArray certificateData() const override;
    bool kleopatraCompatible() const override;
    bool checkPassword(const QString &password) const override;

private:
    Poppler::CertificateInfo m_info;
};

class PopplerSignatureInfo : public Okular::SignatureInfo
{
public:
    explicit PopplerSignatureInfo(const Poppler::SignatureValidationInfo &info);
    ~PopplerSignatureInfo() override;

    SignatureStatus signatureStatus() const override;
    CertificateStatus certificateStatus() const override;
    QString signerName() const override;
    QString signerSubjectDN() const override;
    QString location() const override;
    QString reason() const override;
    HashAlgorithm hashAlgorithm() const override;
    QDateTime signingTime() const override;
    QByteArray signature() const override;
    QList<qint64> signedRangeBounds() const override;
    bool signsTotalDocument() const override;
    const Okular::CertificateInfo &certificateInfo() const override;

private:
    Poppler::SignatureValidationInfo m_info;
    Okular::CertificateInfo *m_certfiticateInfo;
};

class PopplerCertificateStore : public Okular::CertificateStore
{
public:
    ~PopplerCertificateStore() override;

    QList<Okular::CertificateInfo *> signingCertificates(bool *userCancelled) const override;
};

class SignatureDialog : public QDialog
{
    Q_OBJECT

protected:
    QString m_reason;
    QString m_location;
    QString m_someText;
    QString m_imagePath;

    QLineEdit *m_reason_field;
    QLineEdit *m_location_field;
    QLineEdit *m_someText_field;
    QLabel *m_backgroundPreview;

public Q_SLOTS:
    void accept() override;
    void pickImage();

public:
    SignatureDialog(QWidget *parent);

    QString reason();
    QString location();
    QString someText();
    QString imagePath();
};

#endif
