// SPDX-FileCopyrightText: 2024 g10 Code GmbH
// SPDX-FileContributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-3.0-or-later

#pragma once

#include <QTimer>
#include <QWidget>

class QMainWindow;
class QFormLayout;
class QPushButton;
class KTitleWidget;
class ClipboardHelper;
class PassEntry;

/// Widget to view passwords
class PasswordViewerWidget : public QWidget
{
    Q_OBJECT

public:
    explicit PasswordViewerWidget(ClipboardHelper *clipboardHelper, QWidget *parent = nullptr);

    void setPassEntry(const PassEntry &passEntry, const QString &content);

    void setPanelTimer();

    /// Hide the information from shoulder surfers
    void clear();

private:
    /// Add one field to the template grid
    void addToGridLayout(const QString &field, const QString &value);

    /// Empty the template widget fields in the UI.
    void clearTemplateWidgets();

    KTitleWidget *const m_titleWidget;
    ClipboardHelper *const m_clipboardHelper;
    QFormLayout *const m_contentLayout;
    QPushButton *const m_copyPasswordNameButton;
    QTimer clearPanelTimer;
};