/*
    SPDX-FileCopyrightText: 2014-2023 Anne Jan Brouwer <brouwer@annejan.com>
    SPDX-FileCopyrightText: 2018 Claudio Maradonna <penguyman@stronzi.org>
    SPDX-FileCopyrightText: 2019 Maciej S. Szmigiero <mail@maciej.szmigiero.name>
    SPDX-FileCopyrightText: 2023 g10 Code GmbH
    SPDX-FileContributor: Sune Stolborg Vuorela <sune@vuorela.dk>

    SPDX-License-Identifier: GPL-3.0-or-later
*/
#ifndef STOREMODEL_H_
#define STOREMODEL_H_

#include <QSortFilterProxyModel>

class QFileSystemModel;
class QItemSelectionModel;
class KSelectionProxyModel;
class AddFileInfoProxy;
class Pass;

/// \brief The QSortFilterProxyModel for handling filesystem searches.
///
/// This model support drag and drop.
class StoreModel : public QSortFilterProxyModel
{
    Q_OBJECT

public:
    explicit StoreModel(Pass &pass);

    QString rootPath() const;
    void setRootPath(const QString &rootPath);

    /// Overriden to remove .gpg at the end of the file name.
    QVariant data(const QModelIndex &index, int role) const override;
    bool lessThan(const QModelIndex &source_left, const QModelIndex &source_right) const override;

    Qt::DropActions supportedDropActions() const override;
    Qt::DropActions supportedDragActions() const override;
    Qt::ItemFlags flags(const QModelIndex &index) const override;
    QStringList mimeTypes() const override;
    QMimeData *mimeData(const QModelIndexList &indexes) const override;
    bool canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent) const override;
    bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent) override;

private:
    Pass &m_pass;
    QFileSystemModel *const m_fileSystemModel;
    AddFileInfoProxy *const m_addRoleModel;
    QItemSelectionModel *const m_itemSelectionModel;
    KSelectionProxyModel *const m_selectionProxyModel;
};

#endif // STOREMODEL_H_
