/*
    SPDX-FileCopyrightText: 2023 g10 Code GmbH
    SPDX-FileContributor: Sune Stolborg Vuorela <sune@vuorela.dk>

    SPDX-License-Identifier: GPL-3.0-or-later
*/
#ifndef FIRSTTIMEDIALOG_H
#define FIRSTTIMEDIALOG_H

#include "usersdialog.h"
#include <QGpgME/Protocol>
#include <QWizard>
#include <userinfo.h>

class Ui_KeyGenWidget;
class Ui_UsersWidget;
class Ui_KeyGenWidget;
class Ui_SelectPasswordStore;

class DialogState : public QObject
{
    Q_OBJECT
public:
    explicit DialogState(Pass &p);
    QList<UserInfo> privateKeys() const;
    QGpgME::Protocol *protocol = QGpgME::openpgp();
    QString storePath;
    Pass &pass;
};

class FirstTimeDialog : public QWizard
{
    enum Pages { Intro, KeyGen, PasswordStore, KeySelect, Done };
    Q_OBJECT
public:
    FirstTimeDialog(QWidget *mainWindow, Pass &pass);
    int nextId() const override;
    void done(int i) override;

private:
    QWidget *m_mainWindow;
    DialogState m_state;
};

class IntroPage : public QWizardPage
{
    Q_OBJECT
public:
    explicit IntroPage(DialogState &s);

private:
    DialogState &m_state;
};

class KeyGenPage : public QWizardPage
{
    Q_OBJECT
public:
    explicit KeyGenPage(DialogState &s);
    bool isComplete() const override;
    ~KeyGenPage();
private Q_SLOTS:
    void startKeyGen();
    void checkEntries();

private:
    DialogState &m_state;
    std::unique_ptr<Ui_KeyGenWidget> m_ui;
};

class PasswordStorePage : public QWizardPage
{
    Q_OBJECT
public:
    explicit PasswordStorePage(DialogState &s);
    bool validatePage() override;
    ~PasswordStorePage();
    bool isComplete() const override;

private:
    std::unique_ptr<Ui_SelectPasswordStore> m_ui;
    DialogState &m_state;
};

class KeySelectPage : public QWizardPage
{
    Q_OBJECT
public:
    explicit KeySelectPage(DialogState &s);
    bool isComplete() const override;
    bool validatePage() override;
    void initializePage() override;
    ~KeySelectPage();

private:
    std::unique_ptr<Ui_UsersWidget> m_ui;
    DialogState &m_state;
    UsersWidgetData d;
};

class DonePage : public QWizardPage
{
public:
    DonePage();
};

#endif // FIRSTTIMEDIALOG_H
