//---------------------------------------------------------------------------
// GPGee - GNU Privacy Guard Explorer Extension
// GPGeeContextMenuExtensionImpl.h - Explorer extension COM code header
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of GPGee.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// GPGee is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

// GPGEECONTEXTMENUEXTENSIONIMPL.H : Declaration of the TGPGeeContextMenuExtensionImpl

#ifndef GPGeeContextMenuExtensionImplH
#define GPGeeContextMenuExtensionImplH

#define ATL_APARTMENT_THREADED

#include "GPGee_TLB.h"


/////////////////////////////////////////////////////////////////////////////
// TGPGeeContextMenuExtensionImpl
//   Implements IGPGeeContextMenuExtension, default interface of
//   GPGeeContextMenuExtension
// ThreadingModel : Apartment
// Dual Interface : FALSE
// Event Support  : FALSE
// Default ProgID : GPGee.GPGeeContextMenuExtension
// Description    : GNU Privacy Guard  Explorer Extension
/////////////////////////////////////////////////////////////////////////////
class ATL_NO_VTABLE TGPGeeContextMenuExtensionImpl :
  public CComObjectRootEx<CComSingleThreadModel>,
  public CComCoClass<TGPGeeContextMenuExtensionImpl, &CLSID_GPGeeContextMenuExtension>,
  public IShellExtInit,
  public IContextMenu,
  DUALINTERFACE_IMPL(GPGeeContextMenuExtension, IGPGeeContextMenuExtension)
{
public:
  TGPGeeContextMenuExtensionImpl();
  ~TGPGeeContextMenuExtensionImpl();

  // Data used when registering Object 
  //
  DECLARE_THREADING_MODEL(otApartment);
  DECLARE_PROGID("GPGee.GPGeeContextMenuExtension");
  DECLARE_DESCRIPTION("GNU Privacy Guard  Explorer Extension");

  // Function invoked to (un)register object
  //
  static HRESULT WINAPI UpdateRegistry(BOOL bRegister);

  // IShellExtInit method
  STDMETHODIMP Initialize(LPCITEMIDLIST,LPDATAOBJECT,HKEY);

  // IContextMenu
  STDMETHODIMP GetCommandString(UINT, UINT, UINT*, LPSTR, UINT);
  STDMETHODIMP InvokeCommand(LPCMINVOKECOMMANDINFO);
  STDMETHODIMP QueryContextMenu(HMENU, UINT, UINT, UINT, UINT);


BEGIN_COM_MAP(TGPGeeContextMenuExtensionImpl)
  COM_INTERFACE_ENTRY(IShellExtInit)
  COM_INTERFACE_ENTRY(IContextMenu)
  DUALINTERFACE_ENTRY(IGPGeeContextMenuExtension)
END_COM_MAP()

// IGPGeeContextMenuExtension
public:

private:
  TStringList *FileNames;
  bool AllFilesAreGPG;
  HBITMAP MenuKeyBitmap;
  HBITMAP MenuSignBitmap;
  HBITMAP MenuSignEncryptBitmap;
  HBITMAP MenuEncryptBitmap;
  HBITMAP MenuVerifyDecryptBitmap;
  HBITMAP MenuConfigureBitmap;
  void __fastcall HandleSignEncrypt(bool bSign, bool bEncrypt);
  void __fastcall HandleVerifyDecrypt(void);
  void __fastcall HandleConfigure(void);
};

#define GPGEE_VERIFYDECRYPT 0
#define GPGEE_SEP1 1
#define GPGEE_DCONFIGURE 2

#define GPGEE_SIGNENCRYPT 0
#define GPGEE_SIGN 1
#define GPGEE_ENCRYPT 2
#define GPGEE_SEP2 3
#define GPGEE_ECONFIGURE 4

#endif //GPGeeContextMenuExtensionImplH
