package gnu.crypto.jce.keystore;

// ----------------------------------------------------------------------------
// $Id: $
//
// Copyright (C) 2003 Free Software Foundation, Inc.
//
// This file is part of GNU Crypto.
//
// GNU Crypto is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// GNU Crypto is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to the
//
//    Free Software Foundation Inc.,
//    59 Temple Place - Suite 330,
//    Boston, MA 02111-1307
//    USA
//
// Linking this library statically or dynamically with other modules is
// making a combined work based on this library.  Thus, the terms and
// conditions of the GNU General Public License cover the whole
// combination.
//
// As a special exception, the copyright holders of this library give
// you permission to link this library with independent modules to
// produce an executable, regardless of the license terms of these
// independent modules, and to copy and distribute the resulting
// executable under terms of your choice, provided that you also meet,
// for each linked independent module, the terms and conditions of the
// license of that module.  An independent module is a module which is
// not derived from or based on this library.  If you modify this
// library, you may extend this exception to your version of the
// library, but you are not obligated to do so.  If you do not wish to
// do so, delete this exception statement from your version.
// ----------------------------------------------------------------------------

import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Date;

/**
 * The Java Keystore <i>Service Provider Implementation</i> (SPI) class over the
 * GNU {@link gnu.crypto.tool.vault.Keyrings} object.
 *
 * @version $Revision: $
 */
public class KeyringsSpi extends KeyStoreSpi {

   // Constants and variables
   // -------------------------------------------------------------------------

   // Constructor(s)
   // -------------------------------------------------------------------------

	/**
	 *
	 */
	public KeyringsSpi() {
		super();
	}

   // Class methods
   // -------------------------------------------------------------------------

   // Instance methods
   // -------------------------------------------------------------------------

   /**
    * Retrieves the number of entries in this keystore.
    *
    * @return the number of entries in this keystore.
    */
	public int engineSize() {
		return 0;
	}

   /**
    * <p>Loads the keystore.</p>
    *
    * <p>If <code>password</code> is not <code>null</code>, it is used to check
    * the integrity of the keystore data. Otherwise, the integrity of the
    * keystore is not checked.</p>
    *
    * @param stream the input stream from which the keystore is loaded. Ignored.
    * @param password the (optional) password used to check the integrity of the
    * keystore.
    * @throws IOException if there is an I/O or format problem with the keystore
    * data.
    * @throws NoSuchAlgorithmException if the algorithm used to check the
    * integrity of the keystore cannot be found.
    * @throws CertificateException if any of the certificates in the keystore
    * could not be loaded.
    */
	public void engineLoad(InputStream stream, char[] password)
	throws IOException, NoSuchAlgorithmException, CertificateException {
	}

   /**
    * Stores this keystore and protects its integrity with the designated
    * <code>password</code>.
    *
    * @param stream the output stream to which this keystore is written. Ignored.
    * @param password the password to generate the keystore integrity check.
    * @throws IOException if there was an I/O problem with data.
    * @throws NoSuchAlgorithmException if the appropriate data integrity
    * algorithm could not be found.
    * @throws CertificateException if any of the certificates included in the
    * keystore data could not be stored.
    */
	public void engineStore(OutputStream stream, char[] password)
   throws IOException, NoSuchAlgorithmException, CertificateException {
	}

   /**
    * Deletes the entry identified by the designated <code>alias</code> from
    * this keystore.
    *
    * @param alias the alias name.
    * @throws KeyStoreException if the entry cannot be removed.
    */
	public void engineDeleteEntry(String alias) throws KeyStoreException {
	}

   /**
    * Checks if the designated <code>alias</code> exists in this keystore.
    *
    * @param alias the alias name.
    * @return <code>true</code> if <code>alias</code> exists, <code>false</code>
    * otherwise.
    */
	public boolean engineContainsAlias(String alias) {
		return false;
	}

   /**
    * Returns <code>true</code> if the entry identified by the designated
    * <code>alias</code> is a <i>trusted certificate</i> entry, and
    * <code>false</code> otherwise.
    *
    * @param alias the alias for the keystore entry to be checked.
    * @return <code>true</code> if the entry identified by <code>alias</code> is
    * a <i>trusted certificate</i> entry; <code>false</code> otherwise.
    */
	public boolean engineIsCertificateEntry(String alias) {
		return false;
	}

   /**
    * Returns <code>true</code> if the entry identified by the designated
    * <code>alias</code> is a <i>key entry</i>, and <code>false</code> otherwise.
    *
    * @param alias the alias for the keystore entry to be checked.
    * @return <code>true</code> if the entry identified by <code>alias</code> is
    * a <i>key entry</i>; <code>false</code> otherwise.
    */
	public boolean engineIsKeyEntry(String alias) {
		return false;
	}

   /**
    * Lists all the alias names of this keystore.
    *
    * @return an {@link Enumeration} of the alias names.
    */
	public Enumeration engineAliases() {
		return null;
	}

   /**
    * <p>Returns the (alias) name of the first keystore entry whose certificate
    * matches the designated <code>certificate</code>.</p>
    *
    * <p>This method attempts to match <code>certificate</code> with each
    * keystore entry. If the entry being considered is a <i>trusted certificate</i>
    * entry, <code>certificate</code> is compared to that entry's certificate.
    * If the entry being considered is a <i>key entry</i>, the given certificate
    * is compared to the first element of that entry's certificate chain (if a
    * chain exists).</p>
    *
    * @param cert the certificate to match with.
    * @return the (alias) name of the first entry with matching certificate, or
    * <code>null</code> if no such entry exists in this keystore.
    */
	public String engineGetCertificateAlias(Certificate cert) {
		return null;
	}

	/**
    * Returns the key associated with the designated <code>alias</code>, using
    * the designated <code>password</code> to recover it.
    *
    * @param alias the alias name.
    * @param password the password for recovering the key.
    * @return the requested key, or <code>null</code> if <code>alias</code> does
    * not exist or does not identify an existing <i>key entry</i>.
    * @throws NoSuchAlgorithmException if the algorithm for recovering the key
    * cannot be found.
    * @throws UnrecoverableKeyException if the key cannot be recovered (e.g.
    * <code>password</code> is wrong).
    */
	public Key engineGetKey(String alias, char[] password)
	throws NoSuchAlgorithmException, UnrecoverableKeyException {
		return null;
	}

   /**
    * <p>Returns the certificate associated with the designated
    * <code>alias</code>.</p>
    *
    * <p>If <code>alias</code> identifies a <i>trusted certificate</i> entry,
    * the certificate associated with that entry is returned. If <code>alias</code>
    * identifies a <i>key entry</i>, the first element of the certificate chain
    * of that entry is returned, or <code>null</code> if that entry does not
    * have a certificate chain.</p>
    *
    * @param alias the alias name.
    * @return the certificate, or <code>null</code> if <code>alias</code> does
    * not exist or does not contain a certificate.
    */
	public Certificate engineGetCertificate(String alias) {
		return null;
	}

   /**
    * Returns the certificate chain associated with the designated <code>alias</code>.
    *
    * @param alias the alias name.
    * @return the certificate chain (ordered with the user's certificate first
    * and the root certificate authority last), or <code>null</code> if
    * <code>alias</code> does not exist or does not contain a certificate chain
    * (i.e. the given <code>alias</code> identifies either a <i>trusted
    * certificate</i> entry or a <i>key entry</i> without a certificate chain).
    */
	public Certificate[] engineGetCertificateChain(String alias) {
		return null;
	}

   /**
    * <p>Assigns the designated <code>certificate</code> to the designated
    * <code>alias</code>.</p>
    *
    * <p>If <code>alias</code> already exists in this keystore and identifies a
    * <i>trusted certificate</i> entry, the certificate associated with it is
    * overridden by <code>certificate</code>.</p>
    *
    * @param alias the alias name.
    * @param cert the certificate.
    * @throws KeyStoreException if <code>alias</code> already exists and does
    * not identify a <i>trusted certificate</i> entry, or this operation fails
    * for some other reason.
    */
	public void engineSetCertificateEntry(String alias, Certificate cert)
	throws KeyStoreException {
	}

   /**
    * <p>Assigns the designated <code>key</code> (that has already been
    * protected) to the designated <code>alias</code>.</p>
    *
    * <p>If the protected key is of type {@link PrivateKey}, it must be
    * accompanied by a certificate chain certifying the corresponding public
    * key.</p>
    *
    * <p>If <code>alias</code> already exists, the keystore information
    * associated with it is overridden by <code>key</code> (and possibly
    * certificate chain).</p>
    *
    * @param alias the alias name.
    * @param key the key (in protected format) to be associated with the alias.
    * @param chain the certificate chain for the corresponding public key (only
    * useful if the protected key is of type {@link PrivateKey}).
    * @throws KeyStoreException if this operation fails.
    */
	public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain)
	throws KeyStoreException {
	}

   /**
    * Returns the creation date of the entry identified by the designated
    * <code>alias</code>.
    *
    * @param alias the alias name.
    * @return the creation date of this entry, or <code>null</code> if
    * <code>alias</code> does not exist.
    */
	public Date engineGetCreationDate(String alias)
	{
		return null;
	}

   /**
    * <p>Assigns the designated <code>key</code> to the designated <code>alias</code>,
    * protecting it with the designated <code>password</code>.</p>
    *
    * <p>If <code>key</code> is of type {@link PrivateKey}, it must be
    * accompanied by a certificate chain certifying the corresponding public key.
    * </p>
    *
    * <p>If <code>alias</code> already exists, the keystore information
    * associated with it is overridden by <code>key</code> (and possibly
    * certificate chain).</p>
    *
    * @param alias the alias name.
    * @param key the key to be associated with the alias.
    * @param password the password to protect the key.
    * @param chain the certificate chain for the corresponding public key (only
    * required if the given key is of type {@link PrivateKey}).
    * @throws KeyStoreException if <code>key</code> cannot be protected, or this
    * operation fails for some other reason.
    */
	public void
   engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain)
   throws KeyStoreException {
	}
}
