/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.tool.keytool;

import gnu.crypto.Properties;
import gnu.crypto.auth.callback.AbstractCallbackHandler;
import gnu.crypto.auth.callback.GnuCallbacks;
import gnu.crypto.tool.keytool.Command;
import gnu.crypto.tool.keytool.Delete;
import gnu.crypto.tool.keytool.Export;
import gnu.crypto.tool.keytool.GenKey;
import gnu.crypto.tool.keytool.Import;
import gnu.crypto.tool.keytool.List;
import gnu.crypto.tool.keytool.Path;
import gnu.crypto.tool.keytool.Revoke;
import gnu.crypto.tool.keytool.Sign;
import gnu.crypto.tool.keytool.Trust;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintStream;
import java.security.Provider;
import java.security.Security;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public final class Main {
    public static final String PROGNAME = "keytool";
    private static final int OPT_ARMOR = 1024;
    private static final int OPT_CALLBACK = 1025;
    private static final int OPT_CERT_TYPE = 1026;
    private static final int OPT_DATE = 1027;
    private static final int OPT_DEBUG = 1028;
    private static final int OPT_NO_KEYSTORE = 1029;
    private static final int OPT_PCLASS = 1030;
    private static final int OPT_PNAME = 1031;
    private static final int OPT_STORE_TYPE = 1032;
    private static final int OPT_VALIDITY = 1033;
    private static final int OPT_VERSION = 1034;
    static ResourceBundle messages;
    private static int FILL_COLUMN;

    public static final void main(String[] argv) {
        int c;
        try {
            messages = PropertyResourceBundle.getBundle("gnu/crypto/tool/keytool/MessagesBundle");
        }
        catch (MissingResourceException mre) {
            System.err.println("keytool: can't load messages bundle!");
            System.err.println("keytool: something is seriously wrong with your installation.");
            System.exit(1);
        }
        LinkedList<Command> commands = new LinkedList<Command>();
        Command cmd = new Command();
        String optstring = "thegirlsdpa:A:D:f:k:K:no:v";
        LongOpt[] longopts = new LongOpt[]{new LongOpt("delete", 0, null, 100), new LongOpt("export", 0, null, 101), new LongOpt("generate", 0, null, 103), new LongOpt("help", 0, null, 104), new LongOpt("import", 0, null, 105), new LongOpt("list", 0, null, 108), new LongOpt("path", 0, null, 112), new LongOpt("revoke", 0, null, 114), new LongOpt("sign", 0, null, 115), new LongOpt("trust", 0, null, 116), new LongOpt("version", 0, null, 1034), new LongOpt("alias", 1, null, 97), new LongOpt("armor", 0, null, 1024), new LongOpt("callback", 1, null, 1025), new LongOpt("ca-alias", 1, null, 65), new LongOpt("cert-type", 1, null, 1026), new LongOpt("date", 1, null, 1027), new LongOpt("debug", 0, null, 1028), new LongOpt("file", 1, null, 102), new LongOpt("keep-going", 0, null, 110), new LongOpt("keystore", 1, null, 107), new LongOpt("no-keystore", 0, null, 1029), new LongOpt("outfile", 1, null, 111), new LongOpt("provider", 1, null, 1031), new LongOpt("provider-class", 1, null, 1030), new LongOpt("secret-keystore", 1, null, 75), new LongOpt("store-type", 1, null, 1032), new LongOpt("validity", 1, null, 1033), new LongOpt("verbose", 0, null, 118)};
        Getopt g = new Getopt(PROGNAME, argv, "thegirlsdpa:A:D:f:k:K:no:v", longopts);
        boolean keep_going = false;
        boolean gnuCryptoProperty = false;
        boolean securityProperty = false;
        boolean debug = false;
        block46: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 100: {
                    cmd = new Delete(cmd);
                    commands.add(cmd);
                    break;
                }
                case 101: {
                    cmd = new Export(cmd);
                    commands.add(cmd);
                    break;
                }
                case 103: {
                    cmd = new GenKey(cmd);
                    commands.add(cmd);
                    break;
                }
                case 105: {
                    cmd = new Import(cmd);
                    commands.add(cmd);
                    break;
                }
                case 108: {
                    cmd = new List(cmd);
                    commands.add(cmd);
                    break;
                }
                case 112: {
                    cmd = new Path(cmd);
                    commands.add(cmd);
                    break;
                }
                case 114: {
                    cmd = new Revoke(cmd);
                    commands.add(cmd);
                    break;
                }
                case 115: {
                    cmd = new Sign(cmd);
                    commands.add(cmd);
                    break;
                }
                case 116: {
                    cmd = new Trust(cmd);
                    commands.add(cmd);
                    break;
                }
                case 104: {
                    Main.help(System.out);
                    System.exit(0);
                }
                case 1034: {
                    Main.version(System.out);
                    if (keep_going) continue block46;
                    System.exit(0);
                }
                case 97: {
                    cmd.alias = g.getOptarg();
                    break;
                }
                case 65: {
                    cmd.caAlias = g.getOptarg();
                    break;
                }
                case 68: {
                    String property = g.getOptarg();
                    String value = "true";
                    int i = property.indexOf(61);
                    if (i >= 0) {
                        value = property.substring(i + 1);
                        property = property.substring(0, i);
                    }
                    try {
                        if (securityProperty) {
                            Security.setProperty(property, value);
                            break;
                        }
                        if (gnuCryptoProperty) {
                            Properties.setProperty(property, value);
                            break;
                        }
                        if (i < 0 && property.equals("security")) {
                            securityProperty = true;
                            break;
                        }
                        if (i < 0 && property.equals("crypto")) {
                            gnuCryptoProperty = true;
                            break;
                        }
                        securityProperty = false;
                        gnuCryptoProperty = false;
                        System.setProperty(property, value);
                    }
                    catch (SecurityException se) {
                        Main.error("security policy does not allow setting properties");
                    }
                    continue block46;
                }
                case 102: {
                    cmd.file = g.getOptarg();
                    break;
                }
                case 107: {
                    cmd.storeFile = g.getOptarg();
                    break;
                }
                case 75: {
                    cmd.secretStore = g.getOptarg();
                    break;
                }
                case 110: {
                    keep_going ^= true;
                    break;
                }
                case 111: {
                    cmd.outFile = g.getOptarg();
                    break;
                }
                case 118: {
                    ++cmd.verbose;
                    break;
                }
                case 1024: {
                    cmd.armor ^= true;
                    break;
                }
                case 1025: {
                    try {
                        cmd.handler = AbstractCallbackHandler.getInstance(g.getOptarg(), new GnuCallbacks());
                    }
                    catch (Exception e) {
                        Main.error("can't load callback handler " + g.getOptarg() + ": " + e.getMessage());
                    }
                    continue block46;
                }
                case 1027: {
                    try {
                        cmd.date = DateFormat.getDateInstance().parse(g.getOptarg());
                    }
                    catch (Exception x) {
                        Main.error("can't format date: " + x.getMessage());
                    }
                    continue block46;
                }
                case 1028: {
                    debug = true;
                    break;
                }
                case 1029: {
                    cmd.noKeystore ^= true;
                    break;
                }
                case 1030: {
                    try {
                        cmd.provider = (Provider)Class.forName(g.getOptarg()).newInstance();
                    }
                    catch (Exception e) {
                        Main.error("can't load class " + g.getOptarg() + ": " + e.getMessage());
                    }
                    continue block46;
                }
                case 1031: {
                    cmd.provider = Security.getProvider(g.getOptarg().intern());
                    if (cmd.provider != null) continue block46;
                    Main.error("provider " + g.getOptarg() + " is not available");
                    break;
                }
                case 1032: {
                    cmd.storeType = g.getOptarg();
                    break;
                }
                case 1033: {
                    try {
                        cmd.validity = Integer.parseInt(g.getOptarg());
                        if (cmd.validity <= 0) {
                            throw new NumberFormatException("must be positive");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        Main.error("invalid validity: " + nfe.getMessage());
                    }
                }
                case 58: 
                case 63: {
                    System.err.println("Try `keytool --help' for more info.");
                    System.exit(1);
                }
            }
        }
        if (commands.size() == 0) {
            System.err.println("keytool: no command given");
            System.err.println("Try `keytool --help' for more info.");
            System.exit(1);
        }
        Iterator it = commands.iterator();
        while (it.hasNext()) {
            try {
                cmd = (Command)it.next();
                cmd.run();
            }
            catch (Throwable t) {
                System.err.println("keytool: " + cmd + ": " + t.getMessage());
                if (debug) {
                    t.printStackTrace();
                }
                if (keep_going) continue;
                System.exit(1);
            }
        }
    }

    private static final void help(PrintStream out) {
        Object msg = null;
        try {
            int i = 1;
            while (true) {
                out.println(MessageFormat.format(messages.getString("usage." + i), PROGNAME));
                ++i;
            }
        }
        catch (MissingResourceException mre) {
            out.println();
            Main.fill(messages.getString("commands"), out);
            out.println();
            int hc = 18;
            out.print("  -d, --delete    ");
            Main.fill(messages.getString("command.delete"), out, hc);
            out.print("  -e, --export    ");
            Main.fill(messages.getString("command.export"), out, hc);
            out.print("  -g, --generate  ");
            Main.fill(messages.getString("command.generate"), out, hc);
            out.print("  -i, --import    ");
            Main.fill(messages.getString("command.import"), out, hc);
            out.print("  -l, --list      ");
            Main.fill(messages.getString("command.list"), out, hc);
            out.print("  -p, --path      ");
            Main.fill(messages.getString("command.path"), out, hc);
            out.print("  -r, --revoke    ");
            Main.fill(messages.getString("command.revoke"), out, hc);
            out.print("  -s, --sign      ");
            Main.fill(messages.getString("command.sign"), out, hc);
            out.print("  -t, --trust     ");
            Main.fill(messages.getString("command.trust"), out, hc);
            out.print("  -h, --help      ");
            Main.fill(messages.getString("command.help"), out, hc);
            out.print("      --version   ");
            Main.fill(messages.getString("command.version"), out, hc);
            out.println();
            Main.fill(messages.getString("options"), out);
            out.println();
            hc = 30;
            out.print("  -a, --alias=NAME            ");
            Main.fill(messages.getString("opt.alias"), out, hc);
            out.print("  -A, --ca-alias=NAME         ");
            Main.fill(messages.getString("opt.ca-alias"), out, hc);
            out.print("      --armor                 ");
            Main.fill(messages.getString("opt.armor"), out, hc);
            out.print("      --callback=TYPE         ");
            Main.fill(messages.getString("opt.callback"), out, hc);
            out.print("      --cert-type=TYPE        ");
            Main.fill(messages.getString("opt.cert-type"), out, hc);
            out.print("      --date=DATE             ");
            Main.fill(messages.getString("opt.date"), out, hc);
            out.print("  -f, --file=FILE             ");
            Main.fill(messages.getString("opt.file"), out, hc);
            out.print("  -k, --keystore=FILE         ");
            Main.fill(messages.getString("opt.keystore"), out, hc);
            out.print("  -K, --secret-keystore=FILE  ");
            Main.fill(messages.getString("opt.secret-keystore"), out, hc);
            out.print("      --truststore=FILE       ");
            Main.fill(messages.getString("opt.truststore"), out, hc);
            out.print("  -n, --keep-going            ");
            Main.fill(messages.getString("opt.keep-going"), out, hc);
            out.print("      --no-keystore           ");
            Main.fill(messages.getString("opt.no-keystore"), out, hc);
            out.print("  -o, --outfile=FILE          ");
            Main.fill(messages.getString("opt.outfile"), out, hc);
            out.print("      --provider=NAME         ");
            Main.fill(messages.getString("opt.provider"), out, hc);
            out.print("      --provider-class=CLASS  ");
            Main.fill(messages.getString("opt.provider-class"), out, hc);
            out.print("      --store-type=TYPE       ");
            Main.fill(messages.getString("opt.store-type"), out, hc);
            out.print("      --validity=DAYS         ");
            Main.fill(messages.getString("opt.validity"), out, hc);
            out.print("  -v, --verbose               ");
            Main.fill(messages.getString("opt.verbose"), out, hc);
            out.print("      -Dname=value            ");
            Main.fill(messages.getString("opt.D"), out, hc);
            return;
        }
    }

    private static final void fill(String message, PrintStream out) {
        Main.fill(message, out, 0);
    }

    /*
     * Unable to fully structure code
     */
    private static final void fill(String message, PrintStream out, int hangColumn) {
        col = hangColumn;
        tok = new StringTokenizer(message);
        token = null;
        ** GOTO lbl25
        {
            out.print(' ');
            ++col;
            do {
                if (col < hangColumn) continue block0;
                if (token == null) {
                    token = tok.nextToken();
                }
                v0 = col + token.length();
                v1 = 0;
                if (col > hangColumn) {
                    v1 = 1;
                }
                if (v0 + v1 > Main.FILL_COLUMN && col != hangColumn) {
                    out.println();
                    col = 0;
                    continue;
                }
                if (col > hangColumn) {
                    ++col;
                    out.print(' ');
                }
                out.print(token);
                col += token.length();
                token = null;
lbl25:
                // 3 sources

            } while (tok.hasMoreTokens() || token != null);
        }
        out.println();
    }

    private static final void version(PrintStream out) {
        out.print(PROGNAME);
        out.print(" (GNU Crypto version ");
        out.print("2.1.0-rc1@PRERELEASE@");
        out.println(")");
        out.println("Copyright (C) 2004  Free Software Foundation, Inc.");
        out.println();
        Main.fill(messages.getString("boilerplate"), out);
    }

    private static final void error(String message) {
        System.err.print(PROGNAME);
        System.err.print(": ");
        System.err.println(message);
        System.exit(1);
    }

    static {
        FILL_COLUMN = 78;
    }
}

