package gnu.crypto;

// ----------------------------------------------------------------------------
// $Id: Registry.java,v 1.13 2002/12/20 01:17:00 rsdio Exp $
//
// Copyright (C) 2001, 2002, Free Software Foundation, Inc.
//
// This file is part of GNU Crypto.
//
// GNU Crypto is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// GNU Crypto is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to the
//
//    Free Software Foundation Inc.,
//    59 Temple Place - Suite 330,
//    Boston, MA 02111-1307
//    USA
//
// Linking this library statically or dynamically with other modules is
// making a combined work based on this library.  Thus, the terms and
// conditions of the GNU General Public License cover the whole
// combination.
//
// As a special exception, the copyright holders of this library give
// you permission to link this library with independent modules to
// produce an executable, regardless of the license terms of these
// independent modules, and to copy and distribute the resulting
// executable under terms of your choice, provided that you also meet,
// for each linked independent module, the terms and conditions of the
// license of that module.  An independent module is a module which is
// not derived from or based on this library.  If you modify this
// library, you may extend this exception to your version of the
// library, but you are not obligated to do so.  If you do not wish to
// do so, delete this exception statement from your version.
// ----------------------------------------------------------------------------

/**
 * <p>A placeholder for <i>names</i> and <i>literals</i> used throughout this
 * library.</p>
 *
 * @version $Revision: 1.13 $
 */
public interface Registry {

   // Constants
   // -------------------------------------------------------------------------

   /** The name of our Provider. */
   String GNU_CRYPTO = "GNU-CRYPTO";

   // Names of properties to use in Maps when initialising primitives .........

   // Symmetric block cipher algorithms and synonyms...........................

   String ANUBIS_CIPHER =   "anubis";
   String BLOWFISH_CIPHER = "blowfish";
   String DES_CIPHER =      "des";
   String KHAZAD_CIPHER =   "khazad";
   String RIJNDAEL_CIPHER = "rijndael";
   String SERPENT_CIPHER =  "serpent";
//   String SERPENT_BITSLICE_CIPHER = "serpent-bitslice";
   String SQUARE_CIPHER =   "square";
   String TRIPLEDES_CIPHER = "tripledes";
   String TWOFISH_CIPHER =  "twofish";
   String NULL_CIPHER =     "null";

   /** AES is synonymous to Rijndael for 128-bit block size only. */
   String AES_CIPHER =      "aes";

   /** TripleDES is also known as DESede. */
   String DESEDE_CIPHER =   "desede";

   // Message digest algorithms and synonyms...................................

   String WHIRLPOOL_HASH = "whirlpool";
   String RIPEMD128_HASH = "ripemd128";
   String RIPEMD160_HASH = "ripemd160";
   String SHA160_HASH =    "sha-160";
   String MD5_HASH =       "md5";
   String MD4_HASH =       "md4";
   String MD2_HASH =       "md2";

   /** RIPEMD-128 is synonymous to RIPEMD128. */
   String RIPEMD_128_HASH = "ripemd-128";

   /** RIPEMD-160 is synonymous to RIPEMD160. */
   String RIPEMD_160_HASH = "ripemd-160";

   /** SHA-1 is synonymous to SHA-160. */
   String SHA_1_HASH =      "sha-1";

   /** SHA1 is synonymous to SHA-160. */
   String SHA1_HASH =      "sha1";

   /** SHA is synonymous to SHA-160. */
   String SHA_HASH =       "sha";

   // Symmetric block cipher modes of operations...............................

   /** Electronic CodeBook mode. */
   String ECB_MODE = "ecb";

   /** Counter (NIST) mode. */
   String CTR_MODE = "ctr";

   /** Integer Counter Mode (David McGrew). */
   String ICM_MODE = "icm";

   /** Output Feedback Mode (NIST). */
   String OFB_MODE = "ofb";

   /** Cipher block chaining mode (NIST). */
   String CBC_MODE = "cbc";

   /** Cipher feedback mode (NIST). */
   String CFB_MODE = "cfb";

   // Padding scheme names and synonyms........................................

   /** PKCS#7 padding scheme. */
   String PKCS7_PAD = "pkcs7";

   /** Trailing Bit Complement padding scheme. */
   String TBC_PAD =   "tbc";

   // Pseudo-random number generators..........................................

   /** (Apparently) RC4 keystream PRNG. */
   String ARCFOUR_PRNG = "arcfour";

   /** We use "rc4" as an alias for "arcfour". */
   String RC4_PRNG = "rc4";

   /** PRNG based on David McGrew's Integer Counter Mode. */
   String ICM_PRNG = "icm";

   /** PRNG based on a designated hash functiopn. */
   String MD_PRNG =  "md";

   /** PRNG based on UMAC's Key Derivation Function. */
   String UMAC_PRNG = "umac-kdf";

   // Asymmetric keypair generators............................................

   String DSS_KPG = "dss";
   String RSA_KPG = "rsa";

   /** DSA is synonymous to DSS. */
   String DSA_KPG = "dsa";

   // Signature-with-appendix schemes..........................................

   String DSS_SIG =     "dss";
   String RSA_PSS_SIG = "rsa-pss";

   /** DSA is synonymous to DSS. */
   String DSA_SIG =     "dsa";

   // Keyed-Hash Message Authentication Code ..................................

   /** Name prefix of every HMAC implementation. */
   String HMAC_NAME_PREFIX = "hmac-";

   // Other MAC algorithms ....................................................

   /** Message Authentication Code using Universal Hashing (Ted Krovetz). */
   String UHASH32 = "uhash32";
   String UMAC32 = "umac32";
   /** The Truncated Multi-Modular Hash Function -v1 (David McGrew). */
   String TMMH16 = "tmmh16";
//   String TMMH32 = "tmmh32";

   // Format IDs used to identify how we externalise asymmetric keys ..........
   int RAW_ENCODING_ID = 1;

   // Magic bytes we generate/expect in externalised asymmetric keys ..........
   // the four bytes represent G (0x47) for GNU, 1 (0x01) for Raw format,
   // D (0x44) for DSS or R (0x52) for RSA, and finally P (0x50) for Public,
   // p (0x70) for private, or S (0x53) for signature.
   byte[] MAGIC_RAW_DSS_PUBLIC_KEY =    new byte[] {0x47, RAW_ENCODING_ID, 0x44, 0x50};
   byte[] MAGIC_RAW_DSS_PRIVATE_KEY =   new byte[] {0x47, RAW_ENCODING_ID, 0x44, 0x70};
   byte[] MAGIC_RAW_DSS_SIGNATURE =     new byte[] {0x47, RAW_ENCODING_ID, 0x44, 0x53};
   byte[] MAGIC_RAW_RSA_PUBLIC_KEY =    new byte[] {0x47, RAW_ENCODING_ID, 0x52, 0x50};
   byte[] MAGIC_RAW_RSA_PRIVATE_KEY =   new byte[] {0x47, RAW_ENCODING_ID, 0x52, 0x70};
   byte[] MAGIC_RAW_RSA_PSS_SIGNATURE = new byte[] {0x47, RAW_ENCODING_ID, 0x52, 0x53};

   // Methods
   // -------------------------------------------------------------------------
}
