/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.gnupg;

import com.freiheit.gnupg.GnuPGPeer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GnuPGData
extends GnuPGPeer {
    protected GnuPGData() {
        this.setInternalRepresentation(this.gpgmeDataNew());
    }

    protected GnuPGData(String str) {
        this(str.getBytes());
    }

    protected GnuPGData(byte[] data) {
        this.setInternalRepresentation(this.gpgmeDataNewFromMem(data));
    }

    public void write(OutputStream out) throws IOException {
        if (out != null) {
            this.gpgmeDataWrite(this.getInternalRepresentation(), out);
        }
    }

    public String toString() {
        String result = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.write(baos);
            result = baos.toString();
        }
        catch (IOException ioe) {
            result = ioe.getMessage();
        }
        return result;
    }

    public void destroy() {
        if (this.getInternalRepresentation() != 0) {
            this.gpgmeDataRelease(this.getInternalRepresentation());
            this.setInternalRepresentation(0);
        }
    }

    protected void finalize() {
        this.destroy();
    }

    private native int gpgmeDataNewFromMem(byte[] var1);

    private native int gpgmeDataNew();

    private native void gpgmeDataWrite(int var1, OutputStream var2) throws IOException;

    private native void gpgmeDataRelease(int var1);

    private native void gpgmeDataRead(int var1, InputStream var2) throws IOException;
}

