/* openssl dhparam -C -2 2048 */
#ifndef HEADER_DH_H
#include <openssl/dh.h>
#endif
static DH *get_dh2048()
	{
	static unsigned char dh2048_p[]={
		0xC8,0xF1,0xD4,0x48,0xB6,0x11,0x5B,0x2B,0x9E,0x3D,0xE4,0x49,
		0x0A,0xC4,0x8A,0x0B,0xFF,0xAC,0x09,0x4F,0x88,0x91,0x08,0xB8,
		0x7D,0x71,0xB7,0x7D,0x87,0x44,0x09,0x70,0x15,0xFF,0x0C,0xAF,
		0x9D,0xCD,0xC0,0x19,0x67,0xC2,0x4D,0xF3,0x8E,0x95,0x4E,0x60,
		0xA3,0x99,0xC2,0x94,0x39,0x0A,0xAE,0x7D,0x71,0x88,0x87,0xBE,
		0x53,0x39,0x86,0x5B,0xEE,0xA4,0xC1,0xA4,0x9B,0x33,0x19,0xCD,
		0x64,0xFB,0x30,0xA1,0x87,0xA7,0x07,0x2D,0x34,0x82,0xD8,0xE6,
		0xF1,0xBB,0x9F,0x3D,0xA7,0x45,0x97,0x42,0xAE,0x1A,0x46,0x55,
		0xA6,0x67,0x18,0x70,0x60,0x5B,0xCA,0x0D,0x21,0xF0,0xEB,0xF3,
		0xF5,0x68,0xED,0x61,0xC0,0x51,0x4E,0x28,0x24,0x9E,0x77,0x23,
		0x7C,0xD1,0xE5,0x5A,0x0A,0xEF,0xC7,0xCC,0x0E,0x86,0xA8,0xBC,
		0x92,0x9F,0x8C,0xA5,0xE8,0xBD,0x75,0xB7,0x7F,0x75,0x81,0x56,
		0xD2,0xF9,0x68,0xA9,0x98,0x98,0x3D,0xA8,0xBC,0xBC,0xD4,0x81,
		0xD9,0xBE,0x0F,0x09,0x25,0x47,0x43,0xB8,0xEB,0x5C,0xE4,0xA0,
		0x10,0x57,0xEF,0xD8,0xDB,0x6A,0x01,0xD0,0x2A,0x7D,0xCC,0x27,
		0x8A,0x81,0x1C,0xEA,0xDF,0x21,0xBF,0xA1,0xF0,0xBF,0xC1,0xA1,
		0x12,0xFF,0xB2,0xAD,0x4F,0x41,0xF5,0x82,0x9D,0xC0,0xEE,0x2D,
		0x1C,0x56,0x2E,0x90,0x33,0x70,0x1A,0xFE,0x6D,0xBC,0xA4,0x8D,
		0x89,0x1A,0x18,0xAB,0xA9,0xAB,0xBD,0x1D,0xA6,0x57,0xD7,0x77,
		0x59,0xD6,0x7C,0xC7,0xEB,0x34,0x2F,0xD8,0x53,0x30,0x1A,0x2E,
		0x7C,0x83,0xB9,0x40,0x7A,0x2E,0xA4,0x1D,0x85,0x68,0x69,0x66,
		0xF8,0xAA,0x70,0x6B,
		};
	static unsigned char dh2048_g[]={
		0x02,
		};
	DH *dh;

	if ((dh=DH_new()) == NULL) return(NULL);
	dh->p=BN_bin2bn(dh2048_p,sizeof(dh2048_p),NULL);
	dh->g=BN_bin2bn(dh2048_g,sizeof(dh2048_g),NULL);
	if ((dh->p == NULL) || (dh->g == NULL))
		{ DH_free(dh); return(NULL); }
	return(dh);
	}
/*
-----BEGIN DH PARAMETERS-----
MIIBCAKCAQEAyPHUSLYRWyuePeRJCsSKC/+sCU+IkQi4fXG3fYdECXAV/wyvnc3A
GWfCTfOOlU5go5nClDkKrn1xiIe+UzmGW+6kwaSbMxnNZPswoYenBy00gtjm8buf
PadFl0KuGkZVpmcYcGBbyg0h8Ovz9WjtYcBRTigknncjfNHlWgrvx8wOhqi8kp+M
pei9dbd/dYFW0vloqZiYPai8vNSB2b4PCSVHQ7jrXOSgEFfv2NtqAdAqfcwnioEc
6t8hv6Hwv8GhEv+yrU9B9YKdwO4tHFYukDNwGv5tvKSNiRoYq6mrvR2mV9d3WdZ8
x+s0L9hTMBoufIO5QHoupB2FaGlm+KpwawIBAg==
-----END DH PARAMETERS-----
*/
